package com.yodo1.advert.factory;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.entity.AdvertType;
import com.yodo1.android.ops.net.Yodo1HttpManage;
import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.onlineconfig.Yodo1OnlineConfigListener;
import com.yodo1.plugin.dmp.yodo1.open.Yodo1Analytics;
import com.yodo1.sdk.kit.YLog;

import java.util.Map;

@TargetApi(Build.VERSION_CODES.HONEYCOMB)
public class RequestManagerFragment extends Fragment {


    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);

    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {

        return super.onCreateView(inflater, container, savedInstanceState);
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);

    }

    @Override
    public void onStart() {
        super.onStart();

        YLog.d("RequestManagerFragment   onStart");

        Yodo1OnlineConfig.getInstance().getOnlineConfig(new Yodo1OnlineConfigListener() {
            @Override
            public void getDataFinish(int code, String onlineConfig) {

            }
        });
        if (Yodo1OnlineConfig.getInstance().hasData()) {
            for (AdvertType type : AdvertType.values()) {
                for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters(type).entrySet()) {
                    if (adapter.getValue() != null) {
                        adapter.getValue().onResume(RequestManagerFragment.this.getActivity());
                    }
                }
            }
            Yodo1Analytics.onResume(RequestManagerFragment.this.getActivity());
        }


    }

    @Override
    public void onResume() {
        super.onResume();


    }

    @Override
    public void onPause() {
        super.onPause();

    }

    @Override
    public void onStop() {
        super.onStop();

        YLog.d("RequestManagerFragment   onStop");

        for (AdvertType type : AdvertType.values()) {
            for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters(type).entrySet()) {
                if (adapter.getValue() != null) {
                    adapter.getValue().onPause(RequestManagerFragment.this.getActivity());
                }
            }
        }
        Yodo1Analytics.onPause(RequestManagerFragment.this.getActivity());

    }


    @Override
    public void onDestroy() {
        super.onDestroy();

        YLog.d("RequestManagerFragment   onDestroy");

        for (AdvertType type : AdvertType.values()) {
            for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters(type).entrySet()) {
                if (adapter.getValue() != null) {
                    adapter.getValue().onDestroy(RequestManagerFragment.this.getActivity());
                }
            }
        }

        Yodo1Analytics.onDestroy();
        Yodo1HttpManage.getInstance().onDestroy();
    }


}
