package com.yodo1.advert.banner.channel;


import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;

import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.banner.AdBannerAdapterBase;
import com.yodo1.advert.banner.Yodo1BannerAlign;
import com.yodo1.advert.plugin.yodo1.AdConfigYodo1;
import com.yodo1.nohttp.NoHttp;
import com.yodo1.nohttp.RequestMethod;
import com.yodo1.nohttp.rest.CacheMode;
import com.yodo1.nohttp.rest.OnResponseListener;
import com.yodo1.nohttp.rest.Request;
import com.yodo1.nohttp.rest.RequestQueue;
import com.yodo1.nohttp.rest.Response;
import com.yodo1.sdk.kit.YLog;

import java.io.IOException;
import java.io.InputStream;


/**
 * Created by yodo1 on 2016/4/7.
 */
public class AdvertAdapteryodo1 extends AdBannerAdapterBase {
    private int align = Yodo1BannerAlign.BannerAlignHorizontalCenter | Yodo1BannerAlign.BannerAlignBottom;
    private Yodo1AdCallback callback;
    private ImageView bannerView;
    private boolean isShowSuccess = false;

    @Override
    public String getAdvertCode() {
        return AdConfigYodo1.CHANNEL_CODE;
    }

    @Override
    public void validateAdsAdapter(Activity activity) {
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(final Activity activity) {

        bannerView = new ImageView(activity);

        loadBannerAds(bannerView);
//        Bitmap bm = getImageFromAssetsFile(activity,"yodo1banner.jpg");
//        bannerView.setImageBitmap(bm);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(600,
                100);//两个400分别为添加图片的大小
        bannerView.setLayoutParams(params);
        bannerView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (callback!=null){
                    AdConfigYodo1.goYodo1Web(activity);
                    callback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
                }
            }
        });
    }


    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }



    @Override
    public void onDestroy(Activity activity) {

    }



    @Override
    public void showBanner(Activity activity,final Yodo1AdCallback callback) {
        this.callback = callback;
        if (bannerView!=null){
            isShowSuccess = true;
            Yodo1BannerAlign.setYodo1BannerLayout(activity,bannerView,align);
            callback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_COMMON, "",getAdvertCode());
        }



    }

    @Override
    public void removeBanner(Activity activity) {
        if (bannerView != null && isShowSuccess){
            isShowSuccess = false;
            Yodo1BannerAlign.removeYodo1BannerLayout(activity,bannerView);
            if (callback != null){
                callback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

    }

    @Override
    public void hideBanner(Activity activity) {
        YLog.d("Yodo1 hideBanner ");
        if (bannerView != null && isShowSuccess){
            isShowSuccess = false;
            Yodo1BannerAlign.removeYodo1BannerLayout(activity,bannerView);
            if (callback != null){
                callback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

    }

    @Override
    public void setBannerAlign(Activity activity, int align) {
        this.align = align;

    }

    @Override
    public boolean hasLoadBanner() {
        return true;
    }


    /**
     * 加载Banner
     */
    public void loadBannerAds(final ImageView imageView){
        RequestQueue requestQueue = NoHttp.newRequestQueue();
        String url = "https://docs.yodo1.com/media/ad-test-resource/ad-banner1.png";
        Request<Bitmap> requeset = NoHttp.createImageRequest(url, RequestMethod.GET);
        OnResponseListener<Bitmap> listener = new OnResponseListener<Bitmap>() {
            @Override
            public void onStart(int what) {
            }

            @Override
            public void onSucceed(int what, Response<Bitmap> response) {
                Bitmap bm = response.get();

                if (callback!=null){
                    callback.onEvent(Yodo1AdConst.ADVERT_EVENT_LOADED, getAdvertCode());
                }
                imageView.setImageBitmap(bm);

            }

            @Override
            public void onFailed(int what, Response<Bitmap> response) {
                if (callback!=null){
                    callback.onEvent(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, getAdvertCode());
                }
            }

            @Override
            public void onFinish(int what) {
            }
        };
        //设置缓存模式
        requeset.setCacheMode(CacheMode.REQUEST_NETWORK_FAILED_READ_CACHE);
        requestQueue.add(1, requeset, listener);
    }

}
