/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.facebook;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.View;
import android.widget.FrameLayout;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.AdSettings;
import com.facebook.ads.AdSize;
import com.facebook.ads.AdView;
import com.facebook.ads.AudienceNetworkAds;
import com.facebook.ads.InterstitialAd;
import com.facebook.ads.InterstitialAdListener;
import com.facebook.ads.RewardData;
import com.facebook.ads.RewardedVideoAd;
import com.facebook.ads.RewardedVideoAdListener;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AdapterUtils;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.IntegrationData;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.sdk.BannerSmashListener;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;

public class FacebookAdapter
extends AbstractAdapter {
    private static final String VERSION = "4.3.3";
    private static final String GitHash = "5369dc133";
    private static final String MEDIATION_SERVICE_NAME = "Supersonic";
    public static int BN_FAILED_TO_RELOAD_ERROR_CODE = 103;
    private final String PLACEMENT_ID = "placementId";
    private ConcurrentHashMap<String, InterstitialSmashListener> mISPlacementToListenerMap;
    private ConcurrentHashMap<String, RewardedVideoSmashListener> mRVPlacementToListenerMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, BannerSmashListener> mBNPlacementToListenerMap;
    private ConcurrentHashMap<String, InterstitialAd> mISPlacementToAdMap;
    private ConcurrentHashMap<String, RewardedVideoAd> mRVPlacementToAdMap;
    private ConcurrentHashMap<String, AdView> mBNPlacementToAdMap;
    private ConcurrentHashMap<String, FacebookRewardedVideoAdListener> mRVPlacementToFBListener;
    private ConcurrentHashMap<String, FacebookInterstitialAdListener> mISPlacementToFBListener;
    private HashSet<String> mRvPlacementReady;
    private HashSet<String> mIsPlacementReady;
    private Context mContext;
    private Boolean mDidInitSuccess = null;
    private boolean mDidCallInit = false;

    public static FacebookAdapter startAdapter(String string) {
        return new FacebookAdapter(string);
    }

    public static IntegrationData getIntegrationData(Activity activity) {
        activity = new IntegrationData("Facebook", VERSION);
        new IntegrationData("Facebook", VERSION).activities = new String[]{"com.facebook.ads.AudienceNetworkActivity", "com.facebook.ads.internal.ipc.RemoteANActivity"};
        activity.services = new String[]{"com.facebook.ads.internal.ipc.AdsProcessPriorityService", "com.facebook.ads.internal.ipc.AdsMessengerService"};
        return activity;
    }

    private FacebookAdapter(String string) {
        super(string);
        this.mISPlacementToListenerMap = new ConcurrentHashMap();
        this.mBNPlacementToListenerMap = new ConcurrentHashMap();
        this.mRVPlacementToAdMap = new ConcurrentHashMap();
        this.mISPlacementToAdMap = new ConcurrentHashMap();
        this.mBNPlacementToAdMap = new ConcurrentHashMap();
        this.mRVPlacementToFBListener = new ConcurrentHashMap();
        this.mISPlacementToFBListener = new ConcurrentHashMap();
        this.mRvPlacementReady = new HashSet();
        this.mIsPlacementReady = new HashSet();
        AdSettings.setMediationService((String)MEDIATION_SERVICE_NAME);
    }

    public String getVersion() {
        return VERSION;
    }

    public String getCoreSDKVersion() {
        return FacebookAdapter.getAdapterSDKVersion();
    }

    public static String getAdapterSDKVersion() {
        return "5.3.1";
    }

    public synchronized void initRewardedVideo(Activity activity, String string, String object, JSONObject jSONObject, RewardedVideoSmashListener rewardedVideoSmashListener) {
        if (rewardedVideoSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " RV init failed: listener is empty", 2);
            return;
        }
        if (activity == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " Interstitial init failed: mContext is empty", 2);
            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            return;
        }
        string = jSONObject.optString("placementId");
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " initRewardedVideo failed: empty placementId", 2);
            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            return;
        }
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " initRewardedVideo <" + string + ">", 1);
        object = new FacebookRewardedVideoAdListener(rewardedVideoSmashListener, string);
        this.mRVPlacementToFBListener.put(string, (FacebookRewardedVideoAdListener)object);
        this.mRVPlacementToListenerMap.put(string, rewardedVideoSmashListener);
        this.mContext = activity.getApplicationContext();
        this.initSdk();
        if (this.mDidInitSuccess != null) {
            if (this.mDidInitSuccess.booleanValue()) {
                this.loadRewardedVideo(string);
                return;
            }
            this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " initRewardedVideo <" + string + "> failed", 1);
            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
        }
    }

    public synchronized void fetchRewardedVideo(JSONObject jSONObject) {
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " fetchRewardedVideo <" + jSONObject.optString("placementId") + ">", 1);
        this.loadRewardedVideo(jSONObject.optString("placementId"));
    }

    public synchronized boolean isRewardedVideoAvailable(JSONObject jSONObject) {
        return this.mRvPlacementReady.contains(jSONObject.optString("placementId"));
    }

    public synchronized void showRewardedVideo(JSONObject object, RewardedVideoSmashListener rewardedVideoSmashListener) {
        object = object.optString("placementId");
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " showRewardedVideo <" + (String)object + ">", 1);
        this.mRvPlacementReady.remove(object);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable((String)object, rewardedVideoSmashListener){
            final /* synthetic */ String val$placementId;
            final /* synthetic */ RewardedVideoSmashListener val$listener;
            {
                this.val$placementId = string;
                this.val$listener = rewardedVideoSmashListener;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FacebookAdapter facebookAdapter = FacebookAdapter.this;
                synchronized (facebookAdapter) {
                    try {
                        RewardedVideoAd rewardedVideoAd = (RewardedVideoAd)FacebookAdapter.this.mRVPlacementToAdMap.get(this.val$placementId);
                        if (rewardedVideoAd != null && rewardedVideoAd.isAdLoaded()) {
                            if (!TextUtils.isEmpty((CharSequence)FacebookAdapter.this.getDynamicUserId())) {
                                rewardedVideoAd.setRewardData(new RewardData(FacebookAdapter.this.getDynamicUserId(), "1"));
                            }
                            rewardedVideoAd.show();
                        } else {
                            this.val$listener.onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Rewarded Video"));
                        }
                    }
                    catch (Exception exception) {
                        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Facebook rewarded video show failed - " + exception.getMessage(), 3);
                        this.val$listener.onRewardedVideoAdShowFailed(ErrorBuilder.buildShowFailedError((String)"Rewarded Video", (String)exception.getMessage()));
                    }
                    this.val$listener.onRewardedVideoAvailabilityChanged(false);
                    return;
                }
            }
        });
    }

    public synchronized void initInterstitial(Activity activity, String string, String object, JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        if (interstitialSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " IS init failed: listener is empty", 2);
            return;
        }
        if (activity == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " Interstitial init failed: mContext is empty", 2);
            interstitialSmashListener.onInterstitialInitFailed(new IronSourceError(508, "empty mContext"));
            return;
        }
        string = jSONObject.optString("placementId");
        if (TextUtils.isEmpty((CharSequence)string)) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " Interstitial init failed: empty placementId", 2);
            interstitialSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing params", (String)"Interstitial"));
            return;
        }
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " initInterstitial <" + string + ">", 1);
        object = new FacebookInterstitialAdListener(interstitialSmashListener, string);
        this.mContext = activity.getApplicationContext();
        this.mISPlacementToListenerMap.put(string, interstitialSmashListener);
        this.mISPlacementToFBListener.put(string, (FacebookInterstitialAdListener)object);
        this.initSdk();
        if (this.mDidInitSuccess != null) {
            if (this.mDidInitSuccess.booleanValue()) {
                interstitialSmashListener.onInterstitialInitSuccess();
                return;
            }
            interstitialSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"init failed", (String)"Interstitial"));
        }
    }

    public synchronized void loadInterstitial(final JSONObject jSONObject, final InterstitialSmashListener interstitialSmashListener) {
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " loadInterstitial <" + jSONObject.optString("placementId") + ">", 1);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FacebookAdapter facebookAdapter = FacebookAdapter.this;
                synchronized (facebookAdapter) {
                    try {
                        String string = jSONObject.optString("placementId");
                        if (!TextUtils.isEmpty((CharSequence)string)) {
                            if (FacebookAdapter.this.mISPlacementToAdMap.containsKey(string)) {
                                ((InterstitialAd)FacebookAdapter.this.mISPlacementToAdMap.get(string)).destroy();
                                FacebookAdapter.this.mISPlacementToAdMap.remove(string);
                            }
                            InterstitialAd interstitialAd = new InterstitialAd(FacebookAdapter.this.mContext, string);
                            interstitialAd.setAdListener((InterstitialAdListener)FacebookAdapter.this.mISPlacementToFBListener.get(string));
                            interstitialAd.loadAd();
                            FacebookAdapter.this.mISPlacementToAdMap.put(string, interstitialAd);
                        } else {
                            interstitialSmashListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)"empty placementId"));
                        }
                    }
                    catch (Exception exception) {
                        interstitialSmashListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)exception.getLocalizedMessage()));
                    }
                    return;
                }
            }
        });
    }

    public synchronized void showInterstitial(JSONObject object, InterstitialSmashListener interstitialSmashListener) {
        object = object.optString("placementId");
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " showInterstitial <" + (String)object + ">", 1);
        this.mIsPlacementReady.remove(object);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable((String)object, interstitialSmashListener){
            final /* synthetic */ String val$placementId;
            final /* synthetic */ InterstitialSmashListener val$listener;
            {
                this.val$placementId = string;
                this.val$listener = interstitialSmashListener;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FacebookAdapter facebookAdapter = FacebookAdapter.this;
                synchronized (facebookAdapter) {
                    try {
                        if (FacebookAdapter.this.mISPlacementToAdMap.containsKey(this.val$placementId) && ((InterstitialAd)FacebookAdapter.this.mISPlacementToAdMap.get(this.val$placementId)).isAdLoaded()) {
                            ((InterstitialAd)FacebookAdapter.this.mISPlacementToAdMap.get(this.val$placementId)).show();
                        } else {
                            this.val$listener.onInterstitialAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Interstitial"));
                        }
                    }
                    catch (Exception exception) {
                        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Facebook Interstitial show failed - " + exception.getMessage(), 3);
                        this.val$listener.onInterstitialAdShowFailed(ErrorBuilder.buildShowFailedError((String)"Interstitial", (String)exception.getMessage()));
                    }
                    return;
                }
            }
        });
    }

    public synchronized boolean isInterstitialReady(JSONObject jSONObject) {
        return this.mIsPlacementReady.contains(jSONObject.optString("placementId"));
    }

    public synchronized void initBanners(Activity activity, String string, String string2, JSONObject jSONObject, BannerSmashListener bannerSmashListener) {
        if (bannerSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " Banner init failed: BannerSmashListener is empty", 2);
            return;
        }
        if (activity == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " Banner init failed: mContext is empty", 2);
            bannerSmashListener.onBannerInitFailed(new IronSourceError(508, "empty mContext"));
            return;
        }
        string = jSONObject.optString("placementId");
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " initBanners <" + string + ">", 1);
        this.mContext = activity.getApplicationContext();
        this.mBNPlacementToListenerMap.put(string, bannerSmashListener);
        this.initSdk();
        if (this.mDidInitSuccess != null) {
            if (this.mDidInitSuccess.booleanValue()) {
                bannerSmashListener.onBannerInitSuccess();
                return;
            }
            bannerSmashListener.onBannerInitFailed(new IronSourceError(508, "init failed"));
        }
    }

    public synchronized void loadBanner(final IronSourceBannerLayout ironSourceBannerLayout, JSONObject object, BannerSmashListener bannerSmashListener) {
        if (bannerSmashListener == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "Facebook loadBanner listener == null", 3);
            return;
        }
        if (ironSourceBannerLayout == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "Facebook loadBanner banner == null", 3);
            object = ErrorBuilder.buildLoadFailedError((String)"banner layout is null");
            bannerSmashListener.onBannerAdLoadFailed((IronSourceError)object);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)(object = object.optString("placementId")))) {
            IronSourceError ironSourceError = ErrorBuilder.buildLoadFailedError((String)"FacebookAdapter loadBanner placementId is empty");
            bannerSmashListener.onBannerAdLoadFailed(ironSourceError);
            return;
        }
        AdSize adSize = this.calculateBannerSize(ironSourceBannerLayout.getSize(), AdapterUtils.isLargeScreen((Activity)ironSourceBannerLayout.getActivity()));
        if (adSize == null) {
            ErrorBuilder.buildLoadFailedError((String)"FacebookAdapter adSize is empty");
            bannerSmashListener.onBannerAdLoadFailed(ErrorBuilder.unsupportedBannerSize((String)"Facebook"));
            return;
        }
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " loadBanner <" + (String)object + ">", 1);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable((String)object, adSize, bannerSmashListener){
            final /* synthetic */ String val$placementId;
            final /* synthetic */ AdSize val$adSize;
            final /* synthetic */ BannerSmashListener val$listener;
            {
                this.val$placementId = string;
                this.val$adSize = adSize;
                this.val$listener = bannerSmashListener;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FacebookAdapter facebookAdapter = FacebookAdapter.this;
                synchronized (facebookAdapter) {
                    try {
                        AdView adView = new AdView((Context)ironSourceBannerLayout.getActivity(), this.val$placementId, this.val$adSize);
                        FrameLayout.LayoutParams layoutParams = FacebookAdapter.this.calcLayoutParams(ironSourceBannerLayout.getSize(), ironSourceBannerLayout.getActivity());
                        layoutParams = FacebookAdapter.this.createBannerAdListener(layoutParams);
                        adView.setAdListener((AdListener)layoutParams);
                        FacebookAdapter.this.mBNPlacementToAdMap.put(this.val$placementId, adView);
                        adView.loadAd();
                    }
                    catch (Exception exception) {
                        IronSourceError ironSourceError = ErrorBuilder.buildLoadFailedError((String)("FacebookAdapter loadBanner exception " + exception.getMessage()));
                        this.val$listener.onBannerAdLoadFailed(ironSourceError);
                    }
                    return;
                }
            }
        });
    }

    public synchronized void destroyBanner(final JSONObject jSONObject) {
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " destroyBanner <" + jSONObject.optString("placementId") + ">", 1);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FacebookAdapter facebookAdapter = FacebookAdapter.this;
                synchronized (facebookAdapter) {
                    try {
                        String string = jSONObject.optString("placementId");
                        if (FacebookAdapter.this.mBNPlacementToAdMap.containsKey(string)) {
                            ((AdView)FacebookAdapter.this.mBNPlacementToAdMap.get(string)).destroy();
                            FacebookAdapter.this.mBNPlacementToAdMap.remove(string);
                        }
                    }
                    catch (Exception exception) {
                        FacebookAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, FacebookAdapter.this.getProviderName() + ":destroyBanner() failed with an exception: " + exception, 2);
                    }
                    return;
                }
            }
        });
    }

    public synchronized void reloadBanner(final JSONObject jSONObject) {
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " reloadBanner <" + jSONObject.optString("placementId") + ">", 0);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FacebookAdapter facebookAdapter = FacebookAdapter.this;
                synchronized (facebookAdapter) {
                    String string = jSONObject.optString("placementId");
                    if (FacebookAdapter.this.mBNPlacementToAdMap.containsKey(string)) {
                        ((AdView)FacebookAdapter.this.mBNPlacementToAdMap.get(string)).loadAd();
                    } else if (FacebookAdapter.this.mBNPlacementToListenerMap.containsKey(string)) {
                        ((BannerSmashListener)FacebookAdapter.this.mBNPlacementToListenerMap.get(string)).onBannerAdLoadFailed(new IronSourceError(BN_FAILED_TO_RELOAD_ERROR_CODE, FacebookAdapter.this.getProviderName() + "reloadBanner missing banner " + string));
                    }
                    return;
                }
            }
        });
    }

    private synchronized void loadRewardedVideo(final String string) {
        if (this.mContext != null) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    FacebookAdapter facebookAdapter = FacebookAdapter.this;
                    synchronized (facebookAdapter) {
                        block7: {
                            try {
                                if (!TextUtils.isEmpty((CharSequence)string)) {
                                    if (FacebookAdapter.this.mRVPlacementToAdMap.containsKey(string)) {
                                        ((RewardedVideoAd)FacebookAdapter.this.mRVPlacementToAdMap.get(string)).destroy();
                                        FacebookAdapter.this.mRVPlacementToAdMap.remove(string);
                                    }
                                    RewardedVideoAd rewardedVideoAd = new RewardedVideoAd(FacebookAdapter.this.mContext, string);
                                    rewardedVideoAd.setAdListener((RewardedVideoAdListener)FacebookAdapter.this.mRVPlacementToFBListener.get(string));
                                    rewardedVideoAd.loadAd();
                                    FacebookAdapter.this.mRVPlacementToAdMap.put(string, rewardedVideoAd);
                                }
                            }
                            catch (Exception exception) {
                                if (!FacebookAdapter.this.mRVPlacementToListenerMap.containsKey(string)) break block7;
                                ((RewardedVideoSmashListener)FacebookAdapter.this.mRVPlacementToListenerMap.get(string)).onRewardedVideoAvailabilityChanged(false);
                            }
                        }
                        return;
                    }
                }
            });
            return;
        }
        if (this.mRVPlacementToListenerMap.containsKey(string)) {
            this.mRVPlacementToListenerMap.get(string).onRewardedVideoAvailabilityChanged(false);
        }
    }

    private AdSize calculateBannerSize(ISBannerSize iSBannerSize, boolean bl) {
        switch (iSBannerSize.getDescription()) {
            case "BANNER": {
                return AdSize.BANNER_HEIGHT_50;
            }
            case "LARGE": {
                return AdSize.BANNER_HEIGHT_90;
            }
            case "RECTANGLE": {
                return AdSize.RECTANGLE_HEIGHT_250;
            }
            case "SMART": {
                if (bl) {
                    return AdSize.BANNER_HEIGHT_90;
                }
                return AdSize.BANNER_HEIGHT_50;
            }
            case "CUSTOM": {
                if (iSBannerSize.getHeight() == 50) {
                    return AdSize.BANNER_HEIGHT_50;
                }
                if (iSBannerSize.getHeight() == 90) {
                    return AdSize.BANNER_HEIGHT_90;
                }
                if (iSBannerSize.getHeight() != 250) break;
                return AdSize.RECTANGLE_HEIGHT_250;
            }
        }
        return null;
    }

    private FrameLayout.LayoutParams calcLayoutParams(ISBannerSize iSBannerSize, Activity activity) {
        int n2 = 320;
        if (iSBannerSize.getDescription().equals("RECTANGLE")) {
            n2 = 300;
        } else if (iSBannerSize.getDescription().equals("SMART") && AdapterUtils.isLargeScreen((Activity)activity)) {
            n2 = 728;
        }
        int n3 = AdapterUtils.dpToPixels((Activity)activity, (int)n2);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3, -2);
        new FrameLayout.LayoutParams(n3, -2).gravity = 17;
        return layoutParams;
    }

    private synchronized void initSdk() {
        if (!this.mDidCallInit) {
            this.mDidCallInit = true;
            if (AudienceNetworkAds.isInAdsProcess((Context)this.mContext)) {
                this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " initSdk: isInAdsProcess is true, no need to init", 1);
                this.mDidInitSuccess = Boolean.TRUE;
                return;
            }
            AudienceNetworkAds.buildInitSettings((Context)this.mContext).withInitListener(new AudienceNetworkAds.InitListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onInitialized(AudienceNetworkAds.InitResult object) {
                    FacebookAdapter facebookAdapter = FacebookAdapter.this;
                    synchronized (facebookAdapter) {
                        FacebookAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, FacebookAdapter.this.getProviderName() + " init SDK is completed with status: " + object.isSuccess() + ", " + object.getMessage(), 1);
                        if (object.isSuccess()) {
                            FacebookAdapter.this.mDidInitSuccess = Boolean.TRUE;
                            for (Object object2 : FacebookAdapter.this.mBNPlacementToListenerMap.values()) {
                                object2.onBannerInitSuccess();
                            }
                            for (Object object2 : FacebookAdapter.this.mISPlacementToListenerMap.values()) {
                                object2.onInterstitialInitSuccess();
                            }
                            for (Object object2 : FacebookAdapter.this.mRVPlacementToListenerMap.keySet()) {
                                FacebookAdapter.this.loadRewardedVideo((String)object2);
                            }
                        } else {
                            FacebookAdapter.this.mDidInitSuccess = Boolean.FALSE;
                            object = "init failed:" + object.getMessage();
                            for (BannerSmashListener bannerSmashListener : FacebookAdapter.this.mBNPlacementToListenerMap.values()) {
                                bannerSmashListener.onBannerInitFailed(new IronSourceError(508, (String)object));
                            }
                            for (BannerSmashListener bannerSmashListener : FacebookAdapter.this.mISPlacementToListenerMap.values()) {
                                bannerSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)object, (String)"Interstitial"));
                            }
                            for (BannerSmashListener bannerSmashListener : FacebookAdapter.this.mRVPlacementToListenerMap.values()) {
                                bannerSmashListener.onRewardedVideoAvailabilityChanged(false);
                            }
                        }
                        return;
                    }
                }
            }).initialize();
        }
    }

    private AdListener createBannerAdListener(final FrameLayout.LayoutParams layoutParams) {
        return new AdListener(){

            public void onError(Ad ad2, AdError object) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "Banner Ad, onError (" + object.getErrorCode() + "): " + object.getErrorMessage(), 1);
                if (FacebookAdapter.this.mBNPlacementToListenerMap.containsKey(ad2.getPlacementId())) {
                    int n2;
                    ad2 = (BannerSmashListener)FacebookAdapter.this.mBNPlacementToListenerMap.get(ad2.getPlacementId());
                    int n3 = n2 = object.getErrorCode() == 1001 ? 606 : object.getErrorCode();
                    if (object.getErrorMessage() != null) {
                        object = object.getErrorCode() + ":" + object.getErrorMessage();
                        ad2.onBannerAdLoadFailed(new IronSourceError(n2, (String)object));
                        return;
                    }
                    ad2.onBannerAdLoadFailed(new IronSourceError(n2, "Empty error string"));
                }
            }

            public void onAdLoaded(Ad ad2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "Banner Ad, onAdLoaded <" + ad2.getPlacementId() + ">", 1);
                if (FacebookAdapter.this.mBNPlacementToListenerMap.containsKey(ad2.getPlacementId()) && FacebookAdapter.this.mBNPlacementToAdMap.containsKey(ad2.getPlacementId())) {
                    ((BannerSmashListener)FacebookAdapter.this.mBNPlacementToListenerMap.get(ad2.getPlacementId())).onBannerAdLoaded((View)FacebookAdapter.this.mBNPlacementToAdMap.get(ad2.getPlacementId()), layoutParams);
                }
            }

            public void onAdClicked(Ad ad2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "Banner Ad, onAdClicked", 1);
                if (FacebookAdapter.this.mBNPlacementToListenerMap.containsKey(ad2.getPlacementId())) {
                    ((BannerSmashListener)FacebookAdapter.this.mBNPlacementToListenerMap.get(ad2.getPlacementId())).onBannerAdClicked();
                }
            }

            public void onLoggingImpression(Ad ad2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "Banner Ad, onLoggingImpression", 1);
            }
        };
    }

    private class FacebookRewardedVideoAdListener
    implements RewardedVideoAdListener {
        private String mPlacementId;
        private RewardedVideoSmashListener mListener;

        FacebookRewardedVideoAdListener(RewardedVideoSmashListener rewardedVideoSmashListener, String string) {
            this.mPlacementId = string;
            this.mListener = rewardedVideoSmashListener;
        }

        public void onRewardedVideoCompleted() {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "onRewardedVideoCompleted <" + this.mPlacementId + ">", 1);
            this.mListener.onRewardedVideoAdEnded();
            this.mListener.onRewardedVideoAdRewarded();
        }

        public void onLoggingImpression(Ad ad2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "RV Ad, onLoggingImpression <" + this.mPlacementId + ">", 1);
            this.mListener.onRewardedVideoAdOpened();
            this.mListener.onRewardedVideoAdStarted();
        }

        public void onRewardedVideoClosed() {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "onRewardedVideoClosed <" + this.mPlacementId + ">", 1);
            this.mListener.onRewardedVideoAdClosed();
        }

        public synchronized void onError(Ad ad2, AdError adError) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "RV Ad, onError; error: <" + this.mPlacementId + "> " + adError.getErrorMessage(), 1);
            this.mListener.onRewardedVideoAvailabilityChanged(false);
            FacebookAdapter.this.mRvPlacementReady.remove(ad2.getPlacementId());
        }

        public synchronized void onAdLoaded(Ad ad2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "RV Ad, onAdLoaded <" + this.mPlacementId + ">", 1);
            this.mListener.onRewardedVideoAvailabilityChanged(true);
            FacebookAdapter.this.mRvPlacementReady.add(ad2.getPlacementId());
        }

        public void onAdClicked(Ad ad2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, "RV Ad, onAdClicked <" + this.mPlacementId + ">", 1);
            this.mListener.onRewardedVideoAdClicked();
        }
    }

    private class FacebookInterstitialAdListener
    implements InterstitialAdListener {
        private String mPlacementId;
        private InterstitialSmashListener mListener;

        FacebookInterstitialAdListener(InterstitialSmashListener interstitialSmashListener, String string) {
            this.mPlacementId = string;
            this.mListener = interstitialSmashListener;
        }

        public void onInterstitialDisplayed(Ad ad2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onInterstitialDisplayed <" + this.mPlacementId + ">", 1);
            this.mListener.onInterstitialAdOpened();
        }

        public void onInterstitialDismissed(Ad ad2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onInterstitialDismissed <" + this.mPlacementId + ">", 1);
            this.mListener.onInterstitialAdClosed();
        }

        public synchronized void onError(Ad ad2, AdError adError) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Interstitial Ad <" + this.mPlacementId + ">  onError: " + adError.getErrorMessage(), 1);
            this.mListener.onInterstitialAdLoadFailed(new IronSourceError(adError.getErrorCode(), adError.getErrorMessage()));
            FacebookAdapter.this.mIsPlacementReady.remove(ad2.getPlacementId());
        }

        public synchronized void onAdLoaded(Ad ad2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Interstitial Ad, onAdLoaded <" + this.mPlacementId + ">", 1);
            this.mListener.onInterstitialAdReady();
            FacebookAdapter.this.mIsPlacementReady.add(ad2.getPlacementId());
        }

        public void onAdClicked(Ad ad2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Interstitial Ad, onAdClicked <" + this.mPlacementId + ">", 1);
            this.mListener.onInterstitialAdClicked();
        }

        public void onLoggingImpression(Ad ad2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Interstitial Ad, onLoggingImpression <" + this.mPlacementId + ">", 1);
            this.mListener.onInterstitialAdShowSucceeded();
        }
    }
}

