/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.admob;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.widget.FrameLayout;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdCallback;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.AdapterUtils;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.IntegrationData;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.sdk.BannerSmashListener;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

public class AdMobAdapter
extends AbstractAdapter {
    private static final String CORE_SDK_VERSION = "17.2.0";
    public static int RV_NOT_READY_ERROR_CODE = 101;
    public static int BN_FAILED_TO_RELOAD_ERROR_CODE = 103;
    public static int IS_NOT_READY_ERROR_CODE = 104;
    private static final String VERSION = "4.3.3";
    private static final String GitHash = "fee11b12b";
    private final String IRONSOURCE_REQUEST_AGENT = "ironSource";
    private Activity mActivity;
    private Context mContext;
    private int mAge = -1;
    private ConcurrentHashMap<String, RewardedVideoSmashListener> mAdUnitIdToRvListener;
    private ConcurrentHashMap<String, RewardedAd> mAdIdToRvAd;
    private ConcurrentHashMap<String, Boolean> mRvAdsAvailability;
    private ConcurrentHashMap<String, InterstitialAd> mAdIdToIsAd;
    private ConcurrentHashMap<String, Boolean> mInterstitialAdsAvailability;
    private Boolean mDidInitSdk = Boolean.FALSE;
    private final String AD_UNIT_ID = "adUnitId";
    private final String APP_ID = "appId";
    private ConcurrentHashMap<String, AdView> mAdIdToBannerAd;
    private Boolean mConsent = null;

    public static AdMobAdapter startAdapter(String string) {
        return new AdMobAdapter(string);
    }

    private AdMobAdapter(String string) {
        super(string);
        this.mAllBannerSmashes = new CopyOnWriteArrayList();
        this.mAdIdToIsAd = new ConcurrentHashMap();
        this.mInterstitialAdsAvailability = new ConcurrentHashMap();
        this.mAdIdToBannerAd = new ConcurrentHashMap();
        this.mAdUnitIdToRvListener = new ConcurrentHashMap();
        this.mAdIdToRvAd = new ConcurrentHashMap();
        this.mRvAdsAvailability = new ConcurrentHashMap();
    }

    public static IntegrationData getIntegrationData(Activity activity) {
        activity = new IntegrationData("AdMob", VERSION);
        new IntegrationData("AdMob", VERSION).activities = new String[]{"com.google.android.gms.ads.AdActivity"};
        return activity;
    }

    public String getVersion() {
        return VERSION;
    }

    public void setAge(int n2) {
        this.mAge = n2;
    }

    public String getCoreSDKVersion() {
        return CORE_SDK_VERSION;
    }

    private synchronized void initSDK(Context context, String string) {
        if (!this.mDidInitSdk.booleanValue()) {
            this.mDidInitSdk = Boolean.TRUE;
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " initSDK", 1);
            String string2 = null;
            try {
                ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
                applicationInfo = applicationInfo.metaData;
                string2 = applicationInfo.getString("com.google.android.gms.ads.APPLICATION_ID");
            }
            catch (Exception exception) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " can't find APPLICATION_ID in manifest.xml ", 2);
            }
            if (TextUtils.isEmpty((CharSequence)string2)) {
                string2 = string;
            }
            if (TextUtils.isEmpty((CharSequence)string2)) {
                MobileAds.initialize((Context)context);
                return;
            }
            MobileAds.initialize((Context)context, (String)string2);
        }
    }

    public synchronized void initRewardedVideo(Activity object, String string, String string2, final JSONObject jSONObject, final RewardedVideoSmashListener rewardedVideoSmashListener) {
        this.mActivity = object;
        this.mContext = object.getApplicationContext();
        object = jSONObject.optString("adUnitId");
        if (TextUtils.isEmpty((CharSequence)object)) {
            rewardedVideoSmashListener.onRewardedVideoInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing params: 'adUnitId' ", (String)"Rewarded Video"));
            return;
        }
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                AdMobAdapter.this.initSDK(AdMobAdapter.this.mContext, jSONObject.optString("appId"));
                String string = jSONObject.optString("adUnitId");
                AdMobAdapter.this.mAdUnitIdToRvListener.put(string, rewardedVideoSmashListener);
                AdMobAdapter.this.loadRewardedVideoAdFromAdmob(string);
            }
        });
    }

    public synchronized void fetchRewardedVideo(final JSONObject jSONObject) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                AdMobAdapter.this.loadRewardedVideoAdFromAdmob(jSONObject.optString("adUnitId"));
            }
        });
    }

    public void onResume(Activity activity) {
        super.onResume(activity);
        this.mActivity = this.mActivity;
    }

    public synchronized boolean isRewardedVideoAvailable(JSONObject object) {
        return this.mRvAdsAvailability.containsKey(object = object.optString("adUnitId")) && this.mRvAdsAvailability.get(object) != false;
    }

    public synchronized void showRewardedVideo(final JSONObject jSONObject, final RewardedVideoSmashListener rewardedVideoSmashListener) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                String string = jSONObject.optString("adUnitId");
                RewardedAd rewardedAd = (RewardedAd)AdMobAdapter.this.mAdIdToRvAd.get(string);
                if (AdMobAdapter.this.mActivity != null && rewardedAd != null && rewardedAd.isLoaded()) {
                    IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, AdMobAdapter.this.getProviderName() + " RV show  " + string, 1);
                    AdMobAdapter.this.mRvAdsAvailability.put(string, Boolean.FALSE);
                    AdMobAdapter.this.mAdIdToRvAd.remove(rewardedAd);
                    rewardedAd.show(AdMobAdapter.this.mActivity, AdMobAdapter.this.createRewardedAdCallback(jSONObject.optString("adUnitId")));
                    rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
                    return;
                }
                rewardedVideoSmashListener.onRewardedVideoAdShowFailed(new IronSourceError(RV_NOT_READY_ERROR_CODE, AdMobAdapter.this.getProviderName() + "showRewardedVideo rv not ready " + string));
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            }
        });
    }

    private synchronized void loadRewardedVideoAdFromAdmob(String string) {
        RewardedAd rewardedAd = new RewardedAd(this.mContext, string);
        this.mAdIdToRvAd.put(string, rewardedAd);
        AdRequest adRequest = this.createAdRequest();
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + " rv loadAd " + string, 1);
        rewardedAd.loadAd(adRequest, this.createRewardedAdLoadCallback(string));
    }

    public synchronized void initInterstitial(Activity object, String string, String string2, final JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        this.mActivity = object;
        this.mContext = object.getApplicationContext();
        object = jSONObject.optString("adUnitId");
        if (TextUtils.isEmpty((CharSequence)object)) {
            interstitialSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing params: 'adUnitId' ", (String)"Interstitial"));
            return;
        }
        string = new Handler(Looper.getMainLooper());
        string.post(new Runnable((String)object, interstitialSmashListener){
            final /* synthetic */ String val$adUnitId;
            final /* synthetic */ InterstitialSmashListener val$listener;
            {
                this.val$adUnitId = string;
                this.val$listener = interstitialSmashListener;
            }

            @Override
            public void run() {
                AdMobAdapter.this.initSDK(AdMobAdapter.this.mContext, jSONObject.optString("appId"));
                InterstitialAd interstitialAd = new InterstitialAd(AdMobAdapter.this.mContext);
                interstitialAd.setAdUnitId(this.val$adUnitId);
                AdMobAdapter.this.mAdIdToIsAd.put(this.val$adUnitId, interstitialAd);
                interstitialAd.setAdListener(AdMobAdapter.this.createInterstitialAdListener(jSONObject, this.val$adUnitId));
                AdMobAdapter.this.mInterstitialPlacementToListenerMap.put(this.val$adUnitId, this.val$listener);
                this.val$listener.onInterstitialInitSuccess();
            }
        });
    }

    private RewardedAdCallback createRewardedAdCallback(final String string) {
        return new RewardedAdCallback(){

            public void onRewardedAdOpened() {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AdMobAdapter.this.getProviderName() + " onRewardedAdOpened " + string, 1);
                if (AdMobAdapter.this.mAdUnitIdToRvListener.containsKey(string)) {
                    ((RewardedVideoSmashListener)AdMobAdapter.this.mAdUnitIdToRvListener.get(string)).onRewardedVideoAdOpened();
                }
            }

            public void onRewardedAdClosed() {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AdMobAdapter.this.getProviderName() + " onRewardedAdClosed " + string, 1);
                if (AdMobAdapter.this.mAdUnitIdToRvListener.containsKey(string)) {
                    ((RewardedVideoSmashListener)AdMobAdapter.this.mAdUnitIdToRvListener.get(string)).onRewardedVideoAdClosed();
                }
            }

            public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AdMobAdapter.this.getProviderName() + " onUserEarnedReward " + string, 1);
                if (AdMobAdapter.this.mAdUnitIdToRvListener.containsKey(string)) {
                    ((RewardedVideoSmashListener)AdMobAdapter.this.mAdUnitIdToRvListener.get(string)).onRewardedVideoAdRewarded();
                }
            }

            public void onRewardedAdFailedToShow(int n2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AdMobAdapter.this.getProviderName() + " onRewardedAdFailedToShow: " + n2 + " " + string, 1);
                if (AdMobAdapter.this.mAdUnitIdToRvListener.containsKey(string)) {
                    String string2 = AdMobAdapter.this.getErrorString(n2) + "( " + n2 + " )";
                    ((RewardedVideoSmashListener)AdMobAdapter.this.mAdUnitIdToRvListener.get(string)).onRewardedVideoAdShowFailed(new IronSourceError(n2, AdMobAdapter.this.getProviderName() + "onRewardedAdFailedToShow " + string + " " + string2));
                    ((RewardedVideoSmashListener)AdMobAdapter.this.mAdUnitIdToRvListener.get(string)).onRewardedVideoAvailabilityChanged(false);
                }
            }
        };
    }

    private RewardedAdLoadCallback createRewardedAdLoadCallback(final String string) {
        return new RewardedAdLoadCallback(){

            public void onRewardedAdLoaded() {
                AdMobAdapter.this.mRvAdsAvailability.put(string, Boolean.TRUE);
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AdMobAdapter.this.getProviderName() + " onRewardedAdLoaded " + string, 1);
                if (AdMobAdapter.this.mAdUnitIdToRvListener.containsKey(string)) {
                    ((RewardedVideoSmashListener)AdMobAdapter.this.mAdUnitIdToRvListener.get(string)).onRewardedVideoAvailabilityChanged(true);
                }
            }

            public void onRewardedAdFailedToLoad(int n2) {
                AdMobAdapter.this.mRvAdsAvailability.put(string, Boolean.FALSE);
                String string2 = AdMobAdapter.this.getErrorString(n2) + "( " + n2 + " )";
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AdMobAdapter.this.getProviderName() + " onRewardedAdFailedToLoad " + string + " " + string2, 3);
                ((RewardedVideoSmashListener)AdMobAdapter.this.mAdUnitIdToRvListener.get(string)).onRewardedVideoAvailabilityChanged(false);
                IronSourceError ironSourceError = new IronSourceError(n2, string2);
                try {
                    IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, AdMobAdapter.this.getProviderName() + " onRewardedAdFailedToLoad sending load failed event " + string, 1);
                    ((RewardedVideoSmashListener)AdMobAdapter.this.mAdUnitIdToRvListener.get(string)).onRewardedVideoLoadFailed(ironSourceError);
                    IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, AdMobAdapter.this.getProviderName() + " onRewardedAdFailedToLoad load failed event sent " + string, 1);
                }
                catch (Throwable throwable) {
                    IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, AdMobAdapter.this.getProviderName() + " onRewardedAdFailedToLoad throwable when trying to send load failed event " + string + " " + throwable.getMessage(), 1);
                }
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, AdMobAdapter.this.getProviderName() + " onRewardedAdFailedToLoad end " + string, 1);
            }
        };
    }

    private AdListener createInterstitialAdListener(JSONObject jSONObject, final String string) {
        return new AdListener(){

            public void onAdClosed() {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, "onAdClosed " + string, 1);
                if (AdMobAdapter.this.mInterstitialPlacementToListenerMap.containsKey(string)) {
                    ((InterstitialSmashListener)AdMobAdapter.this.mInterstitialPlacementToListenerMap.get(string)).onInterstitialAdClosed();
                }
            }

            public void onAdFailedToLoad(int n2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, "onAdFailedToLoad " + string, 1);
                AdMobAdapter.this.mInterstitialAdsAvailability.put(string, Boolean.FALSE);
                if (AdMobAdapter.this.mInterstitialPlacementToListenerMap.containsKey(string)) {
                    String string2 = AdMobAdapter.this.getErrorString(n2) + "( " + n2 + " )";
                    ((InterstitialSmashListener)AdMobAdapter.this.mInterstitialPlacementToListenerMap.get(string)).onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)string2));
                }
            }

            public void onAdLeftApplication() {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, "onAdLeftApplication " + string, 1);
                if (AdMobAdapter.this.mInterstitialPlacementToListenerMap.containsKey(string)) {
                    ((InterstitialSmashListener)AdMobAdapter.this.mInterstitialPlacementToListenerMap.get(string)).onInterstitialAdClicked();
                }
            }

            public void onAdOpened() {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, "onAdOpened " + string, 1);
                if (AdMobAdapter.this.mInterstitialPlacementToListenerMap.containsKey(string)) {
                    ((InterstitialSmashListener)AdMobAdapter.this.mInterstitialPlacementToListenerMap.get(string)).onInterstitialAdOpened();
                    ((InterstitialSmashListener)AdMobAdapter.this.mInterstitialPlacementToListenerMap.get(string)).onInterstitialAdShowSucceeded();
                }
            }

            public void onAdLoaded() {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, "onAdLoaded " + string, 1);
                AdMobAdapter.this.mInterstitialAdsAvailability.put(string, Boolean.TRUE);
                if (AdMobAdapter.this.mInterstitialPlacementToListenerMap.containsKey(string)) {
                    ((InterstitialSmashListener)AdMobAdapter.this.mInterstitialPlacementToListenerMap.get(string)).onInterstitialAdReady();
                }
            }
        };
    }

    public synchronized void loadInterstitial(final JSONObject jSONObject, final InterstitialSmashListener interstitialSmashListener) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                InterstitialAd interstitialAd = AdMobAdapter.this.getInterstitialAd(jSONObject);
                if (interstitialAd == null) {
                    if (interstitialSmashListener != null) {
                        interstitialSmashListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)"invalid adUnitId"));
                    }
                    return;
                }
                String string = jSONObject.optString("adUnitId");
                if (interstitialAd.isLoaded()) {
                    if (AdMobAdapter.this.mInterstitialPlacementToListenerMap.containsKey(string)) {
                        ((InterstitialSmashListener)AdMobAdapter.this.mInterstitialPlacementToListenerMap.get(string)).onInterstitialAdReady();
                        return;
                    }
                } else if (!interstitialAd.isLoading()) {
                    IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, AdMobAdapter.this.getProviderName() + " interstitial loadAd " + string, 1);
                    interstitialAd.loadAd(AdMobAdapter.this.createAdRequest());
                }
            }
        });
    }

    public synchronized void showInterstitial(final JSONObject jSONObject, final InterstitialSmashListener interstitialSmashListener) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                InterstitialAd interstitialAd = AdMobAdapter.this.getInterstitialAd(jSONObject);
                String string = jSONObject.optString("adUnitId");
                if (interstitialAd == null || !interstitialAd.isLoaded()) {
                    if (interstitialSmashListener != null) {
                        interstitialSmashListener.onInterstitialAdShowFailed(new IronSourceError(IS_NOT_READY_ERROR_CODE, AdMobAdapter.this.getProviderName() + "showInterstitial is not ready " + string));
                    }
                    return;
                }
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, AdMobAdapter.this.getProviderName() + " interstitial show " + string, 1);
                interstitialAd.show();
                AdMobAdapter.this.mInterstitialAdsAvailability.put(jSONObject.optString("adUnitId"), Boolean.FALSE);
            }
        });
    }

    public final synchronized boolean isInterstitialReady(JSONObject object) {
        if (this.mInterstitialAdsAvailability.get(object = object.optString("adUnitId")) != null) {
            return this.mInterstitialAdsAvailability.get(object);
        }
        return false;
    }

    public synchronized void initBanners(Activity object, String string, String string2, final JSONObject jSONObject, final BannerSmashListener bannerSmashListener) {
        this.mActivity = object;
        this.mContext = object.getApplicationContext();
        object = jSONObject.optString("adUnitId");
        if (TextUtils.isEmpty((CharSequence)object)) {
            object = ErrorBuilder.buildInitFailedError((String)"AdMobAdapter loadBanner adUnitId is empty", (String)"Banner");
            bannerSmashListener.onBannerInitFailed((IronSourceError)object);
            return;
        }
        object = new Handler(Looper.getMainLooper());
        object.post(new Runnable(){

            @Override
            public void run() {
                AdMobAdapter.this.initSDK(AdMobAdapter.this.mContext, jSONObject.optString("appId"));
                bannerSmashListener.onBannerInitSuccess();
            }
        });
    }

    private AdSize getAdSize(ISBannerSize iSBannerSize, boolean bl) {
        switch (iSBannerSize.getDescription()) {
            case "BANNER": {
                return AdSize.BANNER;
            }
            case "LARGE": {
                return AdSize.LARGE_BANNER;
            }
            case "RECTANGLE": {
                return AdSize.MEDIUM_RECTANGLE;
            }
            case "SMART": {
                if (bl) {
                    return AdSize.LEADERBOARD;
                }
                return AdSize.BANNER;
            }
            case "CUSTOM": {
                return new AdSize(iSBannerSize.getWidth(), iSBannerSize.getHeight());
            }
        }
        return null;
    }

    private AdListener createBannerAdListener(final AdView adView, final String string) {
        return new AdListener(){

            public void onAdClosed() {
                super.onAdClosed();
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, "onAdClosed " + string, 1);
                if (AdMobAdapter.this.mBannerPlacementToListenerMap.containsKey(string)) {
                    ((BannerSmashListener)AdMobAdapter.this.mBannerPlacementToListenerMap.get(string)).onBannerAdScreenDismissed();
                }
            }

            public void onAdFailedToLoad(int n2) {
                super.onAdFailedToLoad(n2);
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, "onAdFailedToLoad: " + n2 + " " + string, 1);
                if (AdMobAdapter.this.mBannerPlacementToListenerMap.containsKey(string)) {
                    String string2 = AdMobAdapter.this.getErrorString(n2) + "( " + n2 + " )";
                    IronSourceError ironSourceError = n2 == 3 ? new IronSourceError(606, string2) : ErrorBuilder.buildLoadFailedError((String)string2);
                    ((BannerSmashListener)AdMobAdapter.this.mBannerPlacementToListenerMap.get(string)).onBannerAdLoadFailed(ironSourceError);
                }
            }

            public void onAdLeftApplication() {
                super.onAdLeftApplication();
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, "onAdLeftApplication " + string, 1);
                if (AdMobAdapter.this.mBannerPlacementToListenerMap.containsKey(string)) {
                    ((BannerSmashListener)AdMobAdapter.this.mBannerPlacementToListenerMap.get(string)).onBannerAdClicked();
                    ((BannerSmashListener)AdMobAdapter.this.mBannerPlacementToListenerMap.get(string)).onBannerAdLeftApplication();
                }
            }

            public void onAdOpened() {
                super.onAdOpened();
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, "onAdOpened " + string, 1);
                if (AdMobAdapter.this.mBannerPlacementToListenerMap.containsKey(string)) {
                    ((BannerSmashListener)AdMobAdapter.this.mBannerPlacementToListenerMap.get(string)).onBannerAdScreenPresented();
                }
            }

            public void onAdLoaded() {
                super.onAdLoaded();
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, "onAdLoaded " + string, 1);
                if (AdMobAdapter.this.mBannerPlacementToListenerMap.containsKey(string)) {
                    FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
                    new FrameLayout.LayoutParams(-2, -2).gravity = 17;
                    ((BannerSmashListener)AdMobAdapter.this.mBannerPlacementToListenerMap.get(string)).onBannerAdLoaded((View)adView, layoutParams);
                }
            }
        };
    }

    public synchronized void loadBanner(final IronSourceBannerLayout ironSourceBannerLayout, JSONObject object, BannerSmashListener bannerSmashListener) {
        if (ironSourceBannerLayout == null) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "AdMob loadBanner banner == null", 3);
            return;
        }
        object = object.optString("adUnitId");
        final AdSize adSize = this.getAdSize(ironSourceBannerLayout.getSize(), AdapterUtils.isLargeScreen((Activity)ironSourceBannerLayout.getActivity()));
        if (adSize == null) {
            bannerSmashListener.onBannerAdLoadFailed(ErrorBuilder.unsupportedBannerSize((String)"AdMob"));
            return;
        }
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable((String)object, bannerSmashListener){
            final /* synthetic */ String val$adUnitId;
            final /* synthetic */ BannerSmashListener val$listener;
            {
                this.val$adUnitId = string;
                this.val$listener = bannerSmashListener;
            }

            @Override
            public void run() {
                try {
                    AdView adView = new AdView((Context)ironSourceBannerLayout.getActivity());
                    adView.setAdSize(adSize);
                    adView.setAdUnitId(this.val$adUnitId);
                    adView.setAdListener(AdMobAdapter.this.createBannerAdListener(adView, this.val$adUnitId));
                    AdMobAdapter.this.mAdIdToBannerAd.put(this.val$adUnitId, adView);
                    AdMobAdapter.this.mBannerPlacementToListenerMap.put(this.val$adUnitId, this.val$listener);
                    AdRequest adRequest = AdMobAdapter.this.createAdRequest();
                    adView.loadAd(adRequest);
                    IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, AdMobAdapter.this.getProviderName() + "banner loadAd " + this.val$adUnitId, 1);
                    return;
                }
                catch (Exception exception) {
                    IronSourceError ironSourceError = ErrorBuilder.buildLoadFailedError((String)("AdMobAdapter loadBanner exception " + exception.getMessage()));
                    this.val$listener.onBannerAdLoadFailed(ironSourceError);
                    return;
                }
            }
        });
    }

    public synchronized void destroyBanner(final JSONObject jSONObject) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    String string = jSONObject.optString("adUnitId");
                    if (AdMobAdapter.this.mAdIdToBannerAd.containsKey(string)) {
                        AdView adView = (AdView)AdMobAdapter.this.mAdIdToBannerAd.get(string);
                        adView.destroy();
                        AdMobAdapter.this.mAdIdToBannerAd.remove(string);
                        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, AdMobAdapter.this.getProviderName() + "banner destroy " + string, 1);
                    }
                    return;
                }
                catch (Exception exception) {
                    AdMobAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, "AdMob destroyBanner() exception: " + exception, 3);
                    return;
                }
            }
        });
    }

    public synchronized void reloadBanner(final JSONObject jSONObject) {
        final String string = jSONObject.optString("adUnitId");
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (AdMobAdapter.this.mAdIdToBannerAd.get(jSONObject.optString("adUnitId")) != null) {
                    AdRequest adRequest = AdMobAdapter.this.createAdRequest();
                    AdView adView = (AdView)AdMobAdapter.this.mAdIdToBannerAd.get(jSONObject.optString("adUnitId"));
                    if (adView != null) {
                        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.ADAPTER_API, AdMobAdapter.this.getProviderName() + "banner loadAd " + string, 1);
                        adView.loadAd(adRequest);
                        return;
                    }
                    if (AdMobAdapter.this.mBannerPlacementToListenerMap.containsKey(string)) {
                        ((BannerSmashListener)AdMobAdapter.this.mBannerPlacementToListenerMap.get(string)).onBannerAdLoadFailed(new IronSourceError(BN_FAILED_TO_RELOAD_ERROR_CODE, AdMobAdapter.this.getProviderName() + "reloadBanner missing banner " + string));
                    }
                }
            }
        });
    }

    private AdRequest createAdRequest() {
        AdRequest.Builder builder = new AdRequest.Builder();
        builder.setRequestAgent("ironSource");
        if (this.mAge >= 0) {
            builder.tagForChildDirectedTreatment(this.mAge < 13);
        }
        if (this.mConsent != null && !this.mConsent.booleanValue()) {
            Bundle bundle = new Bundle();
            bundle.putString("npa", "1");
            builder.addNetworkExtrasBundle(com.google.ads.mediation.admob.AdMobAdapter.class, bundle);
        }
        return builder.build();
    }

    private String getErrorString(int n2) {
        switch (n2) {
            case 0: {
                return "Internal error";
            }
            case 1: {
                return "The ad request was invalid";
            }
            case 2: {
                return "The ad request was unsuccessful due to network connectivity";
            }
            case 3: {
                return "The ad request was successful, but no ad was returned due to lack of ad inventory";
            }
        }
        return "Unknown error";
    }

    private InterstitialAd getInterstitialAd(JSONObject object) {
        if (TextUtils.isEmpty((CharSequence)(object = object.optString("adUnitId"))) || !this.mAdIdToIsAd.containsKey(object)) {
            return null;
        }
        return this.mAdIdToIsAd.get(object);
    }

    protected synchronized void setConsent(boolean bl) {
        this.mConsent = bl;
    }
}

