/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.sdk.AppLovinSdk;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.reward.RewardItem;
import com.google.android.gms.ads.reward.RewardedVideoAd;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import java.util.concurrent.atomic.AtomicBoolean;

public class GoogleMediationAdapter
extends MediationAdapterBase
implements MaxAdViewAdapter,
MaxInterstitialAdapter,
MaxRewardedAdapter {
    private static final String APP_ID_PARAMETER = "app_id";
    private static final AtomicBoolean sIsInitialized = new AtomicBoolean();
    private InterstitialAd mInterstitialAd;
    private RewardedVideoAd mRewardBasedVideoAd;
    private AdView mAdView;

    public GoogleMediationAdapter(AppLovinSdk appLovinSdk) {
        super(appLovinSdk);
    }

    public void initialize(MaxAdapterInitializationParameters object, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        this.checkExistence(new Class[]{MobileAds.class, InterstitialAd.class, RewardedVideoAd.class, AdListener.class});
        if (!sIsInitialized.getAndSet(true)) {
            object = object.getServerParameters().getString(APP_ID_PARAMETER, null);
            MobileAds.initialize((Context)activity, (String)object);
        }
        onCompletionListener.onCompletion();
    }

    public String getSdkVersion() {
        return String.valueOf(GoogleApiAvailabilityLight.GOOGLE_PLAY_SERVICES_VERSION_CODE);
    }

    public String getAdapterVersion() {
        return "17.2.1.1";
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, final MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        this.mInterstitialAd = new InterstitialAd((Context)activity);
        this.mInterstitialAd.setAdUnitId(maxAdapterResponseParameters.getThirdPartyAdPlacementId());
        this.mInterstitialAd.setAdListener(new AdListener(){

            public void onAdLoaded() {
                maxInterstitialAdapterListener.onInterstitialAdLoaded();
            }

            public void onAdFailedToLoad(int n2) {
                maxInterstitialAdapterListener.onInterstitialAdLoadFailed(GoogleMediationAdapter.toMaxError(n2));
            }

            public void onAdOpened() {
                maxInterstitialAdapterListener.onInterstitialAdDisplayed();
            }

            public void onAdImpression() {
            }

            public void onAdClicked() {
            }

            public void onAdLeftApplication() {
                maxInterstitialAdapterListener.onInterstitialAdClicked();
            }

            public void onAdClosed() {
                maxInterstitialAdapterListener.onInterstitialAdHidden();
            }
        });
        maxAdapterResponseParameters = GoogleMediationAdapter.createAdRequest(maxAdapterResponseParameters);
        this.mInterstitialAd.loadAd((AdRequest)maxAdapterResponseParameters);
    }

    public void showInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        if (this.mInterstitialAd != null && this.mInterstitialAd.isLoaded()) {
            GoogleMediationAdapter.updateMuteState(maxAdapterResponseParameters);
            this.mInterstitialAd.show();
            return;
        }
        maxInterstitialAdapterListener.onInterstitialAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
    }

    public void loadRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, final MaxRewardedAdapterListener maxRewardedAdapterListener) {
        this.mRewardBasedVideoAd = MobileAds.getRewardedVideoAdInstance((Context)activity);
        this.mRewardBasedVideoAd.setRewardedVideoAdListener(new RewardedVideoAdListener(){
            private boolean hasGrantedReward;

            public void onRewardedVideoAdLoaded() {
                maxRewardedAdapterListener.onRewardedAdLoaded();
            }

            public void onRewardedVideoAdFailedToLoad(int n2) {
                maxRewardedAdapterListener.onRewardedAdLoadFailed(GoogleMediationAdapter.toMaxError(n2));
            }

            public void onRewardedVideoAdOpened() {
                maxRewardedAdapterListener.onRewardedAdDisplayed();
            }

            public void onRewardedVideoStarted() {
                maxRewardedAdapterListener.onRewardedAdVideoStarted();
            }

            public void onRewardedVideoAdLeftApplication() {
                maxRewardedAdapterListener.onRewardedAdClicked();
            }

            public void onRewarded(RewardItem rewardItem) {
                this.hasGrantedReward = true;
            }

            public void onRewardedVideoCompleted() {
                maxRewardedAdapterListener.onRewardedAdVideoCompleted();
            }

            public void onRewardedVideoAdClosed() {
                if (this.hasGrantedReward || this.shouldAlwaysReward()) {
                    MaxReward maxReward = this.retrieveReward();
                    maxRewardedAdapterListener.onUserRewarded(maxReward);
                }
                maxRewardedAdapterListener.onRewardedAdHidden();
            }

            private MaxReward retrieveReward() {
                if (AppLovinSdk.VERSION_CODE >= 90500) {
                    return GoogleMediationAdapter.this.getReward();
                }
                return MaxReward.createDefault();
            }

            private boolean shouldAlwaysReward() {
                if (AppLovinSdk.VERSION_CODE >= 90500) {
                    return GoogleMediationAdapter.this.shouldAlwaysRewardUser();
                }
                return false;
            }
        });
        if (this.mRewardBasedVideoAd.isLoaded()) {
            maxRewardedAdapterListener.onRewardedAdLoaded();
            return;
        }
        activity = GoogleMediationAdapter.createAdRequest(maxAdapterResponseParameters);
        this.mRewardBasedVideoAd.loadAd(maxAdapterResponseParameters.getThirdPartyAdPlacementId(), (AdRequest)activity);
    }

    public void showRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        if (this.mRewardBasedVideoAd != null && this.mRewardBasedVideoAd.isLoaded()) {
            if (AppLovinSdk.VERSION_CODE >= 90500) {
                this.configureReward(maxAdapterResponseParameters);
            }
            GoogleMediationAdapter.updateMuteState(maxAdapterResponseParameters);
            this.mRewardBasedVideoAd.show();
            return;
        }
        maxRewardedAdapterListener.onRewardedAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
    }

    public void loadAdViewAd(MaxAdapterResponseParameters maxAdapterResponseParameters, MaxAdFormat maxAdFormat, Activity activity, final MaxAdViewAdapterListener maxAdViewAdapterListener) {
        this.mAdView = new AdView((Context)activity);
        this.mAdView.setAdUnitId(maxAdapterResponseParameters.getThirdPartyAdPlacementId());
        this.mAdView.setAdSize(this.toAdSize(maxAdFormat));
        this.mAdView.setAdListener(new AdListener(){

            public void onAdLoaded() {
                maxAdViewAdapterListener.onAdViewAdLoaded((View)GoogleMediationAdapter.this.mAdView);
            }

            public void onAdFailedToLoad(int n2) {
                maxAdViewAdapterListener.onAdViewAdLoadFailed(GoogleMediationAdapter.toMaxError(n2));
            }

            public void onAdOpened() {
                maxAdViewAdapterListener.onAdViewAdClicked();
            }

            public void onAdClicked() {
            }

            public void onAdImpression() {
            }

            public void onAdLeftApplication() {
            }

            public void onAdClosed() {
            }
        });
        maxAdapterResponseParameters = GoogleMediationAdapter.createAdRequest(maxAdapterResponseParameters);
        this.mAdView.loadAd((AdRequest)maxAdapterResponseParameters);
    }

    public void onDestroy() {
        if (this.mInterstitialAd != null) {
            this.mInterstitialAd.setAdListener(null);
            this.mInterstitialAd = null;
        }
        if (this.mRewardBasedVideoAd != null) {
            this.mRewardBasedVideoAd.setRewardedVideoAdListener(null);
            this.mRewardBasedVideoAd = null;
        }
        if (this.mAdView != null) {
            this.mAdView.destroy();
            this.mAdView = null;
        }
    }

    private static void updateMuteState(MaxAdapterResponseParameters maxAdapterResponseParameters) {
        if ((maxAdapterResponseParameters = maxAdapterResponseParameters.getServerParameters()).containsKey("muted")) {
            boolean bl = maxAdapterResponseParameters.getBoolean("muted");
            MobileAds.setAppMuted((boolean)bl);
        }
    }

    private static MaxAdapterError toMaxError(int n2) {
        int n3 = n2 == 0 ? -5209 : (n2 == 1 ? -5203 : (n2 == 2 ? -5207 : (n2 == 3 ? 204 : -5200)));
        return new MaxAdapterError(n3, n2);
    }

    private AdSize toAdSize(MaxAdFormat maxAdFormat) {
        if (maxAdFormat == MaxAdFormat.BANNER) {
            return AdSize.BANNER;
        }
        if (maxAdFormat == MaxAdFormat.LEADER) {
            return AdSize.LARGE_BANNER;
        }
        if (maxAdFormat == MaxAdFormat.MREC) {
            return AdSize.MEDIUM_RECTANGLE;
        }
        throw new IllegalArgumentException("Unsupported ad format: " + maxAdFormat);
    }

    private static AdRequest createAdRequest(MaxAdapterResponseParameters maxAdapterResponseParameters) {
        Bundle bundle = maxAdapterResponseParameters.getServerParameters();
        AdRequest.Builder builder = new AdRequest.Builder();
        if (bundle.containsKey("is_designed_for_families")) {
            boolean bl = bundle.getBoolean("is_designed_for_families");
            builder.setIsDesignedForFamilies(bl);
        }
        builder.tagForChildDirectedTreatment(maxAdapterResponseParameters.isAgeRestrictedUser());
        Bundle bundle2 = bundle.getString("test_device_ids", null);
        if (!TextUtils.isEmpty((CharSequence)bundle2)) {
            Bundle bundle3 = bundle2.split(",");
            bundle2 = bundle3;
            bundle2 = bundle3;
            int n2 = ((String[])bundle3).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Bundle bundle4 = bundle2[i2];
                builder.addTestDevice((String)bundle4);
            }
        }
        if (bundle.getBoolean("set_mediation_identifier", true)) {
            builder.setRequestAgent(GoogleMediationAdapter.mediationTag());
        }
        bundle2 = new Bundle();
        if (!maxAdapterResponseParameters.hasUserConsent()) {
            bundle2.putString("npa", "1");
        }
        builder.addNetworkExtrasBundle(AdMobAdapter.class, bundle2);
        return builder.build();
    }
}

