package com.yodo1.sdk.kit;

import android.Manifest;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.v4.app.ActivityCompat;

/**
 * 权限检查及动态权限申请
 * Created by zhuxc on 2017/8/9.
 */
public class Yodo1PermissonUtils {
    public static final String READ_PHONE_STATE = "android.permission.READ_PHONE_STATE";
    private static String[] permissions = {Manifest.permission.READ_PHONE_STATE,Manifest.permission.WRITE_EXTERNAL_STORAGE };

    private static  int requestCode =  10086;
    /**
     * 判断应用是否有某个权限
     * @param ctx
     * @param permission
     * @return 是否含有此权限
     */
    public static boolean hasPermission(Context ctx, String permission){

        PackageManager pm = ctx.getPackageManager();
        boolean bl = (PackageManager.PERMISSION_GRANTED ==
                pm.checkPermission(permission, SysUtils.getPackageName(ctx)));

        return bl;
    }


    /**
     * 检查并申请某个动态权限
     * @param activity
     */
    public static void requestPermisson(Activity activity){

        if(Build.VERSION.SDK_INT >= 23) { //6.0以上系统
            boolean result = hasPermission(activity, permissions);//判断是否已经拥有某项权限
            if (!result) {//去申请
                ActivityCompat.requestPermissions(activity, permissions, requestCode);
            }
        }
    }

    /**
     * 权限检查
     *
     * @param permissions
     * @return
     */
    public static boolean hasPermission(Context cxt , String[] permissions) {
        for (String permission : permissions) {
            if (ActivityCompat.checkSelfPermission(cxt, permission)
                    != PackageManager.PERMISSION_GRANTED) {
                return false;
            }
        }
        return true;
    }

    /**
     * 权限程序是否在manifest文件中声明了某权限
     *
     * @param permissions
     * @return
     */
    public static boolean hasPermissionForManifest(Context cxt , String[] permissions) {
        for (String permission : permissions) {
            if ((PackageManager.PERMISSION_GRANTED != cxt.getPackageManager()
                    .checkPermission(permission, cxt.getPackageName()))) {
                return false;
            }
        }
        return true;
    }


}
