package com.yodo1.sdk.kit;

import android.Manifest;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.content.pm.PackageManager;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.provider.Settings;
import android.support.v4.content.ContextCompat;
import android.telephony.TelephonyManager;
import android.text.TextUtils;

import com.yodo1.sdk.kit.YFileUtils;
import com.yodo1.sdk.kit.YLog;

import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 获取设备ID
 */
public class YDeviceIDUtils {

	/**
	 * 手机号验证
	 */
	public static boolean isMobile(final String str) {
		if(TextUtils.isEmpty(str)){
			return false;
		}
		Pattern p = null;
		Matcher m = null;
		boolean b = false;
		p = Pattern.compile("^[1][3,4,5,7,8][0-9]{9}$"); // 验证手机号
		m = p.matcher(str);
		b = m.matches();
		return b;
	}

	/**
	 * 获取设备ID。
	 *
	 * 目前采取的策略是：第一次读取后在本地存储至本地，以后都从存储空间中读取。
	 *
	 * 在6.0或者没有READ_PHONE_STATE的设备上，采取androidId + serial的方式。
	 * 在非6.0并且有READ_PHONE_STATE权限的设备上，依旧采取老的imei方式
	 *
	 * @param ctx
	 * @return 可以的话返回曾经的设备ID, 否则返回新策略生成的
	 */
	public static String getDeviceId(Context ctx){

		String deviceId = YFileUtils.readFilesFromSDCard(YFileUtils.YODO1FILE);
		if (TextUtils.isEmpty(deviceId) || deviceId.contains("openYodo1Log")){
			deviceId = getDeviceIdForSave(ctx);
		}

		if (TextUtils.isEmpty(deviceId)){
			deviceId =  getIMEI(ctx);
		}

		if (TextUtils.isEmpty(deviceId)) {
			deviceId = java.util.UUID.randomUUID().toString();
			saveDeviceId(ctx, deviceId);
			YFileUtils.writeFilesToSDCard(deviceId,YFileUtils.YODO1FILE);
		}
		return deviceId;
	}

	
	private static String getIMEI(Context context){
		String imei = "";
		int permissionCheck = ContextCompat.checkSelfPermission(context, Manifest.permission.READ_PHONE_STATE);
		if (permissionCheck == PackageManager.PERMISSION_GRANTED) {

			TelephonyManager telephonyManager= (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
			if(telephonyManager != null){
				imei = telephonyManager.getDeviceId();
				if(TextUtils.isEmpty(imei) || "0".equals(imei) || "000000000000000".equals(imei)){
					imei = "";
				}
			}
		} else {
			YLog.d("没READ_PHONE_STATE权限,无法读取IMEI");
		}

		return imei;
	}
	private static String getMAC(Context context){
		String macStr = "";
		WifiManager wifi = (WifiManager) context.getApplicationContext().getSystemService(Context.WIFI_SERVICE);
		if(wifi != null){
			WifiInfo info = wifi.getConnectionInfo();
			if(info != null){
				macStr = info.getMacAddress();
				if(TextUtils.isEmpty(macStr)){
					macStr = "";
				}
			}
		}
		return macStr;
	}
	private final static String getSerial(){
		String serialnum = null;
		try {
			Class<?> c = Class.forName("android.os.SystemProperties");
			Method get = c.getMethod("get", String.class, String.class );
			serialnum = (String)(   get.invoke(c, "ro.serialno", "unknown" )  );
		}catch (Exception e){
			e.printStackTrace();
		}
		return serialnum;
	}
	private static String getAndroidID(Context context){
		String androidId = Settings.Secure.getString(context.getContentResolver(), Settings.Secure.ANDROID_ID);
		return androidId;
	}
	
	
	private static void saveDeviceId(Context context, String value){
		SharedPreferences sp = context.getSharedPreferences("sp_yodo1games", Context.MODE_PRIVATE);
		Editor editor = sp.edit();
		editor.putString("user_device_id", value);
		editor.apply();
	} 
	private static String getDeviceIdForSave(Context context){
		SharedPreferences sp = context.getSharedPreferences("sp_yodo1games", Context.MODE_PRIVATE);
		return sp.getString("user_device_id", null);
	}
	
	private static void saveDeviceIdNew(Context context, String value){
		SharedPreferences sp = context.getSharedPreferences("sp_yodo1games", Context.MODE_PRIVATE);
		Editor editor = sp.edit();
		editor.putString("user_device_id_new", value);
		editor.apply();
	} 
	private static String getDeviceIdForSaveNew(Context context){
		SharedPreferences sp = context.getSharedPreferences("sp_yodo1games", Context.MODE_PRIVATE);
		return sp.getString("user_device_id_new", null);
	}
	
}
