package com.yodo1.advert.video.channel;

import android.app.Activity;
import android.app.Application;

import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.plugin.yodo1.AdConfigYodo1;
import com.yodo1.advert.video.AdVideoAdapterBase;
import com.yodo1.advert.video.Yodo1VideoAds;
import com.yodo1.advert.video.Yodo1VideoCallback;
import com.yodo1.sdk.kit.YLog;

/**
 * Created by yodo1 on 2016/3/21.
 */
public class AdvertAdapteryodo1 extends AdVideoAdapterBase {

    private Yodo1ReloadCallback reloadCallback; //视频预加载回调
    private Yodo1AdCallback adCallback; //视频预加载回调


    private Yodo1VideoCallback callback = new Yodo1VideoCallback() {

        @Override
        public void onVideoClosed() {
            if (adCallback != null) {
                adCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onVideoFinish() {
            if (adCallback != null) {
                adCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }

        @Override
        public void onVideoShow() {
            if (adCallback != null) {
                adCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onVideoShowFailed(int errorCode) {
            if (reloadCallback != null) {
                reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, errorCode, "", getAdvertCode());
            }
        }

        @Override
        public void onVideoClicked() {

            if (adCallback != null) {
                adCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }
    };

    @Override
    public void showVideoAdvert(Activity activity, final Yodo1AdCallback callback) {
        YLog.d("Advert , Yodo1  showVideoAdvert");
        this.adCallback = callback;
        if (Yodo1VideoAds.isReady()) {
            Yodo1VideoAds.showVideoAds(activity);
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "激励视频广告已过期，请再次请求广告后进行广告展示！", getAdvertCode());
        }

    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadCallback = reloadCallback;
        YLog.d("Advert , Yodo1  reloadVideoAdvert");
        Yodo1VideoAds.loadYodo1Video(activity);
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return Yodo1VideoAds.isReady();
    }

    @Override
    public String getAdvertCode() {
        return AdConfigYodo1.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void validateAdsAdapter(Activity activity) {
    }

    @Override
    public void onCreate(Activity activity) {

        Yodo1VideoAds.setYodo1VideoCallback(callback);
    }


    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }


}
