package com.yodo1.advert.video.channel;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;

import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.Vungle;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.plugin.vungle.AdConfigVungle;
import com.yodo1.advert.plugin.vungle.AdvertCoreVungle;
import com.yodo1.advert.video.AdVideoAdapterBase;
import com.yodo1.sdk.kit.YLog;

/**
 * Created by yodo1 on 2016/3/21.
 */
public class AdvertAdaptervungle extends AdVideoAdapterBase {

    private Yodo1AdCallback videoCallback; //视频回调
    private Yodo1ReloadCallback reloadCallback; //视频预加载回调



    private final LoadAdCallback vungleLoadAdCallback = new LoadAdCallback() {

        @Override
        public void onAdLoad(String placementReferenceId) {

            if(reloadCallback != null){
                reloadCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onError(String placementReferenceId, Throwable throwable) {

            if(reloadCallback != null){
                reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION,0,"异常码广告位ID： "+placementReferenceId + " 错误信息：" + throwable.getCause(), getAdvertCode());
            }
            YLog.d("Vungle,  onError : " + placementReferenceId + "   Throwable : " + throwable.getCause());

        }
    };


    private final PlayAdCallback vunglePlayAdCallback = new PlayAdCallback() {

        @Override
        public void onAdStart(String placementReferenceId) {
            if (placementReferenceId.equals(AdConfigVungle.PLACEMENTID)) {
                if (videoCallback != null) {
                    videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, AdConfigVungle.CHANNEL_CODE);
                }
            }

        }

        @Override
        public void onAdEnd(String placementReferenceId, boolean completed, boolean isCTAClicked) {
            if (placementReferenceId.equals(AdConfigVungle.PLACEMENTID) && videoCallback != null) {
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, AdConfigVungle.CHANNEL_CODE);
                if (completed) {
                    YLog.d("Vungle,  onAdEnd  关闭");
                    videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, AdConfigVungle.CHANNEL_CODE);
                }
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, AdConfigVungle.CHANNEL_CODE);
            }


        }

        @Override
        public void onError(String placementReferenceId, Throwable throwable) {
            YLog.d("Vungle,  onError : " + placementReferenceId + "   Throwable : " + throwable.getCause());
        }
    };

    @Override
    public void showVideoAdvert(final Activity activity,final Yodo1AdCallback callback) {
        YLog.d("Vungle, showVideoAdvert");
        this.videoCallback = callback;
        if (TextUtils.isEmpty( AdConfigVungle.APP_ID)){
            YLog.i("Vungle  appid  is null");
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "Vungle  appid  is null", getAdvertCode());
            return ;
        }
        if (TextUtils.isEmpty(AdConfigVungle.PLACEMENTID)){
            YLog.i("Vungle video placementid is null");
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "Vungle  video placementid  is null", getAdvertCode());
            return;
        }

        if (Vungle.canPlayAd(AdConfigVungle.PLACEMENTID)) {
            Vungle.playAd(AdConfigVungle.PLACEMENTID, null, vunglePlayAdCallback);
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }

//        activity.runOnUiThread(new Runnable() {
//            @Override
//            public void run() {
//
//            }
//        });
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadCallback = reloadCallback;
        if (TextUtils.isEmpty(AdConfigVungle.PLACEMENTID)){
            reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL,0,"APPID 为空",getAdvertCode());
            YLog.i("Vungle,  reloadVideoAdvert Video PlacementId  is null");
            return;
        }
        YLog.d("Vungle, reloadVideoAdvert");


        if (Vungle.isInitialized()) {
            Vungle.loadAd(AdConfigVungle.PLACEMENTID, vungleLoadAdCallback);
        }
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return Vungle.canPlayAd(AdConfigVungle.PLACEMENTID);
    }

    @Override
    public String getAdvertCode() {
        return AdConfigVungle.CHANNEL_CODE;
    }

    @Override
    public void validateAdsAdapter(Activity activity) {

        AdvertCoreVungle.getInstance().validateAdsAdapter(activity);

    }



    @Override
    public void onCreateApplication(Application application) {
    }

    @Override
    public void onCreate(final Activity activity) {

        AdvertCoreVungle.getInstance().init(activity);
    }



    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }


    @Override
    public void onDestroy(Activity activity) {
    }


}
