package com.yodo1.advert.video.channel;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;

import com.unity3d.ads.IUnityAdsListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.services.UnityServices;
import com.unity3d.services.monetization.IUnityMonetizationListener;
import com.unity3d.services.monetization.UnityMonetization;
import com.unity3d.services.monetization.placementcontent.ads.IShowAdListener;
import com.unity3d.services.monetization.placementcontent.ads.ShowAdPlacementContent;
import com.unity3d.services.monetization.placementcontent.core.PlacementContent;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.plugin.unityads.AdConfigUnityads;
import com.yodo1.advert.plugin.unityads.AdvertCoreUnityads;
import com.yodo1.advert.video.AdVideoAdapterBase;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by yodo1 on 2016/3/21.
 */
public class AdvertAdapterunityads extends AdVideoAdapterBase {

    private Yodo1ReloadCallback reloadCallback; //视频预加载回调
    private String rewardedPlacementId;

    private IUnityMonetizationListener unityAdsListener = new IUnityMonetizationListener() {
        @Override
        public void onUnityServicesError(UnityServices.UnityServicesError error, String message) {
            YLog.d("Advert , Unityads  Video onUnityServicesError: " + error.name() + " 错误信息：" + message);
            if(reloadCallback != null){
                reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION,0,"异常码： "+error.name() + " 错误信息：" + message, getAdvertCode());
            }
        }

        @Override
        public void onPlacementContentReady(String placementId, PlacementContent placementcontent) {
            YLog.d("Advert , Unityads  Video onPlacementContentReady: " + placementId);
            if(reloadCallback != null){
                reloadCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onPlacementContentStateChange(String placementId, PlacementContent placementcontent, UnityMonetization.PlacementContentState previousState, UnityMonetization.PlacementContentState newState) {
            YLog.d("Advert , Unityads  Video onPlacementContentStateChange: " + placementId);
        }

    };
    @Override
    public void showVideoAdvert(Activity activity,final Yodo1AdCallback callback) {
        YLog.d("Advert , Unityads  showVideoAdvert");

        if(!TextUtils.isEmpty(rewardedPlacementId) && UnityMonetization.isReady (rewardedPlacementId)) {

            PlacementContent pc = UnityMonetization.getPlacementContent (rewardedPlacementId);
            if (pc.getType ().equalsIgnoreCase ("SHOW_AD")) {
                ShowAdPlacementContent p = (ShowAdPlacementContent) pc;
                p.show(activity, new IShowAdListener() {
                    @Override
                    public void onAdFinished(String placementId, UnityAds.FinishState withState) {
                        YLog.d("Advert , Unityads  Video onAdFinished! " + placementId + "  FinishState : " + withState);

                        if (placementId.equals (rewardedPlacementId) && withState == UnityAds.FinishState.COMPLETED){
                            callback.onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
                        }
                        callback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
                    }

                    @Override
                    public void onAdStarted(String placementId) {
                        YLog.d("Advert , Unityads  Video onAdStarted! " + placementId);
                        callback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
                    }
                });
            }

        }else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }

    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadCallback = reloadCallback;
        if (TextUtils.isEmpty(rewardedPlacementId)){
            YLog.e("Unityads  rewardedPlacementId  is null");
            reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL,0," 错误信息：ID NULL" , getAdvertCode());
            return;
        }
        UnityMonetization.setListener(unityAdsListener );
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return !TextUtils.isEmpty(rewardedPlacementId) && UnityMonetization.isReady (rewardedPlacementId);
    }

    @Override
    public String getAdvertCode() {
        return AdConfigUnityads.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }
    @Override
    public void validateAdsAdapter(Activity activity) {
    }
    @Override
    public void onCreate(Activity activity) {

         rewardedPlacementId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, AdConfigUnityads.CHANNEL_CODE
                , AdConfigUnityads.KEY_UNITYADS_REWARDED_ID);

        AdvertCoreUnityads.getInstance().init(activity);
        YLog.e("Unityads  rewardedPlacementId ： " + rewardedPlacementId);
    }


    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }


}
