package com.yodo1.advert.video.channel;

import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.text.TextUtils;

import com.ironsource.mediationsdk.IronSource;

import com.ironsource.mediationsdk.integration.IntegrationHelper;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.sdk.RewardedVideoListener;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.plugin.supersonic.AdConfigSupersonic;
import com.yodo1.advert.plugin.supersonic.AdvertCoreSupersonic;
import com.yodo1.advert.video.AdVideoAdapterBase;
import com.yodo1.sdk.kit.YLog;

/**
 * Created by yodo1 on 2016/4/7.
 */
public class AdvertAdaptersupersonic extends AdVideoAdapterBase {
    private Yodo1AdCallback videoCallback; //视频回调
    private Yodo1ReloadCallback reloadCallback; //视频预加载回调

    RewardedVideoListener mRewardedVideoListener = new RewardedVideoListener()
    {

        @Override
        public void onRewardedVideoAdClosed() {
            // TODO Auto-generated method stub
            // called when the video is closed
            YLog.i("Supersonic.onRewardedVideoAdClosed");
            // here we show a dialog to the user if he was rewarded
            if(videoCallback != null){
               videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAvailabilityChanged(boolean available) {
            YLog.i( "Supersonic.onVideoAvailabilityChanged : " + available);
            if (reloadCallback != null){
                if (available){
                    reloadCallback.onReloadSuccess(getAdvertCode());
                }

            }
        }

        @Override
        public void onRewardedVideoAdStarted() {
            YLog.i("Supersonic onRewardedVideoAdStarted ");
        }

        @Override
        public void onRewardedVideoAdEnded() {
            YLog.i("Supersonic onRewardedVideoAdEnded ");
        }


        @Override
        public void onRewardedVideoAdShowFailed(IronSourceError ironSourceError) {
            YLog.e("Supersonic.onRewardedVideoShowFail" + ironSourceError.getErrorMessage());
            if (reloadCallback != null){
                reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION,ironSourceError.getErrorCode() , ironSourceError.getErrorMessage(), getAdvertCode());
            }
            if(videoCallback != null){
                videoCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_DISPLAY_FAILED, "onRewardedVideoAdShowFailed ： " + ironSourceError.getErrorMessage(), getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAdClicked(Placement placement) {
            if(videoCallback != null){
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAdOpened() {
            // TODO Auto-generated method stub
            YLog.i("Supersonic.onRewardedVideoAdOpened");
            if (videoCallback != null){
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAdRewarded(Placement placement) {
            // TODO Auto-generated method stub
            // called when the video has been rewarded and a reward can be given to the user
            String rewardName = placement.getRewardName();
            int rewardAmount = placement.getRewardAmount();
            YLog.i("Supersonic, onRewardedVideoAdRewarded: rewardName=" + rewardName + ", rewardAmount=" + rewardAmount);

            if(videoCallback != null){
                videoCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_FINISH, getAdvertCode());
            }

        }


    };

    @Override
    public void showVideoAdvert(Activity activity, Yodo1AdCallback callback) {
        this.videoCallback = callback;
        YLog.i("Supersonic, showVideoAdvert ... ");
        if (videoAdvertIsLoaded(activity)) {
                //show rewarded video
            IronSource.showRewardedVideo();
        } else {
            videoCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1ReloadCallback reloadCallback) {
        this.reloadCallback = reloadCallback;

        YLog.i("Supersonic, requestRewardVideo ... ");
        if (TextUtils.isEmpty(AdConfigSupersonic.SUPERSONIC_ID)){
            YLog.e("Supersonic  APPID  is null");
            reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL,0,"",getAdvertCode());
            return ;
        }

    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        if (TextUtils.isEmpty(AdConfigSupersonic.SUPERSONIC_ID)){
            YLog.e("Supersonic  APPID  is null");
            return false;
        }

        boolean result = IronSource.isRewardedVideoAvailable();
        YLog.i("Supeirsonic isLoaded = " + result);
        return result;
    }

    @Override
    public String getAdvertCode() {
        return AdConfigSupersonic.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {
    }
    @Override
    public void validateAdsAdapter(Activity activity) {
        AdvertCoreSupersonic.getInstance().validateAdsAdapter(activity);
    }
    @Override
    public void onCreate(Activity activity) {
        YLog.d("supersonic  onCreate");
        AdConfigSupersonic.SUPERSONIC_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, AdConfigSupersonic.CHANNEL_CODE
                , AdConfigSupersonic.KEY_SUPERSONIC_APP_ID);
        if (TextUtils.isEmpty(AdConfigSupersonic.SUPERSONIC_ID)){
            YLog.e("Supersonic  APPID  is null");
            return;
        }
        //Init Interstitial
        IronSource.init(activity, AdConfigSupersonic.SUPERSONIC_ID, IronSource.AD_UNIT.REWARDED_VIDEO);
        IronSource.setRewardedVideoListener(mRewardedVideoListener);
        IntegrationHelper.validateIntegration(activity);
    }


    @Override
    public void onResume(Activity activity) {
        YLog.d("supersonic  onResume");
        AdvertCoreSupersonic.getInstance().onResume(activity);
    }

    @Override
    public void onPause(Activity activity) {
        AdvertCoreSupersonic.getInstance().onPause(activity);
    }



    @Override
    public void onDestroy(Activity activity) {
    }



}
