package com.yodo1.advert.plugin.unityads;

import android.app.Activity;
import android.text.TextUtils;

import com.unity3d.ads.UnityAds;
import com.unity3d.services.UnityServices;
import com.unity3d.services.monetization.IUnityMonetizationListener;
import com.unity3d.services.monetization.UnityMonetization;
import com.unity3d.services.monetization.placementcontent.core.PlacementContent;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.ValidateUtils;
import com.yodo1.sdk.kit.YLog;

import java.util.Arrays;
import java.util.List;

/**
 * Created by yodo1 on 2016/4/21.
 */
public class AdvertCoreUnityads implements  IUnityMonetizationListener{
    private static AdvertCoreUnityads instance;
    private boolean validate = false;
    private IUnityMonetizationListener listener;

    private AdvertCoreUnityads() {
    }

    public static AdvertCoreUnityads getInstance() {
        if (instance == null) {
            instance = new AdvertCoreUnityads();
        }
        return instance;
    }

    public void validateAdsAdapter(Activity activity) {
        if (!validate) {
            List<String> unityActivities = Arrays.asList(new String[]{"com.unity3d.ads.adunit.AdUnitActivity",
                    "com.unity3d.ads.adunit.AdUnitTransparentActivity", "com.unity3d.ads.adunit.AdUnitTransparentSoftwareActivity"
                    , "com.unity3d.ads.adunit.AdUnitSoftwareActivity"});
            ValidateUtils.validateActivities(activity, unityActivities);


            validate = true;
        }

    }

    public void init(Activity myActivity) {
        if (!UnityServices.isInitialized()) {
            String  unityGameID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, AdConfigUnityads.CHANNEL_CODE
                    , AdConfigUnityads.KEY_UNITYADS_APP_ID);


            if (TextUtils.isEmpty(unityGameID)) {
                unityGameID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, AdConfigUnityads.CHANNEL_CODE
                        , AdConfigUnityads.KEY_UNITYADS_APP_ID);
            }

            if (TextUtils.isEmpty(unityGameID)) {
                YLog.e("Unityads  APPID  is null");
                return;
            }
            UnityMonetization.initialize(myActivity, unityGameID, this, false);
        }

    }


    @Override
    public void onUnityServicesError(UnityServices.UnityServicesError error, String message) {
        YLog.d("Advert , Unityads  init onUnityServicesError: " + error.name() + " 错误信息：" + message);
    }

    @Override
    public void onPlacementContentReady(String placementId, PlacementContent placementcontent) {
        YLog.d("Advert , Unityads  init onPlacementContentReady: " + placementId);
    }

    @Override
    public void onPlacementContentStateChange(String placementId, PlacementContent placementcontent, UnityMonetization.PlacementContentState previousState, UnityMonetization.PlacementContentState newState) {
        YLog.d("Advert , Unityads  init onPlacementContentStateChange: " + placementId);
    }
}
