package com.yodo1.advert.plugin.admob;

import android.app.Activity;
import android.text.TextUtils;

import com.applovin.sdk.AppLovinSdk;
import com.google.android.gms.ads.MobileAds;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.ValidateUtils;

import java.util.Arrays;
import java.util.List;

/**
 * Created by yodo1 on 2016/3/22.
 */
public class AdvertCoreAdMob {

    private static AdvertCoreAdMob instance;
    private boolean isValidate = false;
    private boolean init = false;

    private AdvertCoreAdMob() {
    }

    public static AdvertCoreAdMob getInstance() {
        if (instance == null) {
            instance = new AdvertCoreAdMob();
        }
        return instance;
    }

    public void validateAds(Activity activity) {
        if (!isValidate) {
            List<String> adcolonyActivities = Arrays.asList(new String[]{"com.google.android.gms.ads.AdActivity"});
            ValidateUtils.validateActivities(activity, adcolonyActivities);
            isValidate = true;
        }
    }

    public void initAdMob(Activity activity) {
        if (!init) {
            init = true;
            //此处读取key
            String appid = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd, AdConfigAdMob.CHANNEL_CODE
                    , AdConfigAdMob.KEY_AdMob_BANNER_APPID);
            String oguryAppid = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, AdConfigAdMob.CHANNEL_CODE
                    , AdConfigAdMob.KEY_AdMob_INTERSTITIAL_OGURYAPPID);
//            appid = "ca-app-pub-7188592076082444~5943610619";
            if (TextUtils.isEmpty(appid)) {
                appid = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, AdConfigAdMob.CHANNEL_CODE
                        , AdConfigAdMob.KEY_AdMob_VIDEO_APPID);
            }
            if (TextUtils.isEmpty(appid)) {
                appid = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, AdConfigAdMob.CHANNEL_CODE
                        , AdConfigAdMob.KEY_AdMob_INTERSTITIAL_APPID);
            }

            if (!TextUtils.isEmpty(appid)) {

                AppLovinSdk.initializeSdk(activity);
                MobileAds.initialize(activity.getApplicationContext(),
                        appid);

//                if (!TextUtils.isEmpty(oguryAppid)){
//                    YLog.i("AdMob  聚合 Ogury ： " + oguryAppid);
//                    io.presage.Presage.getInstance().start(oguryAppid, activity); // this = current activity
//                }
            }

        }
    }
}
