package com.yodo1.advert.open;

import android.app.Activity;
import android.app.Application;

import com.yodo1.advert.callback.BannerCallback;
import com.yodo1.advert.callback.InterstitialCallback;
import com.yodo1.advert.callback.NativeCallback;
import com.yodo1.advert.callback.SplashCallback;
import com.yodo1.advert.callback.VideoCallback;
import com.yodo1.advert.helper.Yodo1AdvertHelper;
import com.yodo1.sdk.kit.YLog;

/**
 * Advert Open Interface
 * Created by zhuxiaochen on 2017/8/30.
 */
public class Yodo1Advert {
    public static boolean loadAdForTypeMobile = true;
    private static Yodo1AdvertHelper helper = Yodo1AdvertHelper.getInstance();


    /**
     * Initialize SDK, make sure call the method in your activity’s “onCreate” method.
     *
     * @param activity Activity
     * @param appKey   The app key obtained from MAS Developer Platform
     */
    public static void initSDK(Activity activity, String appKey) {
        helper.init(activity, appKey);
    }

    public static void setOnLog(boolean onLog) {
        if (onLog) {
            YLog.d("The test mode has been enabled.");
            YLog.setOnLog(onLog);
        }
    }

    public static void setLoadAdForMobile(boolean enable) {
        loadAdForTypeMobile = enable;
        YLog.d("The ad is loaded in the non-wifi state: " + loadAdForTypeMobile);
    }

    /**
     * Show interstitial Ad.
     *
     * @param activity Activity
     * @param callback The callback method of show intertitial ad
     * @return  true , if the intertitial ad has been shown,  false  otherwise. 
     */
    public static boolean showInterstitial(final Activity activity, final InterstitialCallback callback) {
        YLog.d("call Yodo1Advert showInterstitialAd ...");
        return helper.showInterstitialAd(activity, callback);
    }

    /**
     * Whether the intertitial ads have been cached.
     *
     * @param activity Activity
     * @return  true , if the intertitial ads have been cached,  false  otherwise. 
     */
    public static boolean interstitialIsReady(Activity activity) {
        YLog.d("call Yodo1Advert interstitialAdReady ...");
        return helper.interstitialAdIsLoaded(activity);
    }

    /**
     * Show reward video Ad.
     *
     * @param activity Activity
     * @param callback The callback method of show reward video ad
     * @return true, if the reward video ad has been shown, false otherwise. 
     */
    public static boolean showVideo(final Activity activity, final VideoCallback callback) {
        YLog.d("call Yodo1Advert showVideoAd ...");
        return helper.showVideoAd(activity, callback);
    }

    /**
     * Whether reward video ads have been cached.
     *
     * @param activity Activity
     * @return  true , if the reward video ads have been cached,  false  otherwise. 
     */
    public static boolean videoIsReady(Activity activity) {
        YLog.d("call Yodo1Advert videoAdIsLoaded ...");
        return helper.videoAdIsLoaded(activity);
    }

    /**
     * Show the native Ad, the MAS games ignore this method.
     *
     * @param activity Activity
     * @param callback The callback method of show navive ad
     * @return  true , if the native ad has been shown,  false  otherwise. 
     */
    public static boolean showNative(final Activity activity, float px, float py, float pw, float ph, final NativeCallback callback) {
        YLog.d("call Yodo1Advert showNative ...");
        return helper.showNativeAd(activity, px, py, pw, ph, callback);
    }

    /**
     * Whether the native ads have been cached, the MAS games ignore this method.
     *
     * @param activity Activity
     * @return  true , if the native ads have been cached,  false  otherwise. 
     */
    public static boolean nativeIsReady(Activity activity) {
        return helper.nativeAdIsLoaded(activity);
    }

    /**
     * Remove the native ad, the MAS games ignore this method.
     *
     * @param activity Activity
     */
    public static void removeNative(Activity activity) {
        helper.removeNativeAd(activity);
    }

    /**
     * Show the splash ad, the MAS games ignore this method.
     *
     * @param activity Activity
     * @param callback callback
     * @return  true , if the splash ads have been shown,  false  otherwise. 
     */
    public static boolean showSplash(final Activity activity, final SplashCallback callback) {
        YLog.d("call Yodo1Advert showVideoAd ...");
        return helper.showSplashAd(activity, callback);
    }

    /**
     * Set the alignment of banner ad.
     *
     * @param activity Activity
     * @param align    The alignment of banner ad, such as: Bottom center(BannerAlign.HorizontalCenter|BannerAlign.Bottom)
     */
    public static void SetBannerAlign(Activity activity, int align) {
        YLog.d("call Yodo1Advert setBannerAlign ...");
        helper.SetBannerAlign(activity, align);
    }

    /**
     * Show the banner ad.
     *
     * @param activity Activity
     * @param callback The callback method of banner ad
     */
    public static void ShowBanner(Activity activity, BannerCallback callback) {
        YLog.d("call Yodo1Advert showBanner ...");
        helper.ShowBanner(activity, callback);
    }

    /**
     * Hide the banner ad.
     *
     * @param activity Activity
     */
    public static void HideBanner(Activity activity) {
        YLog.d("call Yodo1Advert hideBanner ...");
        helper.HideBanner1(activity);
    }

    /**
     * Remove the banner ad.
     *
     * @param activity Activity
     */
    public static void RemoveBanner(Activity activity) {
        YLog.d("call Yodo1Advert removeBanner ...");
        helper.RemoveBanner1(activity);
    }
}
