package com.yodo1.advert.interstitial.channel;

import android.app.Activity;
import android.app.Application;
import android.graphics.Bitmap;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.interstitial.AdInterstitialAdapterBase;
import com.yodo1.advert.interstitial.Yodo1InterAdView;
import com.yodo1.advert.interstitial.Yodo1InterAdView.OnYodo1AdsCallBack;
import com.yodo1.advert.plugin.yodo1.AdConfigYodo1;
import com.yodo1.sdk.kit.YLog;

/**
 * Created by yodo1 on 17/8/31.
 */
public class AdvertAdapteryodo1 extends AdInterstitialAdapterBase {
    private Yodo1AdCallback adCallback;
    private Yodo1ReloadCallback reloadCallback;
    private Yodo1InterAdView adView;

    private OnYodo1AdsCallBack adsCallBack = new OnYodo1AdsCallBack(){
        @Override
        public void setOnAdClickListener() {
            if (adCallback != null) {
                adCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void setOnAdCloseListener() {
            if (adCallback != null) {
                adCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void setOnAdShowSuccessListener() {
            if (adCallback != null) {
                adCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void setOnAdLoadSuccessListener() {
            if (reloadCallback != null) {
                reloadCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void setOnAdLoadFailedListener() {
            if (reloadCallback != null) {
                reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, 0, "error: null", getAdvertCode());
            }
        }
    };

    @Override
    public void showIntersititalAdvert(Activity activity, final Yodo1AdCallback callback) {
        this.adCallback = callback;
        YLog.d("Advert , Yodo1  showIntersititalAdvert");

        if (adView != null){
            adView.showYodo1Ads(activity);
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.reloadCallback = callback;
        YLog.d("Advert , Yodo1  reloadInterstitialAdvert");

        adView = new Yodo1InterAdView(activity);
        adView.setOnYodo1AdsCallback(adsCallBack);

    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return true;
    }


    @Override
    public String getAdvertCode() {
        return AdConfigYodo1.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void validateAdsAdapter(Activity activity) {
    }

    @Override
    public void onCreate(Activity activity) {


    }

    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }

    @Override
    public void onDestroy(Activity activity) {

    }

}
