package com.yodo1.advert.interstitial.channel;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;

import com.tapjoy.TJActionRequest;
import com.tapjoy.TJEarnedCurrencyListener;
import com.tapjoy.TJError;
import com.tapjoy.TJPlacement;
import com.tapjoy.TJPlacementListener;
import com.tapjoy.Tapjoy;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.interstitial.AdInterstitialAdapterBase;
import com.yodo1.advert.plugin.tapjoy.AdConfigTapjoy;
import com.yodo1.advert.plugin.tapjoy.AdvertCoreTapjoy;
import com.yodo1.sdk.kit.YLog;
/**
 * Created by yodo1 on 17/8/31.
 */
public class AdvertAdaptertapjoy extends AdInterstitialAdapterBase {
    private Yodo1ReloadCallback reloadCallback;
    private Yodo1AdCallback interstitialCallback;
    private TJPlacement directPlayPlacement;
    private boolean isconnect;

    private TJPlacementListener interstitialListener = new TJPlacementListener() {

        @Override
        public void onRequestSuccess(TJPlacement tjPlacement) {
            YLog.i("Tapjoy  onRequestSuccess");
        }

        @Override
        public void onRequestFailure(TJPlacement tjPlacement, TJError tjError) {
            YLog.i("Tapjoy  onRequestFailure ");
            if (reloadCallback != null){
                reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL,tjError.code,"异常码： "+tjPlacement + " 错误信息：" + tjError.message , getAdvertCode());
            }

        }

        @Override
        public void onContentReady(TJPlacement tjPlacement) {
            YLog.i("Tapjoy  onContentReady");
            if (reloadCallback != null){
                reloadCallback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onContentShow(TJPlacement tjPlacement) {
            YLog.i("Tapjoy  onContentShow");
            if(interstitialCallback != null){
                interstitialCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, AdConfigTapjoy.CHANNEL_CODE);
            }
        }

        @Override
        public void onContentDismiss(TJPlacement tjPlacement) {
            YLog.i("Tapjoy  onContentDismiss");
            if(interstitialCallback != null){
                interstitialCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, AdConfigTapjoy.CHANNEL_CODE);
            }
        }

        @Override
        public void onPurchaseRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s) {
            YLog.i("Tapjoy  onPurchaseRequest");
        }

        @Override
        public void onRewardRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s, int i) {
            YLog.i("Tapjoy  onRewardRequest");
        }

        @Override
        public void onClick(TJPlacement tjPlacement) {
            if(interstitialCallback != null){
                interstitialCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }
    };


    @Override
    public void showIntersititalAdvert(Activity activity, final Yodo1AdCallback callback) {
        this.interstitialCallback = callback;

        try{
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    if (directPlayPlacement != null && directPlayPlacement.isContentReady()) {
                        directPlayPlacement.showContent();

                    } else {
                        callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", AdConfigTapjoy.CHANNEL_CODE);
                    }

                }
            });
        }catch (Exception exception){
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "Exception", AdConfigTapjoy.CHANNEL_CODE);
        }



    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.reloadCallback = callback;
        if(TextUtils.isEmpty(AdConfigTapjoy.placementInterstitial)){
            YLog.e("AdvertAdapterTapjoy, placementInterstitial is null");
            reloadCallback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL,0,"",getAdvertCode());
            return;
        }

        try{
            if(Tapjoy.isConnected() ) {
                onConnectSuccess();
                directPlayPlacement.requestContent();
            } else {
                YLog.i("Tapjoy SDK must finish connecting before requesting content.");
            }
        }catch (Exception exception){
            YLog.i("Tapjoy SDK Exception .");
        }

    }
    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return directPlayPlacement != null && directPlayPlacement.isContentReady();
    }

    private void onConnectSuccess() {
        if(AdvertCoreTapjoy.getInstance().isInit && !isconnect) {
            YLog.i("AdvertAdapterTapjoy, Interstitial onConnectSuccess");
            directPlayPlacement = Tapjoy.getPlacement(AdConfigTapjoy.placementInterstitial, interstitialListener);
            Tapjoy.setEarnedCurrencyListener(new TJEarnedCurrencyListener() {
                @Override
                public void onEarnedCurrency(String currencyName, int amount) {

                }
            });
            isconnect = true;
        }

    }



    @Override
    public String getAdvertCode() {
        return AdConfigTapjoy.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }
    @Override
    public void validateAdsAdapter(Activity activity) {
        AdvertCoreTapjoy.getInstance().validateAdsAdapter(activity);
    }
    @Override
    public void onCreate(Activity activity) {
        AdvertCoreTapjoy.getInstance().init(activity);

    }

    @Override
    public void onResume(Activity activity) {
        AdvertCoreTapjoy.getInstance().onActivityStart(activity);
    }

    @Override
    public void onPause(Activity activity) {
        AdvertCoreTapjoy.getInstance().onActivityStop(activity);
    }

    @Override
    public void onDestroy(Activity activity) {

    }

}
