package com.yodo1.advert.interstitial.channel;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;

import com.facebook.ads.*;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.interstitial.AdInterstitialAdapterBase;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.plugin.facebook.AdConfigFaceBook;
import com.yodo1.advert.plugin.facebook.AdvertCoreFaceboosk;
import com.yodo1.sdk.kit.YLog;

public class AdvertAdapterfacebook extends AdInterstitialAdapterBase{
    private Yodo1AdCallback intersititalCallback; //插屏回调
    private InterstitialAd interstitialAd;
    private Yodo1ReloadCallback callback;
    private InterstitialAdListener adListener = new InterstitialAdListener() {
        @Override
        public void onInterstitialDisplayed(Ad ad) {
            if(intersititalCallback != null){
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onInterstitialDismissed(Ad ad) {
            if(intersititalCallback != null){
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }

            interstitialAd.destroy();
            interstitialAd = null;
        }

        @Override
        public void onError(Ad ad, AdError adError) {

            YLog.e("Advert "+"异常码： "+adError.getErrorCode() + " 错误信息：" + adError.getErrorMessage());
            if(callback != null){
                callback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION,adError.getErrorCode() , adError.getErrorMessage(), getAdvertCode());
            }
        }

        @Override
        public void onAdLoaded(Ad ad) {
            if(callback != null){
                callback.onReloadSuccess(getAdvertCode());
            }

        }
        @Override
        public void onLoggingImpression(Ad ad) {

        }

        @Override
        public void onAdClicked(Ad ad) {
            if(intersititalCallback != null){
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }

        }
    };
    @Override
    public String getAdvertCode() {
        return AdConfigFaceBook.CHANNEL_CODE;
    }
    @Override
    public void validateAdsAdapter(Activity activity) {
        AdvertCoreFaceboosk.getInstance().validateAdsAdapter(activity);
    }

    @Override
    public void showIntersititalAdvert(Activity activity, Yodo1AdCallback callback) {
        this.intersititalCallback = callback;

        if (TextUtils.isEmpty( AdConfigFaceBook.INTERSTITIAL_ID)){
            YLog.e("Facebook  interstitialId  is null");
            intersititalCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "Facebook  interstitialId  is null", getAdvertCode());
            return ;
        }


        try{
            if (interstitialAd != null && interstitialAd.isAdLoaded()){
                interstitialAd.show();
            }else {
                intersititalCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
            }
        }catch (Exception exception){
            intersititalCallback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }




    }


    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return interstitialAd != null && interstitialAd.isAdLoaded();
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.callback = callback;
        if (TextUtils.isEmpty( AdConfigFaceBook.INTERSTITIAL_ID)){
            YLog.e("Facebook  interstitialId  is null");
            callback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL,0,"", getAdvertCode());
            return ;
        }

        if (interstitialAd != null) {
            interstitialAd.destroy();
            interstitialAd = null;
        }


        interstitialAd = new InterstitialAd(activity, AdConfigFaceBook.INTERSTITIAL_ID);
        interstitialAd.setAdListener(adListener);
        interstitialAd.loadAd();
    }

    @Override
    public void onCreateApplication(Application application) {
    }

    @Override
    public void onCreate(Activity activity) {

        AdConfigFaceBook.INTERSTITIAL_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd,
                AdConfigFaceBook.CHANNEL_CODE, AdConfigFaceBook.CONFIG_KEY_FACEBOOK_INTERSTITIAL_ID);
//        AdConfigFaceBook.INTERSTITIAL_ID = "1502425489821473_1556385974425424";

        AdConfigFaceBook.INTERSTITIAL_ID = "207701830019607_207935813329542";

//        AdSettings.addTestDevice("8daddc6ddbf53d5ae66a416c63cd582b");
    }


    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {
        if (interstitialAd != null) {
            interstitialAd.destroy();
            interstitialAd = null;
        }
    }

}
