package com.yodo1.advert.interstitial.channel;

import android.app.Activity;
import android.app.Application;
import android.text.TextUtils;

import com.applovin.adview.AppLovinInterstitialAd;
import com.applovin.adview.AppLovinInterstitialAdDialog;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdListener;
import com.applovin.mediation.ads.MaxInterstitialAd;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.applovin.sdk.AppLovinSdk;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.interstitial.AdInterstitialAdapterBase;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.plugin.applovin.AdConfigApplovin;
import com.yodo1.advert.plugin.applovin.AdvertCoreApplovin;
import com.yodo1.sdk.kit.YLog;


public class AdvertAdapterapplovinmax extends AdInterstitialAdapterBase {

    private Yodo1AdCallback intersititalCallback; //插屏回调
    private Yodo1ReloadCallback callback;
    private MaxInterstitialAd interstitialAd;

    private MaxAdListener adListener = new MaxAdListener() {
        @Override
        public void onAdLoaded(MaxAd maxAd) {
            YLog.d("Applovin Interstitial onAdDisplayed :  " + maxAd.getAdUnitId());
            if (callback != null) {
                callback.onReloadSuccess(getAdvertCode());
            }
        }

        @Override
        public void onAdLoadFailed(String s, int i) {
            YLog.d("Applovin Interstitial onAdDisplayed :  " + s + "   " + i);
            if (callback != null) {
                callback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, i, "error: " + s, getAdvertCode());
            }

            if (interstitialAd != null) {
                // Load the first ad
                interstitialAd.loadAd();
            }
        }

        @Override
        public void onAdDisplayed(MaxAd maxAd) {
            YLog.d("Applovin Interstitial onAdDisplayed :  " + maxAd.getAdUnitId());
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onAdHidden(MaxAd maxAd) {
            YLog.d("Applovin Interstitial onAdHidden :  " + maxAd.getAdUnitId());
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
            }

            if (interstitialAd != null) {
                // Load the first ad
                interstitialAd.loadAd();
            }
        }

        @Override
        public void onAdClicked(MaxAd maxAd) {
            YLog.d("Applovin Interstitial onAdClicked :  " + maxAd.getAdUnitId());
            if (intersititalCallback != null) {
                intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onAdDisplayFailed(MaxAd maxAd, int i) {
            YLog.d("Applovin Interstitial onAdDisplayFailed :  " + maxAd.getAdUnitId());
            if (callback != null) {
                callback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, i, "error: " + maxAd.getAdUnitId(), getAdvertCode());
            }
            if (interstitialAd != null) {
                // Load the first ad
                interstitialAd.loadAd();
            }
        }
    };
    @Override
    public String getAdvertCode() {
        return AdConfigApplovin.CHANNEL_CODE_MAX;
    }

    @Override
    public void validateAdsAdapter(Activity activity) {
        AdvertCoreApplovin.getInstance().validateAdsAdapter(activity);
    }

    //    预加载
    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.callback = callback;
        if (interstitialAd != null) {
            // Load the first ad
            interstitialAd.loadAd();
        } else {
            callback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_ID_NULL,0, "ID NULL", getAdvertCode());
        }
    }


    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return interstitialAd != null && interstitialAd.isReady();
    }

    @Override
    public void showIntersititalAdvert(Activity activity, final Yodo1AdCallback callback) {
        this.intersititalCallback = callback;
        if (interstitialAd != null && interstitialAd.isReady()) {
            // Load the first ad
            interstitialAd.showAd();
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }

    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {
        AdvertCoreApplovin.getInstance().Init(activity);

        String unitID =  Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, AdConfigApplovin.CHANNEL_CODE_MAX
                , AdConfigApplovin.KEY_Applovin_INTERSTITIAL_ID);

        if (TextUtils.isEmpty(unitID)){
            return;
        }
        interstitialAd = new MaxInterstitialAd( unitID, activity );
        interstitialAd.setListener( adListener );


    }


    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }


    @Override
    public void onDestroy(Activity activity) {

    }


}
