package com.yodo1.advert.interstitial.channel;

import android.app.Activity;
import android.app.Application;

import com.applovin.adview.AppLovinInterstitialAd;
import com.applovin.adview.AppLovinInterstitialAdDialog;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.applovin.sdk.AppLovinSdk;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1AdConst;
import com.yodo1.advert.Yodo1ReloadCallback;
import com.yodo1.advert.interstitial.AdInterstitialAdapterBase;
import com.yodo1.advert.plugin.applovin.AdConfigApplovin;
import com.yodo1.advert.plugin.applovin.AdvertCoreApplovin;


public class AdvertAdapterapplovin extends AdInterstitialAdapterBase implements AppLovinAdLoadListener,
        AppLovinAdDisplayListener, AppLovinAdClickListener, AppLovinAdVideoPlaybackListener {

    private Yodo1AdCallback intersititalCallback; //插屏回调
    private Yodo1ReloadCallback callback;
    private AppLovinAd currentAd;

    @Override
    public String getAdvertCode() {
        return AdConfigApplovin.CHANNEL_CODE;
    }

    @Override
    public void validateAdsAdapter(Activity activity) {
        AdvertCoreApplovin.getInstance().validateAdsAdapter(activity);
    }

    //    预加载
    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1ReloadCallback callback) {
        this.callback = callback;
        AppLovinSdk.getInstance(activity.getApplicationContext()).getAdService().loadNextAd(AppLovinAdSize.INTERSTITIAL, this);
    }


    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return currentAd == null ? false : true;
    }

    @Override
    public void showIntersititalAdvert(Activity activity, final Yodo1AdCallback callback) {
        this.intersititalCallback = callback;
        if (currentAd != null) {

            final AppLovinSdk sdk = AppLovinSdk.getInstance(activity);

            final AppLovinInterstitialAdDialog interstitialAd = AppLovinInterstitialAd.create(sdk, activity);
            interstitialAd.setAdDisplayListener(this);
            interstitialAd.setAdClickListener(this);
            interstitialAd.setAdVideoPlaybackListener(this);
            interstitialAd.showAndRender(currentAd);
        } else {
            callback.onAdError(Yodo1AdConst.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }

    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {
        AdvertCoreApplovin.getInstance().Init(activity);
    }


    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }


    @Override
    public void onDestroy(Activity activity) {

    }


    @Override
    public void adClicked(AppLovinAd appLovinAd) {
        if (intersititalCallback != null) {
            intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLICK, getAdvertCode());
        }
    }

    @Override
    public void adDisplayed(AppLovinAd appLovinAd) {
        if (intersititalCallback != null) {
            intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_DISPLAY, getAdvertCode());
        }
    }

    @Override
    public void adHidden(AppLovinAd appLovinAd) {
        if (intersititalCallback != null) {
            intersititalCallback.onEvent(Yodo1AdConst.ADVERT_EVENT_CLOSE, getAdvertCode());
        }
    }

    @Override
    public void adReceived(AppLovinAd appLovinAd) {
        currentAd = appLovinAd;
        if (callback != null) {
            callback.onReloadSuccess(getAdvertCode());
        }
    }

    @Override
    public void failedToReceiveAd(int i) {
        if (callback != null) {
            callback.onReloadFailed(Yodo1AdConst.ADVERT_ERROR_UNITE_EXCEPTION, i, "error: " + i, getAdvertCode());
        }
    }

    @Override
    public void videoPlaybackBegan(AppLovinAd appLovinAd) {

    }

    @Override
    public void videoPlaybackEnded(AppLovinAd appLovinAd, double v, boolean b) {

    }
}
