package com.yodo1.advert.helper;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.FragmentManager;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;

import com.yodo1.advert.factory.RequestManagerFragment;

import java.util.HashMap;
import java.util.Map;

public class Yodo1ManagerRetriever implements Handler.Callback{
    private static final String TAG = "RMRetriever";
    static final String FRAGMENT_TAG = "com.yodo1.advert.helper";
    /** The singleton instance of RequestManagerRetriever. */
    public static final Yodo1ManagerRetriever INSTANCE = new Yodo1ManagerRetriever();
    // Visible for testing.
    /** Pending adds for RequestManagerFragments. */
    final Map<FragmentManager, RequestManagerFragment> pendingRequestManagerFragments =
            new HashMap<FragmentManager, RequestManagerFragment>();

    private static final int ID_REMOVE_FRAGMENT_MANAGER = 1;

    /** Main thread handler to handle cleaning up pending fragment maps. */
    private final Handler handler;

    // Visible for testing.
    Yodo1ManagerRetriever() {
        handler = new Handler(Looper.getMainLooper(), this /* Callback */);
    }



    @TargetApi(Build.VERSION_CODES.HONEYCOMB)
    public void  initSDK(Activity activity) {
        assertNotDestroyed(activity);
        android.app.FragmentManager fm = activity.getFragmentManager();
        getRequestManagerFragment(fm);
    }

    @TargetApi(Build.VERSION_CODES.JELLY_BEAN_MR1)
    private void assertNotDestroyed(Activity activity) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1 && activity.isDestroyed()) {
            throw new IllegalArgumentException("You cannot start a load for a destroyed activity");
        }
    }

    @TargetApi(Build.VERSION_CODES.JELLY_BEAN_MR1)
    RequestManagerFragment getRequestManagerFragment(final android.app.FragmentManager fm) {
        RequestManagerFragment current = (RequestManagerFragment) fm.findFragmentByTag(FRAGMENT_TAG);
        if (current == null) {
            current = pendingRequestManagerFragments.get(fm);
            if (current == null) {
                current = new RequestManagerFragment();
                pendingRequestManagerFragments.put(fm, current);
                fm.beginTransaction().add(current, FRAGMENT_TAG).commitAllowingStateLoss();
                handler.obtainMessage(ID_REMOVE_FRAGMENT_MANAGER, fm).sendToTarget();
            }
        }
        return current;
    }

    @Override
    public boolean handleMessage(Message msg) {
        boolean handled = true;
        Object removed = null;
        Object key = null;
        switch (msg.what) {
            case ID_REMOVE_FRAGMENT_MANAGER:
                android.app.FragmentManager fm = (android.app.FragmentManager) msg.obj;
                key = fm;
                removed = pendingRequestManagerFragments.remove(fm);
                break;

            default:
                handled = false;
        }
        if (handled && removed == null && Log.isLoggable(TAG, Log.WARN)) {
            Log.w(TAG, "Failed to remove expected request manager fragment, manager: " + key);
        }
        return handled;
    }
}
