package com.yodo1.advert.adnative;

import android.app.Activity;

import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.Yodo1AdCallback;
import com.yodo1.advert.Yodo1ReloadCallback;

/**
 * Created by liumeili on 17/5/11.
 */
public abstract class AdNativeAdapterBase extends AdapterAdvertBase {

    /**
     * 显示原生广告
     * @param activity
     * @param px     广告的x位置，占比屏幕宽度比例，取值（0.001f~1.0f）
     * @param py     广告的y位置，占比屏幕宽度比例，取值（0.001f~1.0f）
     * @param pw     广告的宽度width，占比屏幕宽度比例，取值（0.001f~1.0f）
     * @param ph     广告的高度height，占比屏幕宽度比例，取值（0.001f~1.0f）
     * @param callback
     */
    public abstract void showNativeAdvert(Activity activity, float px, float py, float pw, float ph, Yodo1AdCallback callback);

    /**
     * 广告删除
     * @param activity
     */
    public abstract void removeNativeAdvert(Activity activity);

    /**
     * 广告预加载方法
     * @param activity
     */
    public abstract void reloadNativeAdvert(Activity activity, Yodo1ReloadCallback callback);

    /**
     * 是否预加载完成的方法
     * @param activity
     */
    public abstract boolean nativeAdvertIsLoaded(Activity activity);
}
