/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.vungle;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.IntegrationData;
import com.ironsource.mediationsdk.InterstitialSmash;
import com.ironsource.mediationsdk.RewardedVideoSmash;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.vungle.warren.AdConfig;
import com.vungle.warren.InitCallback;
import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.Vungle;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

class VungleAdapter
extends AbstractAdapter {
    private static final String VERSION = "4.1.4";
    private static final String CORE_SDK_VERSION = "6.3.17";
    private static final String APP_ID = "AppID";
    private static final String PLACEMENT_ID = "PlacementId";
    private static final String CONSENT_MESSAGE_VERSION = "1.0.0";
    private EInitState mInitState = EInitState.NOT_INIT;
    private Set<String> mInitiatedAdUnits;
    private Boolean mIsConsent = null;

    public static VungleAdapter startAdapter(String string) {
        return new VungleAdapter(string);
    }

    private VungleAdapter(String string) {
        super(string);
    }

    public static IntegrationData getIntegrationData(Activity activity) {
        IntegrationData integrationData = new IntegrationData("Vungle", VERSION);
        integrationData.validateWriteExternalStorage = true;
        return integrationData;
    }

    public String getVersion() {
        return VERSION;
    }

    public String getCoreSDKVersion() {
        return CORE_SDK_VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConsent(boolean bl2) {
        EInitState eInitState = this.mInitState;
        synchronized (eInitState) {
            if (this.getCurrentInitState() == EInitState.INIT_SUCCESS) {
                Vungle.updateConsentStatus((Vungle.Consent)(bl2 ? Vungle.Consent.OPTED_IN : Vungle.Consent.OPTED_OUT), (String)CONSENT_MESSAGE_VERSION);
            } else {
                this.mIsConsent = bl2;
            }
        }
    }

    public void onResume(Activity activity) {
    }

    public void onPause(Activity activity) {
    }

    public synchronized void initRewardedVideo(Activity activity, String string, String string2, JSONObject jSONObject, RewardedVideoSmashListener rewardedVideoSmashListener) {
        if (TextUtils.isEmpty((CharSequence)jSONObject.optString(APP_ID)) || TextUtils.isEmpty((CharSequence)jSONObject.optString(PLACEMENT_ID))) {
            if (rewardedVideoSmashListener != null) {
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            }
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)jSONObject.optString(PLACEMENT_ID)) && rewardedVideoSmashListener != null) {
            this.mRewardedVideoPlacementToListenerMap.put(jSONObject.optString(PLACEMENT_ID), rewardedVideoSmashListener);
        }
        this.addInitiatedAdUnit("Rewarded Video");
        HashSet hashSet = new HashSet();
        switch (this.getCurrentInitState()) {
            case NOT_INIT: {
                if (rewardedVideoSmashListener != null) {
                    hashSet = ((RewardedVideoSmash)rewardedVideoSmashListener).getAllSettingsForProvider(PLACEMENT_ID);
                }
                this.initVungleSdk(activity, jSONObject.optString(APP_ID), string2, hashSet);
                break;
            }
            case INIT_IN_PROGRESS: {
                break;
            }
            case INIT_SUCCESS: {
                if (Vungle.canPlayAd((String)jSONObject.optString(PLACEMENT_ID))) {
                    if (rewardedVideoSmashListener == null) break;
                    rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(true);
                    break;
                }
                this.loadRewardedVideoAd(jSONObject.optString(PLACEMENT_ID));
                break;
            }
            case INIT_FAIL: {
                if (rewardedVideoSmashListener == null) break;
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            }
        }
    }

    public void fetchRewardedVideo(JSONObject jSONObject) {
    }

    public void showRewardedVideo(JSONObject jSONObject, final RewardedVideoSmashListener rewardedVideoSmashListener) {
        AdConfig adConfig = new AdConfig();
        if (Vungle.canPlayAd((String)jSONObject.optString(PLACEMENT_ID))) {
            Vungle.setIncentivizedFields((String)this.getDynamicUserId(), null, null, null, null);
            Vungle.playAd((String)jSONObject.optString(PLACEMENT_ID), (AdConfig)adConfig, (PlayAdCallback)new PlayAdCallback(){

                public void onAdStart(String string) {
                    VungleAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, VungleAdapter.this.getProviderName() + ": RewardedVideo ad started for placementReferenceId: " + string, 1);
                    if (rewardedVideoSmashListener != null) {
                        rewardedVideoSmashListener.onRewardedVideoAdOpened();
                        rewardedVideoSmashListener.onRewardedVideoAdStarted();
                    }
                }

                public void onAdEnd(String string, boolean bl2, boolean bl3) {
                    VungleAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, VungleAdapter.this.getProviderName() + ": RewardedVideo ad ended for placementReferenceId: " + string, 1);
                    if (rewardedVideoSmashListener != null) {
                        if (bl3) {
                            rewardedVideoSmashListener.onRewardedVideoAdClicked();
                        }
                        rewardedVideoSmashListener.onRewardedVideoAdEnded();
                        if (bl2) {
                            rewardedVideoSmashListener.onRewardedVideoAdRewarded();
                        }
                        rewardedVideoSmashListener.onRewardedVideoAdClosed();
                        boolean bl4 = Vungle.canPlayAd((String)string);
                        rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(bl4);
                        if (!bl4) {
                            VungleAdapter.this.loadRewardedVideoAd(string);
                        }
                    }
                }

                public void onError(String string, Throwable throwable) {
                    VungleAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, VungleAdapter.this.getProviderName() + ": RewardedVideo ad failed to show for placementReferenceId: " + string + "error: " + throwable.getMessage(), 1);
                    if (rewardedVideoSmashListener != null) {
                        rewardedVideoSmashListener.onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Rewarded Video"));
                        rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
                    }
                }
            });
        }
    }

    public boolean isRewardedVideoAvailable(JSONObject jSONObject) {
        return Vungle.isInitialized() && Vungle.canPlayAd((String)jSONObject.optString(PLACEMENT_ID));
    }

    public synchronized void initInterstitial(Activity activity, String string, String string2, JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        if (TextUtils.isEmpty((CharSequence)jSONObject.optString(APP_ID)) || TextUtils.isEmpty((CharSequence)jSONObject.optString(PLACEMENT_ID))) {
            if (interstitialSmashListener != null) {
                interstitialSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing params", (String)"Interstitial"));
            }
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)jSONObject.optString(PLACEMENT_ID)) && interstitialSmashListener != null) {
            this.mInterstitialPlacementToListenerMap.put(jSONObject.optString(PLACEMENT_ID), interstitialSmashListener);
        }
        this.addInitiatedAdUnit("Interstitial");
        HashSet hashSet = new HashSet();
        switch (this.getCurrentInitState()) {
            case NOT_INIT: {
                if (interstitialSmashListener != null) {
                    hashSet = ((InterstitialSmash)interstitialSmashListener).getAllSettingsForProvider(PLACEMENT_ID);
                }
                this.initVungleSdk(activity, jSONObject.optString(APP_ID), string2, hashSet);
                break;
            }
            case INIT_IN_PROGRESS: {
                break;
            }
            case INIT_SUCCESS: {
                if (interstitialSmashListener == null) break;
                interstitialSmashListener.onInterstitialInitSuccess();
                break;
            }
            case INIT_FAIL: {
                if (interstitialSmashListener == null) break;
                interstitialSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"Init Failed", (String)"Interstitial"));
            }
        }
    }

    public void loadInterstitial(JSONObject jSONObject, final InterstitialSmashListener interstitialSmashListener) {
        if (Vungle.isInitialized()) {
            String string = jSONObject.optString(PLACEMENT_ID);
            if (Vungle.canPlayAd((String)string)) {
                if (interstitialSmashListener != null) {
                    interstitialSmashListener.onInterstitialAdReady();
                }
            } else {
                Vungle.loadAd((String)string, (LoadAdCallback)new LoadAdCallback(){

                    public void onAdLoad(String string) {
                        VungleAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, VungleAdapter.this.getProviderName() + ": Interstitial loaded for placementReferenceId: " + string, 1);
                        if (interstitialSmashListener != null) {
                            interstitialSmashListener.onInterstitialAdReady();
                        }
                    }

                    public void onError(String string, Throwable throwable) {
                        VungleAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, VungleAdapter.this.getProviderName() + ": Interstitial failed to load for placementReferenceId: " + string + " ,error: " + throwable.getMessage(), 1);
                        if (interstitialSmashListener != null) {
                            interstitialSmashListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)("Error loading Ad: " + throwable.getMessage())));
                        }
                    }
                });
            }
        }
    }

    public void showInterstitial(JSONObject jSONObject, final InterstitialSmashListener interstitialSmashListener) {
        if (Vungle.canPlayAd((String)jSONObject.optString(PLACEMENT_ID))) {
            Vungle.playAd((String)jSONObject.optString(PLACEMENT_ID), (AdConfig)new AdConfig(), (PlayAdCallback)new PlayAdCallback(){

                public void onAdStart(String string) {
                    VungleAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, VungleAdapter.this.getProviderName() + ": Interstitial ad started for placementReferenceId: " + string, 1);
                    if (interstitialSmashListener != null) {
                        interstitialSmashListener.onInterstitialAdOpened();
                        interstitialSmashListener.onInterstitialAdShowSucceeded();
                    }
                }

                public void onAdEnd(String string, boolean bl2, boolean bl3) {
                    VungleAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, VungleAdapter.this.getProviderName() + ": Interstitial ad ended for placementReferenceId: " + string, 1);
                    if (interstitialSmashListener != null) {
                        if (bl3) {
                            interstitialSmashListener.onInterstitialAdClicked();
                        }
                        interstitialSmashListener.onInterstitialAdClosed();
                    }
                }

                public void onError(String string, Throwable throwable) {
                    VungleAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, VungleAdapter.this.getProviderName() + ": Interstitial ad failed to show for placementReferenceId: " + string + "error: " + throwable.getMessage(), 1);
                    if (interstitialSmashListener != null) {
                        interstitialSmashListener.onInterstitialAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Interstitial"));
                    }
                }
            });
        } else if (interstitialSmashListener != null) {
            interstitialSmashListener.onInterstitialAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Interstitial"));
        }
    }

    public boolean isInterstitialReady(JSONObject jSONObject) {
        return Vungle.isInitialized() && Vungle.canPlayAd((String)jSONObject.optString(PLACEMENT_ID));
    }

    private synchronized void setInitState(EInitState eInitState) {
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + ":init state changed from " + (Object)((Object)this.mInitState) + " to " + (Object)((Object)eInitState) + ")", 1);
        this.mInitState = eInitState;
    }

    private synchronized EInitState getCurrentInitState() {
        return this.mInitState;
    }

    private void addInitiatedAdUnit(String string) {
        if (this.mInitiatedAdUnits == null) {
            this.mInitiatedAdUnits = new HashSet<String>();
        }
        this.mInitiatedAdUnits.add(string);
    }

    private void initVungleSdk(Activity activity, String string, String string2, HashSet<String> hashSet) {
        this.setInitState(EInitState.INIT_IN_PROGRESS);
        Vungle.init((String)string, (Context)activity.getApplicationContext(), (InitCallback)new InitCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess() {
                VungleAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, VungleAdapter.this.getProviderName() + ": Succeeded to initialize SDK ", 1);
                EInitState eInitState = VungleAdapter.this.mInitState;
                synchronized (eInitState) {
                    VungleAdapter.this.setInitState(EInitState.INIT_SUCCESS);
                    if (VungleAdapter.this.mIsConsent != null) {
                        Vungle.updateConsentStatus((Vungle.Consent)(VungleAdapter.this.mIsConsent != false ? Vungle.Consent.OPTED_IN : Vungle.Consent.OPTED_OUT), (String)VungleAdapter.CONSENT_MESSAGE_VERSION);
                    }
                }
                if (VungleAdapter.this.mInitiatedAdUnits != null) {
                    if (VungleAdapter.this.mInitiatedAdUnits.contains("Rewarded Video")) {
                        for (Map.Entry entry : VungleAdapter.this.mRewardedVideoPlacementToListenerMap.entrySet()) {
                            VungleAdapter.this.loadRewardedVideoAd((String)entry.getKey());
                        }
                    }
                    if (VungleAdapter.this.mInitiatedAdUnits.contains("Interstitial")) {
                        for (Map.Entry entry : VungleAdapter.this.mInterstitialPlacementToListenerMap.entrySet()) {
                            if (entry.getValue() == null) continue;
                            ((InterstitialSmashListener)entry.getValue()).onInterstitialInitSuccess();
                        }
                    }
                }
            }

            public void onError(Throwable throwable) {
                VungleAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, VungleAdapter.this.getProviderName() + ": Failed to initialize SDK ", 1);
                VungleAdapter.this.setInitState(EInitState.INIT_FAIL);
                if (VungleAdapter.this.mInitiatedAdUnits != null) {
                    if (VungleAdapter.this.mInitiatedAdUnits.contains("Rewarded Video")) {
                        for (Map.Entry entry : VungleAdapter.this.mRewardedVideoPlacementToListenerMap.entrySet()) {
                            if (entry.getValue() == null) continue;
                            ((RewardedVideoSmashListener)entry.getValue()).onRewardedVideoAvailabilityChanged(false);
                        }
                    }
                    if (VungleAdapter.this.mInitiatedAdUnits.contains("Interstitial")) {
                        for (Map.Entry entry : VungleAdapter.this.mInterstitialPlacementToListenerMap.entrySet()) {
                            if (entry.getValue() == null) continue;
                            ((InterstitialSmashListener)entry.getValue()).onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)("Vungle failed to init: " + throwable.getMessage()), (String)"Interstitial"));
                        }
                    }
                }
            }

            public void onAutoCacheAdAvailable(String string) {
                VungleAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, VungleAdapter.this.getProviderName() + ": Cache ad is available for placementId " + string, 1);
                if (VungleAdapter.this.mInitiatedAdUnits.contains("Rewarded Video")) {
                    for (Map.Entry entry : VungleAdapter.this.mRewardedVideoPlacementToListenerMap.entrySet()) {
                        if (!((String)entry.getKey()).equals(string) || entry.getValue() == null) continue;
                        ((RewardedVideoSmashListener)entry.getValue()).onRewardedVideoAvailabilityChanged(true);
                    }
                }
                if (VungleAdapter.this.mInitiatedAdUnits.contains("Interstitial")) {
                    for (Map.Entry entry : VungleAdapter.this.mInterstitialPlacementToListenerMap.entrySet()) {
                        if (!((String)entry.getKey()).equals(string) || entry.getValue() == null) continue;
                        ((InterstitialSmashListener)entry.getValue()).onInterstitialAdReady();
                    }
                }
            }
        });
    }

    private void loadRewardedVideoAd(String string) {
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + ": loadRewardedVideoAd placementId " + string, 1);
        Vungle.loadAd((String)string, (LoadAdCallback)new LoadAdCallback(){

            public void onAdLoad(String string) {
                VungleAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, VungleAdapter.this.getProviderName() + ": RewardedVideo Ad loaded for placementReferenceId: " + string, 1);
                if (VungleAdapter.this.mRewardedVideoPlacementToListenerMap.get(string) != null) {
                    ((RewardedVideoSmashListener)VungleAdapter.this.mRewardedVideoPlacementToListenerMap.get(string)).onRewardedVideoAvailabilityChanged(true);
                }
            }

            public void onError(String string, Throwable throwable) {
                VungleAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, VungleAdapter.this.getProviderName() + ": RewardedVideo Ad failed to load for placementReferenceId: " + string + ", error: " + throwable.getMessage(), 1);
                if (VungleAdapter.this.mRewardedVideoPlacementToListenerMap.get(string) != null) {
                    ((RewardedVideoSmashListener)VungleAdapter.this.mRewardedVideoPlacementToListenerMap.get(string)).onRewardedVideoAvailabilityChanged(false);
                }
            }
        });
    }

    private static enum EInitState {
        NOT_INIT,
        INIT_IN_PROGRESS,
        INIT_SUCCESS,
        INIT_FAIL;

    }
}

