package com.yodo1.sdk.kit;

import android.Manifest;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.support.v4.content.ContextCompat;
import android.telephony.TelephonyManager;
import android.text.TextUtils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * Created by yodo1 on 2016/5/25.
 */
public class Yodo1DeviceUtils {
    private static final String TAG = "Yodo1DeviceUtils";


    /**
     * 获取手机品牌
     *
     * @return 手机品牌
     */
    public static String getPhoneBrand() {
        String handSetInfo = android.os.Build.BRAND;
        return handSetInfo;

    }

    /**
     * 获取手机型号
     *
     * @return 手机型号
     */
    public static String getPhoneVersion() {
        String handSetInfo = android.os.Build.MODEL;
        return handSetInfo;

    }

    /**
     * 获取手机版本
     *
     * @return 系统版本
     */
    public static String getOsVersion() {
        String handSetInfo = android.os.Build.VERSION.RELEASE;
        return handSetInfo;

    }


    /**
     * 获取MAC地址
     *
     * @param context
     * @return
     */
    public static String getMacAddress(Context context) {
        String macStr = "";
        WifiManager wifi = (WifiManager) context.getSystemService(Context.WIFI_SERVICE);
        if (wifi != null) {
            WifiInfo info = wifi.getConnectionInfo();
            if (info != null) {
                macStr = info.getMacAddress();
                if (TextUtils.isEmpty(macStr)) {
                    macStr = "";
                }
            }
        }
        return macStr;
    }


    /**
     * 获取GoogleADsID
     *
     * @param context
     * @return
     */
    public static String getAdvertiserId(Context context) {
        try {
            String[] e = getAdvertisingIdInfo(context);
            return e.length > 0 && e[0] != null ? e[0] : "";
        } catch (Exception var3) {
            return "";
        }
    }

    public static String[] getAdvertisingIdInfo(Context c) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class mAdvertisingIdClientClass = Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient");
        Method getAdvertisingIdInfoMethod = mAdvertisingIdClientClass.getMethod("getAdvertisingIdInfo", new Class[]{Context.class});
        Object mInfoClass = getAdvertisingIdInfoMethod.invoke(mAdvertisingIdClientClass, new Object[]{c});
        Method getIdMethod = mInfoClass.getClass().getMethod("getId", new Class[0]);
        Method isLimitAdTrackingEnabledMethod = mInfoClass.getClass().getMethod("isLimitAdTrackingEnabled", new Class[0]);
        String advertisingId = getIdMethod.invoke(mInfoClass, new Object[0]).toString();
        boolean isLimitedTrackingEnabled = ((Boolean) isLimitAdTrackingEnabledMethod.invoke(mInfoClass, new Object[0])).booleanValue();
        return new String[]{advertisingId, "" + isLimitedTrackingEnabled};
    }


    /**
     * 获取设备ID。
     * <p>
     * 目前采取的策略是：第一次读取后在本地存储至本地，以后都从存储空间中读取。
     * <p>
     * 在6.0或者没有READ_PHONE_STATE的设备上，采取androidId + serial的方式。
     * 在非6.0并且有READ_PHONE_STATE权限的设备上，依旧采取老的imei方式
     *
     * @param ctx
     * @return 可以的话返回曾经的设备ID, 否则返回新策略生成的
     */
    public static String getDeviceId(Context ctx) {

        String deviceId = YFileUtils.readFilesFromSDCard(YFileUtils.YODO1FILE);
        if (TextUtils.isEmpty(deviceId) || deviceId.contains("openYodo1Log")) {
            deviceId = getDeviceIdForSave(ctx);
        }

        if (TextUtils.isEmpty(deviceId)) {
            deviceId = getIMEI(ctx);
        }

        if (TextUtils.isEmpty(deviceId)) {
            deviceId = java.util.UUID.randomUUID().toString();
            saveDeviceId(ctx, deviceId);
            YFileUtils.writeFilesToSDCard(deviceId, YFileUtils.YODO1FILE);
        }
        return deviceId;
    }


    private static String getIMEI(Context context) {
        String imei = "";
        int permissionCheck = ContextCompat.checkSelfPermission(context, Manifest.permission.READ_PHONE_STATE);
        if (permissionCheck == PackageManager.PERMISSION_GRANTED) {

            TelephonyManager telephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
            if (telephonyManager != null) {
                imei = telephonyManager.getDeviceId();
                if (TextUtils.isEmpty(imei) || "0".equals(imei) || "000000000000000".equals(imei)) {
                    imei = "";
                }
            }
        } else {
            YLog.d("没READ_PHONE_STATE权限,无法读取IMEI");
        }

        return imei;
    }


    private static void saveDeviceId(Context context, String value) {
        SharedPreferences sp = context.getSharedPreferences("sp_yodo1games", Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString("user_device_id", value);
        editor.apply();
    }

    private static String getDeviceIdForSave(Context context) {
        SharedPreferences sp = context.getSharedPreferences("sp_yodo1games", Context.MODE_PRIVATE);
        return sp.getString("user_device_id", null);
    }
}
