package com.yodo1.sdk.kit;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import android.util.Base64;
import android.widget.Toast;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Yodo1CommonUtils {

    /**
     * 从Mainfest中获取mata-data值
     *
     * @param context
     * @param key
     * @return
     */
    public static String getMetedataStr(Context context, String key) {
        String value = "";
        ApplicationInfo appInfo = null;
        try {
            appInfo = context.getPackageManager()
                    .getApplicationInfo(context.getPackageName(),
                            PackageManager.GET_META_DATA);
            value = appInfo.metaData.getString(key);
        } catch (Exception e) {
            YLog.d("key 未获取到");
        }
        return value;
    }


    /**
     * 手机号验证
     */
    public static boolean isMobile(final String str) {
        if (TextUtils.isEmpty(str)) {
            return false;
        }
        Pattern p = null;
        Matcher m = null;
        boolean b = false;
        p = Pattern.compile("^[1][3,4,5,7,8][0-9]{9}$"); // 验证手机号
        m = p.matcher(str);
        b = m.matches();
        return b;
    }


    /**
     * 2  * 获取版本号
     * 3  * @return 当前应用的版本号
     * 4
     */
    public static Long getLongValues(String str) {
        Long value = 0L;
        if (TextUtils.isEmpty(str)) {
            return value;
        }
        try {
            value = Long.valueOf(str);
        } catch (NumberFormatException e) {
            value = 0L;
            YLog.d("数据转换出现异常 NumberFormatException  异常内容： " + str);
        }

        return value;
    }




    /**
     * 获取UTC时间戳
     */
    public static long getUTCTime() {
        java.util.Calendar cal = java.util.Calendar.getInstance();
        return cal.getTimeInMillis();
    }

    public static byte[] gzipCompress(String data) throws IOException {
        if ((data == null) || (data.length() == 0)) {
            return new byte[0];
        }

        ByteArrayOutputStream baostream = null;
        GZIPOutputStream outStream = null;
        try {
            baostream = new ByteArrayOutputStream();
            outStream = new GZIPOutputStream(baostream) {
            };
            outStream.write(data.getBytes("UTF-8"));
            outStream.close();

            return baostream.toByteArray();
        } finally {
            try {
                if (baostream != null) {
                    baostream.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }


    public static String hmacWithKey(String key, byte[] data) {
        String result = "";
        try {
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA256");
            sha256_HMAC.init(secret_key);

            result = Base64.encodeToString(sha256_HMAC.doFinal(data), 0);
            YLog.d("hmacWithKey result==" + result);
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (InvalidKeyException e) {
            e.printStackTrace();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        return result;
    }
}
