package com.yodo1.advert.video.channel;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;

import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.plugin.ogury.AdConfigogury;
import com.yodo1.advert.plugin.ogury.AdvertCoreogury;
import com.yodo1.advert.video.AdVideoAdapterBase;
import com.yodo1.advert.video.Yodo1VideoCallback;
import com.yodo1.advert.video.Yodo1VideoReloadCallback;
import com.yodo1.sdk.kit.YLog;

import io.presage.common.AdConfig;
import io.presage.common.network.models.RewardItem;
import io.presage.interstitial.optinvideo.PresageOptinVideo;
import io.presage.interstitial.optinvideo.PresageOptinVideoCallback;

/**
 * Created by yodo1 on 17/9/14.
 */
public class AdvertAdapterogury extends AdVideoAdapterBase {
    private String video_id;
    private Yodo1VideoCallback adCallback;
    private Yodo1VideoReloadCallback reloadCallback;
    private PresageOptinVideo optinVideo;

    @Override
    public void showVideoAdvert(Activity activity, Yodo1VideoCallback callback) {
        adCallback = callback;

        if (optinVideo != null && optinVideo.isLoaded()) {
            optinVideo.show();
        } else {
            adCallback.onAdError(Yodo1VideoCallback.ADVERT_ERROR_LOADED_FAILED, "未获取到videoId", getAdvertCode());
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1VideoReloadCallback reloadCallback) {
        this.reloadCallback=reloadCallback;
        if (optinVideo != null){
            optinVideo.load();
        } else {
            YLog.d("OGURY     reloadVideoAdvert   failed ");
        }

    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return optinVideo != null && optinVideo.isLoaded();
    }

    @Override
    public String getAdvertCode() {
        return AdConfigogury.CHANNEL_CODE;
    }

    @Override
    public void validateAdsAdapter(Activity activity) {
        AdvertCoreogury.getInstance().validateAdsAdapter(activity);
    }


    private PresageOptinVideoCallback rewardedAdListener = new PresageOptinVideoCallback() {
        @Override
        public void onAdAvailable() {

        }

        @Override
        public void onAdNotAvailable() {

        }

        @Override
        public void onAdLoaded() {
            if (reloadCallback != null){
                reloadCallback.onResult(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD_FINISH, getAdvertCode());
            }
        }

        @Override
        public void onAdNotLoaded() {
            if (reloadCallback != null){
                reloadCallback.onResult(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD_FAILED, getAdvertCode());
            }
        }

        @Override
        public void onAdDisplayed() {
            if (adCallback != null){
                adCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onAdClosed() {
            if (adCallback != null){
                adCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_FINISH, getAdvertCode());
                adCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLOSE, getAdvertCode());

            }
        }

        @Override
        public void onAdError(int i) {
            YLog.d("OGURY   onAdError ： " + i);

        }

        @Override
        public void onAdRewarded(RewardItem rewardItem) {

        }

    };

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {

        AdvertCoreogury.getInstance().initSDK(activity);
        video_id = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, AdConfigogury.CHANNEL_CODE
                , AdConfigogury.KEY_OGURY_VIDEO_ID);

        if(TextUtils.isEmpty(video_id)) {
            YLog.e("OGURY  video AD_UNIT_ID null");
            return;
        }

        optinVideo = new PresageOptinVideo(activity, new AdConfig(video_id));
        optinVideo.setOptinVideoCallback(rewardedAdListener);
    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }
}
