package com.yodo1.advert.video.channel;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;

import com.inmobi.ads.InMobiAdRequestStatus;
import com.inmobi.ads.InMobiInterstitial;
import com.inmobi.sdk.InMobiSdk;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.plugin.inmobi.AdConfigInmobi;
import com.yodo1.advert.plugin.inmobi.AdvertCoreInmobi;
import com.yodo1.advert.video.AdVideoAdapterBase;
import com.yodo1.advert.video.Yodo1VideoCallback;
import com.yodo1.advert.video.Yodo1VideoReloadCallback;
import com.yodo1.sdk.kit.YLog;

import java.util.Map;

/**
 * Created by yodo1 on 2016/3/21.
 */
public class AdvertAdapterinmobi extends AdVideoAdapterBase {

    private Yodo1VideoCallback videoCallback; //视频回调
    private Yodo1VideoReloadCallback reloadCallback; //视频预加载回调
    private boolean isLoaded = false;
    private InMobiInterstitial interstitial;

    private InMobiInterstitial.InterstitialAdListener2 interstitialAdListener = new InMobiInterstitial.InterstitialAdListener2() {
        @Override
        public void onAdLoadSucceeded(InMobiInterstitial ad) {
            if(videoCallback != null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_LOADED, getAdvertCode());
            }
            if (reloadCallback != null){
                reloadCallback.onResult(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD_FINISH,getAdvertCode());
            }
            isLoaded = true;
        }
        @Override
        public void onAdLoadFailed(InMobiInterstitial ad, InMobiAdRequestStatus requestStatus) {

            YLog.w("Advert, onAdLoadFailed   " + requestStatus.getMessage());
            YLog.w("Advert, onAdLoadFailed   " + requestStatus.getStatusCode());
            if(videoCallback != null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_ERROR_LOADED_FAILED, getAdvertCode());
            }
            isLoaded = false;
        }

        @Override
        public void onAdReceived(InMobiInterstitial inMobiInterstitial) {

        }

        @Override
        public void onAdDisplayed(InMobiInterstitial ad) {
            if(videoCallback != null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
            isLoaded = false;
        }
        @Override
        public void onAdDismissed(InMobiInterstitial ad) {
            if(videoCallback != null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
            isLoaded = false;
        }
        @Override
        public void onAdInteraction(InMobiInterstitial ad, Map<Object, Object> params) {
            if(videoCallback != null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLICK, getAdvertCode());
            }
            isLoaded = false;
        }
        @Override
        public void onAdRewardActionCompleted(InMobiInterstitial ad, Map<Object, Object> rewards) {
            if(videoCallback != null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_FINISH, getAdvertCode());
            }
            isLoaded = false;
        }

        @Override
        public void onAdDisplayFailed(InMobiInterstitial inMobiInterstitial) {
            if(videoCallback != null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_DISPLAY_FAILED, getAdvertCode());
            }
            isLoaded = false;
        }

        @Override
        public void onAdWillDisplay(InMobiInterstitial inMobiInterstitial) {
            isLoaded = true;
        }

        @Override
        public void onUserLeftApplication(InMobiInterstitial ad) {
        }
    };
    @Override
    public void showVideoAdvert(Activity activity, Yodo1VideoCallback callback) {
        this.videoCallback = callback;
        if(videoAdvertIsLoaded(activity)){
            interstitial.show();
        }else {
            videoCallback.onAdError(Yodo1VideoCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }

        isLoaded = false;
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1VideoReloadCallback reloadCallback) {
        this.reloadCallback = reloadCallback;
        if(TextUtils.isEmpty(AdConfigInmobi.PLACEMENT_ID)) {
            YLog.e("AdvertAdapterInmobi video PLACEMENT_ID is null");
            return;
        }
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                interstitial.load();
            }
        });

        if (reloadCallback != null){
            reloadCallback.onResult(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD,getAdvertCode());
        }
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return isLoaded ;
    }

    @Override
    public String getAdvertCode() {
        return AdConfigInmobi.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

//        AdConfigInmobi.PLACEMENT_ID = Yodo1PropertiesUtils.getInstance().getBasicConfigValue(AdConfigInmobi.KEY_INMOBI_PLACEMENT_ID);

    }

    @Override
    public void onCreate(Activity activity) {
        InMobiSdk.setLogLevel(InMobiSdk.LogLevel.DEBUG);
        AdvertCoreInmobi.getInstance().init(activity);
        AdConfigInmobi.PLACEMENT_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, AdConfigInmobi.CHANNEL_CODE
                , AdConfigInmobi.KEY_INMOBI_PLACEMENT_ID);

        if(TextUtils.isEmpty(AdConfigInmobi.PLACEMENT_ID)) {
            YLog.e("AdvertAdapterInmobi video PLACEMENT_ID is null");
            return;
        }
        interstitial = new InMobiInterstitial(activity, Long.parseLong(AdConfigInmobi.PLACEMENT_ID), interstitialAdListener);
    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }
}
