package com.yodo1.advert.unity;

import android.app.Activity;

import com.yodo1.advert.callback.BannerCallback;
import com.yodo1.advert.callback.InterstitialCallback;
import com.yodo1.advert.callback.NativeCallback;
import com.yodo1.advert.callback.VideoCallback;
import com.yodo1.advert.entity.AdErrorCode;
import com.yodo1.advert.entity.AdEventCode;
import com.yodo1.advert.helper.Yodo1AdvertHelper;
import com.yodo1.advert.open.Yodo1Advert;
import com.yodo1.sdk.kit.YLog;

import org.json.JSONException;
import org.json.JSONObject;

public class UnityYodo1Advertising {

    /**
     * 播放视频广告
     *
     * @param gameObject
     * @param callbackName
     */
    public static void showVideo(final String gameObject, final String callbackName) {
        YLog.i("Yodo1SDK, Unity call Android --- showVideo ...");
        final Activity activity = UnityYodo1SDK.getActivity();
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Yodo1Advert.showVideo(activity, new VideoCallback() {

                    @Override
                    public void onVideoClosed(boolean isFinished) {
                        if (isFinished){
                            UnityYodo1SDK.unitySendMessage(gameObject, callbackName, convertShowRewardToJsonStr(UnityFlag.FLAG_VIDEO, AdEventCode.ADVERT_EVENT_FINISH, ""));
                        } else {
                            UnityYodo1SDK.unitySendMessage(gameObject, callbackName, convertShowRewardToJsonStr(UnityFlag.FLAG_VIDEO, AdEventCode.ADVERT_EVENT_CLOSE, ""));
                        }
                    }

                    @Override
                    public void onVideoShow() {
                        UnityYodo1SDK.unitySendMessage(gameObject, callbackName, convertShowRewardToJsonStr(UnityFlag.FLAG_VIDEO, AdEventCode.ADVERT_EVENT_DISPLAY, ""));
                    }

                    @Override
                    public void onVideoShowFailed(AdErrorCode errorCode) {
                        UnityYodo1SDK.unitySendMessage(gameObject, callbackName, convertShowRewardToJsonStr(UnityFlag.FLAG_VIDEO, AdEventCode.ADVERT_EVENT_DISPLAY_FAILED, ""));
                    }

                    @Override
                    public void onVideoClicked() {
                        UnityYodo1SDK.unitySendMessage(gameObject, callbackName, convertShowRewardToJsonStr(UnityFlag.FLAG_VIDEO, AdEventCode.ADVERT_EVENT_CLICK, ""));

                    }
                });
            }
        });

    }



    /**
     * 播放插屏
     * @param gameObject
     * @param callbackName
     */
    public static void showInterstitial(final String gameObject, final String callbackName){
        YLog.i("Yodo1SDK, Unity call Android --- showInterstitial ...");
        final Activity activity = UnityYodo1SDK.getActivity();
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Yodo1Advert.showInterstitial(activity, new InterstitialCallback() {

                    @Override
                    public void onInterstitialClosed() {
                        UnityYodo1SDK.unitySendMessage(gameObject, callbackName, convertShowRewardToJsonStr(UnityFlag.FLAG_INTERSTITIAL, AdEventCode.ADVERT_EVENT_CLOSE, ""));
                    }

                    @Override
                    public void onInterstitialShowSucceeded() {
                        UnityYodo1SDK.unitySendMessage(gameObject, callbackName, convertShowRewardToJsonStr(UnityFlag.FLAG_INTERSTITIAL, AdEventCode.ADVERT_EVENT_DISPLAY, ""));
                    }

                    @Override
                    public void onInterstitialShowFailed(AdErrorCode errorCode) {
                        UnityYodo1SDK.unitySendMessage(gameObject, callbackName, convertShowRewardToJsonStr(UnityFlag.FLAG_INTERSTITIAL, AdEventCode.ADVERT_EVENT_DISPLAY_FAILED, ""));
                    }

                    @Override
                    public void onInterstitialClicked() {
                        UnityYodo1SDK.unitySendMessage(gameObject, callbackName, convertShowRewardToJsonStr(UnityFlag.FLAG_INTERSTITIAL, AdEventCode.ADVERT_EVENT_CLICK, ""));

                    }

                });
            }
        });

    }

    /**
     *
     * @param gameObject
     * @param px     广告的x位置，占比屏幕宽度比例，取值（0.001f~1.0f）
     * @param py     广告的y位置，占比屏幕宽度比例，取值（0.001f~1.0f）
     * @param pw     广告的宽度width，占比屏幕宽度比例，取值（0.001f~1.0f）
     * @param ph     广告的高度height，占比屏幕宽度比例，取值（0.001f~1.0f）
     *               如:showNativeAdvert(this,0.2f, 0.3f,0.6f, 0.3f);
     * @param callbackName
     */
    public static void showNativeAd(final String gameObject, final float px, final float py, final float pw, final float ph, final String callbackName) {
        YLog.i("Yodo1SDK, Unity call Android --- showNativeAd ...");
        UnityYodo1SDK.getActivity().runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Yodo1AdvertHelper.getInstance().showNativeAd(UnityYodo1SDK.getActivity(), px, py, pw, ph, new NativeCallback() {
                    @Override
                    public void onNativeClosed() {
                        UnityYodo1SDK.unitySendMessage(gameObject, callbackName, convertShowRewardToJsonStr(UnityFlag.FLAG_NATIVE, AdEventCode.ADVERT_EVENT_CLOSE, ""));

                    }

                    @Override
                    public void onNativeShow() {
                        UnityYodo1SDK.unitySendMessage(gameObject, callbackName, convertShowRewardToJsonStr(UnityFlag.FLAG_NATIVE, AdEventCode.ADVERT_EVENT_DISPLAY, ""));

                    }

                    @Override
                    public void onNativeShowFailed(AdErrorCode errorCode) {
                        UnityYodo1SDK.unitySendMessage(gameObject, callbackName, convertShowRewardToJsonStr(UnityFlag.FLAG_NATIVE, AdEventCode.ADVERT_EVENT_DISPLAY_FAILED, ""));

                    }

                    @Override
                    public void onNativeClicked() {
                        UnityYodo1SDK.unitySendMessage(gameObject, callbackName, convertShowRewardToJsonStr(UnityFlag.FLAG_NATIVE, AdEventCode.ADVERT_EVENT_CLICK, ""));

                    }
                });
            }
        });
    }



    /**
     * 关闭原生广告
     */
    public static void removeNativeAd() {
        YLog.i("Yodo1SDK, Unity call Android --- removeNativeAd ...");
        Yodo1AdvertHelper.getInstance().removeNativeAd(UnityYodo1SDK.getActivity());
    }

    public static boolean nativeIsReady() {
        return Yodo1AdvertHelper.getInstance().nativeAdIsLoaded(UnityYodo1SDK.getActivity());
    }

    /**
     * 播放Banner
     * @param gameObject
     * @param callbackName
     */
    public static void ShowBanner(final String gameObject, final String callbackName){
        YLog.i("Yodo1SDK, Unity call Android --- showBannerAd ...");
        final Activity activity = UnityYodo1SDK.getActivity();
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Yodo1Advert.ShowBanner(activity, new BannerCallback() {

                    @Override
                    public void onBannerClosed() {
                        UnityYodo1SDK.unitySendMessage(gameObject, callbackName, convertShowRewardToJsonStr(UnityFlag.FLAG_BANNER, AdEventCode.ADVERT_EVENT_CLOSE, ""));

                    }

                    @Override
                    public void onBannerShow() {
                        UnityYodo1SDK.unitySendMessage(gameObject, callbackName, convertShowRewardToJsonStr(UnityFlag.FLAG_BANNER, AdEventCode.ADVERT_EVENT_DISPLAY, ""));

                    }

                    @Override
                    public void onBannerShowFailed(AdErrorCode errorCode) {
                        UnityYodo1SDK.unitySendMessage(gameObject, callbackName, convertShowRewardToJsonStr(UnityFlag.FLAG_BANNER, AdEventCode.ADVERT_EVENT_DISPLAY_FAILED, ""));

                    }

                    @Override
                    public void onBannerClicked() {
                        UnityYodo1SDK.unitySendMessage(gameObject, callbackName, convertShowRewardToJsonStr(UnityFlag.FLAG_BANNER, AdEventCode.ADVERT_EVENT_CLICK, ""));

                    }


                });
            }
        });
    }

    /**
     * 设置banner位置
     *
     * @param align
     */
    public static void  SetBannerAlign(final  int align){
        YLog.i("call Yodo1Advert setBannerAlign ...");
        final Activity activity = UnityYodo1SDK.getActivity();
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Yodo1Advert.SetBannerAlign(activity,align);
            }});
    }


    /**
     * 隐藏Banner
     */
    public static void HideBanner(){
        YLog.i("Yodo1SDK, Unity call Android --- hideBanner ...");

        final Activity activity = UnityYodo1SDK.getActivity();
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Yodo1Advert.HideBanner(activity);
            }});
    }

    /**
     * 关闭Banner
     */
    public static void RemoveBanner(){
        YLog.i("Yodo1SDK, Unity call Android --- removeBanner ...");

        final Activity activity = UnityYodo1SDK.getActivity();
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Yodo1Advert.RemoveBanner(activity);
            }});
    }


    /**
     * 检测是否有视频可以播放
     *
     * @return A boolean value
     */
    public static boolean videoIsReady() {
        YLog.i("Yodo1SDK, Unity call Android --- videoReady ...");

        return Yodo1Advert.videoIsReady(UnityYodo1SDK.getActivity());
    }

    /**
     * 是否已经缓存好插屏广告
     *
     * @return A boolean value
     */
    public static boolean interstitialIsReady() {
        YLog.i("Yodo1SDK, Unity call Android --- videoReady ...");
        return Yodo1Advert.interstitialIsReady(UnityYodo1SDK.getActivity());
    }



    /**
     * 将显示广告的状态转换为json字符串
     *
     * @return a string
     */
    private static String convertShowRewardToJsonStr(int flag, int code, String advertCode) {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("resulType", flag);
            jsonObj.put("code", code);
            jsonObj.put("advertCode", advertCode);
        } catch (JSONException ignored) {

        }
        return jsonObj.toString();
    }
}
