package com.yodo1.advert.plugin.ogury;

import android.app.Activity;
import android.text.TextUtils;

import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.ValidateUtils;
import com.yodo1.sdk.kit.YLog;

import org.w3c.dom.Text;

import java.util.Arrays;
import java.util.List;

import io.presage.Presage;

/**
 * Created by yodo1 on 17/9/1.
 */
public class AdvertCoreogury {

    private static AdvertCoreogury instance;

    public static AdvertCoreogury getInstance(){
        if(instance == null){
            instance = new AdvertCoreogury();
        }
        return instance;
    }

    private boolean validate = false;
    public  void validateAdsAdapter(Activity activity){
        if(!validate) {
            List<String> meizuActivities = Arrays.asList(new String[]{"io.presage.EulaActivity",
                    "io.presage.interstitial.InterstitialActivity",
                    "io.presage.interstitial.InterstitialAndroid8TransparentActivity",
                    "io.presage.interstitial.InterstitialAndroid8RotableActivity",
                    "io.presage.mraid.browser.ShortcutActivity"});
            ValidateUtils.validateActivities(activity, meizuActivities);

            List<String> meizuServices = Arrays.asList(new String[]{"io.presage.common.profig.schedule.ProfigJobService",
                    "io.presage.PSD",
                    "io.presage.common.profig.schedule.ProfigJobService"});
            ValidateUtils.validateServices(activity, meizuServices);


            List<String> meizuReceivers = Arrays.asList(new String[]{"io.presage.receiver.AlarmReceiver",
                    "io.presage.common.profig.schedule.ProfigAlarmReceiver"});
            ValidateUtils.validateBroadcastReceivers(activity, meizuReceivers);
            validate = true;
        }

    }

    private boolean init = false;
    public  void initSDK(Activity activity){
        if(!validate) {

            String appid = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, AdConfigogury.CHANNEL_CODE
                    , AdConfigogury.KEY_OGURY_APPID);

            if (TextUtils.isEmpty(appid)){
                appid = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, AdConfigogury.CHANNEL_CODE
                        , AdConfigogury.KEY_OGURY_APPID);

            }
//            appid = "272993";
            if (TextUtils.isEmpty(appid)){
                YLog.d("OGURY  APPID  NULL");
                return;
            }
            Presage.getInstance().start(appid, activity); // this = current activity
            validate = true;
        }

    }
}
