package com.yodo1.advert.plugin.inmobi;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;

import com.inmobi.sdk.InMobiSdk;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.ValidateUtils;
import com.yodo1.sdk.kit.YLog;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by yodo1 on 2016/4/21.
 */
public class AdvertCoreInmobi {
    private static AdvertCoreInmobi instance;
    private AdvertCoreInmobi(){}
    public static AdvertCoreInmobi getInstance(){
        if(instance == null){
            instance = new AdvertCoreInmobi();
        }
        return instance;
    }

    private boolean isInit = false;

    public  void init(final Activity context){

        if(!isInit) {
            AdConfigInmobi.APP_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, AdConfigInmobi.CHANNEL_CODE
                    , AdConfigInmobi.KEY_INMOBI_APP_ID);
            if(TextUtils.isEmpty(AdConfigInmobi.APP_ID )) {
                YLog.e("AdvertCoreInmobi AdConfigInmobi.APP_ID is null");
                return;
            }

           YLog.e("InMobi  APPID==  " + AdConfigInmobi.APP_ID);
           final JSONObject consentObject = new JSONObject();
            try {
                consentObject.put(InMobiSdk.IM_GDPR_CONSENT_AVAILABLE, true);
                consentObject.put("gdpr", "1");
            } catch (JSONException exception) {
                exception.printStackTrace();
            }

            InMobiSdk.init(context, AdConfigInmobi.APP_ID,consentObject);
//            InMobiSdk.init(context, "1234567890qwerty0987654321qwerty12345", consentObject);
//            InMobiSdk.setLogLevel(InMobiSdk.LogLevel.DEBUG);


            isInit = true;
        }

    }

    private boolean validate = false;
    public  void validateAdsAdapter(Activity activity){
        if(!validate) {
            List<String> inmobiActivities = Arrays.asList(new String[] { "com.inmobi.rendering.InMobiAdActivity" });
            ValidateUtils.validateActivities(activity,inmobiActivities);

            validate = true;
        }

    }

    public boolean isNumeric(String str){
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        if( !isNum.matches() ){
            return false;
        }
        return true;
    }
}
