package com.yodo1.advert.interstitial.channel;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.os.Handler;
import android.text.TextUtils;


import com.yodo1.advert.interstitial.AdInterstitialAdapterBase;
import com.yodo1.advert.interstitial.Yodo1InterstitialCallback;
import com.yodo1.advert.interstitial.Yodo1InterstitialReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.plugin.ogury.AdConfigogury;
import com.yodo1.advert.plugin.ogury.AdvertCoreogury;
import com.yodo1.sdk.kit.YLog;

import io.presage.interstitial.PresageInterstitial;
import io.presage.interstitial.PresageInterstitialCallback;

public class AdvertAdapterogury extends AdInterstitialAdapterBase{
    private Yodo1InterstitialCallback callback;
    private PresageInterstitial interstitial;;
    private boolean isLoaded = false;
    private PresageInterstitialCallback adListener = new PresageInterstitialCallback(){

        @Override
        public void onAdAvailable() {

        }

        @Override
        public void onAdNotAvailable() {

        }

        @Override
        public void onAdLoaded() {
            YLog.i("ogury   onLoadFinished");
        }

        @Override
        public void onAdNotLoaded() {
            YLog.i("ogury   onAdNotLoaded " );
        }

        @Override
        public void onAdDisplayed() {
            if(callback != null){
                callback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onAdClosed() {
            if(callback != null){
                callback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onAdError(int i) {
               /*
                code 0: load failed
                code 1: phone not connected to internet
                code 2: ad disabled
                code 3: various error (configuration file not synced)
                code 4: ad expires in 4 hours if it was not shown
                code 5: start method not called
                */

            YLog.i("ogury   onInterstitialAdFailed : " + i);
        }


    };
    @Override
    public String getAdvertCode() {
        return AdConfigogury.CHANNEL_CODE;
    }


    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1InterstitialReloadCallback callback) {
        YLog.i("Advert Interstitial ogury, 调用预加载接口");
        if (interstitial != null){
            interstitial.load();
        }
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return isLoaded;
    }
    @Override
    public void showIntersititalAdvert(final Activity activity, final Yodo1InterstitialCallback callback) {
        this.callback = callback;
        if (interstitial != null && interstitial.isLoaded()){
            interstitial.show();
        }else {
            callback.onAdError(Yodo1InterstitialCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }

        isLoaded = false;
    }

    @Override
    public void onCreateApplication(Application application) {
    }

    @Override
    public void onCreate(Activity activity) {


        AdvertCoreogury.getInstance().initSDK(activity);
        String interstitialID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd,
                AdConfigogury.CHANNEL_CODE, AdConfigogury.KEY_OGURY_INTERSTITIAL_ID);
//        interstitialID = "28f49570-6aeb-0136-f0e8-0242ac120003";

        String appid = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, AdConfigogury.CHANNEL_CODE
                , AdConfigogury.KEY_OGURY_APPID);


        if (TextUtils.isEmpty(interstitialID) || TextUtils.isEmpty(appid)){
            YLog.i("ogury  interstitialAd  unitId  null ");
            return;
        }

        interstitial = new PresageInterstitial(activity);
        interstitial.setInterstitialCallback(adListener);
    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }
}
