package com.yodo1.advert.interstitial.channel;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;

import com.inmobi.ads.InMobiAdRequestStatus;
import com.inmobi.ads.InMobiInterstitial;
import com.inmobi.ads.listeners.InterstitialAdEventListener;
import com.inmobi.sdk.InMobiSdk;
import com.yodo1.advert.interstitial.AdInterstitialAdapterBase;
import com.yodo1.advert.interstitial.Yodo1InterstitialCallback;
import com.yodo1.advert.interstitial.Yodo1InterstitialReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.plugin.inmobi.AdConfigInmobi;
import com.yodo1.advert.plugin.inmobi.AdvertCoreInmobi;
import com.yodo1.sdk.kit.YLog;

import java.util.Map;

/**
 * Created by liumeili on 17/9/1.
 */
public class AdvertAdapterinmobi extends AdInterstitialAdapterBase{

    private InMobiInterstitial interstitialAd;
    private boolean isCanshow;
    private Yodo1InterstitialCallback interstitialCallback;


    @Override
    public void showIntersititalAdvert(Activity activity, Yodo1InterstitialCallback callback) {
        this.interstitialCallback = callback;
        YLog.i("InMobi  showIntersititalAdvert  " + isCanshow);
        if (isCanshow ){
            interstitialAd.show();
            isCanshow = false;
        } else {
            callback.onAdError(Yodo1InterstitialCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());

        }
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1InterstitialReloadCallback callback) {

        if(!TextUtils.isEmpty(AdConfigInmobi.PLACEMENT_ID) && AdvertCoreInmobi.getInstance().isNumeric(AdConfigInmobi.PLACEMENT_ID )) {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    interstitialAd.load();
                }
            });

        } else {
            callback.onResult(Yodo1InterstitialReloadCallback.ADVERT_INTERSTITIAL_RELOAD_FAILED,getAdvertCode());
        }

    }
    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return isCanshow;
    }
    @Override
    public String getAdvertCode() {
        return AdConfigInmobi.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(final Activity activity) {

        AdvertCoreInmobi.getInstance().init(activity);
//        AdConfigInmobi.PLACEMENT_ID = Yodo1PropertiesUtils.getInstance().getBasicConfigValue(AdConfigInmobi.KEY_INMOBI_PLACEMENT_ID);
        AdConfigInmobi.PLACEMENT_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, AdConfigInmobi.CHANNEL_CODE
                , AdConfigInmobi.KEY_INMOBI_PLACEMENT_ID);
        YLog.i("InMobi  PLACEMENT_ID===  " +  AdConfigInmobi.PLACEMENT_ID );
        if(!TextUtils.isEmpty(AdConfigInmobi.PLACEMENT_ID) && AdvertCoreInmobi.getInstance().isNumeric(AdConfigInmobi.PLACEMENT_ID )) {
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    interstitialAd = new InMobiInterstitial(activity, Long.parseLong(AdConfigInmobi.PLACEMENT_ID), mInterstitialListener);
                }
            });

        } else {
            YLog.i("InMobi  PLACEMENT_ID异常  " +  AdConfigInmobi.PLACEMENT_ID );
        }
    }

    InterstitialAdEventListener mInterstitialListener = new InterstitialAdEventListener(){

        @Override
        public void onAdLoadFailed(InMobiInterstitial inMobiInterstitial, InMobiAdRequestStatus inMobiAdRequestStatus) {
            isCanshow = false;
            YLog.i("InMobi  载入广告失败! " + inMobiAdRequestStatus.getStatusCode() + inMobiAdRequestStatus.getMessage());
            if(interstitialCallback != null){
                interstitialCallback.onEvent(Yodo1InterstitialCallback.ADVERT_ERROR_LOADED_FAILED, getAdvertCode());
            }
        }

        @Override
        public void onAdReceived(InMobiInterstitial inMobiInterstitial) {
            YLog.i("InMobi  onAdReceived!");
            isCanshow = true;
        }

        @Override
        public void onAdLoadSucceeded(InMobiInterstitial inMobiInterstitial) {
            if (inMobiInterstitial.isReady()) {
                isCanshow = true;
                YLog.i("InMobi  载入广告成功,可以播放了!");
                if(interstitialCallback != null){
                    interstitialCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_LOADED, getAdvertCode());
                }
            } else {
                YLog.i("InMobi      onAdLoadSuccessful but not ready");
            }

        }


        @Override
        public void onAdDisplayFailed(InMobiInterstitial inMobiInterstitial) {
            YLog.e("InMobi  广告展示失败!" + inMobiInterstitial.getCreativeId());
            if(interstitialCallback != null){
                interstitialCallback.onAdError(Yodo1InterstitialCallback.ADVERT_ERROR_LOADED_FAILED, "onAdDisplayFailed", getAdvertCode());
            }
        }

        @Override
        public void onAdWillDisplay(InMobiInterstitial inMobiInterstitial) {
            YLog.i("InMobion    AdWillDisplay!");
        }

        @Override
        public void onAdDisplayed(InMobiInterstitial inMobiInterstitial) {
            YLog.i("InMobi  插屏展示!");
            if(interstitialCallback != null){
                interstitialCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }


        @Override
        public void onAdDismissed(InMobiInterstitial inMobiInterstitial) {
            YLog.i("InMobi  onAdDismissed!");
            if (interstitialCallback != null){
                interstitialCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onUserLeftApplication(InMobiInterstitial inMobiInterstitial) {
            YLog.i("InMobi  onUserLeftApplication!");
        }
    };

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }

}
