package com.yodo1.advert.helper;

import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.text.TextUtils;

import com.yodo1.advert.AdLifecycle;
import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.adnative.AdNativeAdapterBase;
import com.yodo1.advert.adnative.Yodo1NativeCallback;
import com.yodo1.advert.adnative.Yodo1NativeReloadCallback;
import com.yodo1.advert.banner.AdBannerAdapterBase;
import com.yodo1.advert.banner.Yodo1BannerCallback;
import com.yodo1.advert.callback.BannerCallback;
import com.yodo1.advert.callback.InterstitialCallback;
import com.yodo1.advert.callback.NativeCallback;
import com.yodo1.advert.callback.SplashCallback;
import com.yodo1.advert.callback.VideoCallback;
import com.yodo1.advert.entity.AdErrorCode;
import com.yodo1.advert.entity.AdEventCode;
import com.yodo1.advert.entity.AdvertType;
import com.yodo1.advert.factory.Yodo1AdvertAdapterFactory;
import com.yodo1.advert.interstitial.AdInterstitialAdapterBase;
import com.yodo1.advert.interstitial.Yodo1InterstitialCallback;
import com.yodo1.advert.interstitial.Yodo1InterstitialReloadCallback;
import com.yodo1.advert.onlineconfig.AdsConfigEntity;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.open.Yodo1Advert;
import com.yodo1.advert.splash.AdSplashAdapterBase;
import com.yodo1.advert.splash.Yodo1SplashCallback;
import com.yodo1.advert.utils.AppsflyerUtils;
import com.yodo1.advert.utils.YOnlineConfigUtils;
import com.yodo1.advert.video.AdVideoAdapterBase;
import com.yodo1.advert.video.Yodo1VideoCallback;
import com.yodo1.advert.video.Yodo1VideoReloadCallback;
import com.yodo1.android.ops.net.Yodo1HttpManage;
import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.plugin.dmp.yodo1.constants.AnalyticsConst;
import com.yodo1.plugin.dmp.yodo1.open.Yodo1Analytics;
import com.yodo1.sdk.kit.YFileUtils;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1CommonUtils;
import com.yodo1.sdk.kit.Yodo1NetWorkUtils;
import com.yodo1.sdk.kit.Yodo1PermissonUtils;
import com.yodo1.sdk.kit.Yodo1PropertiesUtils;
import com.yodo1.sdk.kit.Yodo1SharedPreferences;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by yodo1 on 2016/3/18.
 */
public class Yodo1AdvertHelper implements AdLifecycle {
    private static Yodo1AdvertHelper instance;
    private Activity activity;
    private String gameAppkey = "";
    private ArrayList<String> playlist_intersital = new ArrayList<String>(); //已经排序好的播放列表, 插屏用
    private ArrayList<AdvertBean> adverts_intersital = new ArrayList<AdvertBean>(); //按权重排序的广告实体, 插屏用
    private int playtimes_interstitial = 0; //插屏广告的播放次数
    private long showtimes_interstitial = 0; //插屏广告的最后显示时间
    private long showtimes_native = 0;
    private ArrayList<String> playlist_video = new ArrayList<String>(); //已经排序好的播放列表, 游戏视频用
    private ArrayList<AdvertBean> adverts_video = new ArrayList<AdvertBean>(); //按权重排序的广告实体, 游戏视频用
    private ArrayList<String> playlist_banner = new ArrayList<String>(); //已经排序好的播放列表, banner用
    private ArrayList<AdvertBean> adverts_banner = new ArrayList<AdvertBean>(); //按权重排序的广告实体, banner用
    private ArrayList<String> playlist_native = new ArrayList<String>(); //已经排序好的播放列表, 原生广告用
    private ArrayList<AdvertBean> adverts_native = new ArrayList<AdvertBean>(); //按权重排序的广告实体, 原生广告用
    private ArrayList<String> playlist_splash = new ArrayList<String>(); //闪屏广告播放列表
    private int playtimes_video = 0; //游戏视频广告的播放次数
    private int playtimes_banner = 0; //banner广告的播放次数
    private int playtimes_native = 0;
    private boolean initPlayList = false;
    private boolean hasRegistered = false;
    private int showAllTimes_splash = 0;//开屏广告展示总次数
    //广告接收到在线参数后再初始化SDK
    private BroadcastReceiver myReceiver = new BroadcastReceiver() {

        @Override
        public void onReceive(final Context context, Intent intent) {
            //广告插件生命周期
            YLog.d("Yodo1OnlineConfig  接收到广播，初始化广告");
            YLog.i("Yodo1AdvertHelper  在线参数已经获取，初始化广告");

            if (YOnlineConfigUtils.isTrunOnAdForChina(activity)){
                YLog.i("Yodo1Advert   中文环境下广告打开 非中文不初始化");
                return;
            }

            if (YOnlineConfigUtils.isNeedRequestPermisson()){
                YLog.i("Yodo1Advert   权限开关已经打开  即将请求权限");
                Yodo1PermissonUtils.requestPermisson(activity);//申请展示广告所需的权限
            }

            initSDK2();
            new Handler().postDelayed(new Runnable() {
                public void run() {
                    //execute the task
                    onAdvertResume(activity);
                    Yodo1Analytics.onResume(activity);
                }

            }, 500);
        }

    };

    private Yodo1AdvertHelper() {
    }

    public synchronized static Yodo1AdvertHelper getInstance() {
        if (instance == null) {
            instance = new Yodo1AdvertHelper();
        }
        return instance;
    }

    @Override
    public void onCreateApplication(Application application) {
        Yodo1Analytics.createApp(application);
        Yodo1OnlineConfig.getInstance().init(application, "");
        if (Yodo1OnlineConfig.getInstance().hasData()) {
            Yodo1AdvertAdapterFactory.getInstance().initAdvertAdapters(application);
        }

        //需判断本地是否存在在线参数，之后接入国内广告的处理
        for (AdvertType type : AdvertType.values()) {
            for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters(type).entrySet()) {
                if (adapter.getValue() != null) {
                    adapter.getValue().onCreateApplication(application);
                }
            }
        }
    }


    private boolean isInit = false;
    public void init(final Activity activity,final String appKey) {
        this.activity = activity;
        if (isInit){
            YLog.i("Yodo1Advert 已初始化完成 "  );
            return;
        }
        isInit = true;

        this.activity = activity;
        gameAppkey = appKey;
        String sdk_version = Yodo1CommonUtils.getMetedataStr(activity,"Yodo1SDKVersion");
        if (TextUtils.isEmpty(sdk_version)){
            sdk_version = "1.0.0";
        }
        YLog.v("Yodo1Advert 当前SDK版本号为 ： " + sdk_version);
        Yodo1HttpManage.getInstance().initHttp(activity);

        String str = YFileUtils.readFilesFromSDCard(YFileUtils.YODO1FILE);
        if (!TextUtils.isEmpty(str) && str.contains("openYodo1Log")){
            YLog.setDebugMode(true);
            YLog.setOnLog(true);
            YLog.d("开启Yodo1Log，打开测试模式");
        }
        //初始化yodo1在线参数
        Yodo1OnlineConfig.getInstance().init(activity, appKey);

        if (!Yodo1OnlineConfig.getInstance().hasData()) {
            IntentFilter filter = new IntentFilter();
            filter.addAction(Yodo1OnlineConfig.ONLINECONFIG_ACTION);
            filter.setPriority(Integer.MAX_VALUE);
            activity.registerReceiver(myReceiver, filter);
            hasRegistered = true;
        } else {
            YLog.d("Yodo1OnlineConfig 本地有相关数据，初始化广告");

            if (YOnlineConfigUtils.isTrunOnAdForChina(activity)){
                YLog.i("Yodo1Advert   中文环境下广告打开 非中文不初始化");
                return;
            }
            if (YOnlineConfigUtils.isNeedRequestPermisson()){
                YLog.i("Yodo1Advert   权限开关已经打开  即将请求权限");
                Yodo1PermissonUtils.requestPermisson(activity);//申请展示广告所需的权限
            }
            initSDK2();
        }
    }

    private void initSDK2() {

        Thread thread = new Thread(new Runnable() {
            @Override
            public void run() {
                //线程执行内容
                activity.runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        initSDK();
                    }
                });
            }
        });
        //开启线程
        thread.start();



    }

    private void initSDK() {
        if(TextUtils.isEmpty(gameAppkey)){
            YLog.e("gameAppkey is null...");
            return;
        }
        Yodo1Analytics.initSDK(activity,gameAppkey);
        //加载全部已引用的广告插件
        //初始化播放列表
        Yodo1AdvertAdapterFactory.getInstance().initAdvertAdapters(activity);//100毫秒反射各广告平台
        Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdInit,"","");
        Yodo1Analytics.onEvent(AnalyticsConst.VideoAdInit,"","");
        Yodo1Analytics.onEvent(AnalyticsConst.BannerAdInit,"","");
        Yodo1Analytics.onEvent(AnalyticsConst.NativeAdInit,"","");
        //默认播放次数均为0
        playtimes_interstitial = 0;
        playtimes_video = 0;
        playtimes_banner = 0;
        playtimes_native = 0;



        //初始化播放列表
        loadAdvertPlayList(activity);
        for (AdvertType type : AdvertType.values()) {
            for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters(type).entrySet()) {
                if (adapter.getValue() != null) {
                    adapter.getValue().onCreate(activity);
                    YLog.d("Yodo1AdvertHelper  初始化广告  : " + type.name() + "  " + adapter.getValue().getAdvertCode());
                    if (adapter.getValue() instanceof AdInterstitialAdapterBase) { //预加载所有广告插件
                        Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdInitChannel,adapter.getKey(),"");//插屏广告平台初始化统计
                        reloadInterstitialAdvert((AdInterstitialAdapterBase)adapter.getValue(),activity,adapter.getKey());
                    } else if (adapter.getValue() instanceof AdVideoAdapterBase) {
                        Yodo1Analytics.onEvent(AnalyticsConst.VideoAdInitChannel,adapter.getKey(),"");//视频广告平台初始化统计
                        reloadVideoAdvert((AdVideoAdapterBase) adapter.getValue(), activity,adapter.getKey());//预加载视频广告插件
                    }else if (adapter.getValue() instanceof AdBannerAdapterBase) {
                        Yodo1Analytics.onEvent(AnalyticsConst.BannerAdInitChannel,adapter.getKey(),"");//视频广告平台初始化统计
                    }else if (adapter.getValue() instanceof AdNativeAdapterBase) {
                        Yodo1Analytics.onEvent(AnalyticsConst.NativeAdInitChannel,adapter.getKey(),"");
                        reloadNativeAdvert((AdNativeAdapterBase) adapter.getValue(), activity,adapter.getKey());
                    }

                }
            }
        }

        if (Yodo1Advert.openLog){
            Thread thread = new Thread(new Runnable() {
                @Override
                public void run() {
                    validateAdsAdapter(activity);
                }
            });
            //开启线程
            thread.start();
        }
    }


    /**
     * 校验广告SDK manifest申明是否正确
     */
    public void validateAdsAdapter(Activity activity) {
        for (AdvertType type : AdvertType.values()) {
            for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters(type).entrySet()) {
                if (adapter.getValue() != null && activity != null) {
                    adapter.getValue().validateAdsAdapter(activity);
                }
            }
        }
    }



    @Override
    public void onCreate(final Activity activity) {

    }

    @Override
    public void onStart(Activity activity) {
        for (AdvertType type : AdvertType.values()) {
            for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters(type).entrySet()) {
                if (adapter.getValue() != null) {
                    adapter.getValue().onStart(activity);
                }
            }
        }
    }

    @Override
    public void onResume(Activity activity) {
        if (Yodo1OnlineConfig.getInstance().hasData()) {
            onAdvertResume(activity);
            Yodo1Analytics.onResume(activity);
        }

        Yodo1OnlineConfig.getInstance().getOnlineConfig(activity);
    }

    //广告的OnResume 方法
    public void onAdvertResume(final Activity activity) {
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                for (AdvertType type : AdvertType.values()) {
                    for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters(type).entrySet()) {
                        if (adapter.getValue() != null) {
                            adapter.getValue().onResume(activity);
                        }
                    }
                }
            }
        });


    }

    @Override
    public void onPause(Activity activity) {
        for (AdvertType type : AdvertType.values()) {
            for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters(type).entrySet()) {
                if (adapter.getValue() != null) {
                    adapter.getValue().onPause(activity);
                }
            }
        }
        Yodo1Analytics.onPause(activity);
    }

    @Override
    public void onRestart(Activity activity) {
        for (AdvertType type : AdvertType.values()) {
            for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters(type).entrySet()) {
                if (adapter.getValue() != null) {
                    adapter.getValue().onRestart(activity);
                }
            }
        }
    }

    @Override
    public void onStop(Activity activity) {
        for (AdvertType type : AdvertType.values()) {
            for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters(type).entrySet()) {
                if (adapter.getValue() != null) {
                    adapter.getValue().onStop(activity);
                }
            }
        }
    }

    @Override
    public void onDestroy(Activity activity) {
        for (AdvertType type : AdvertType.values()) {
            for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters(type).entrySet()) {
                if (adapter.getValue() != null) {
                    adapter.getValue().onDestroy(activity);
                }
            }
        }
        if (hasRegistered){
            hasRegistered = false;

            try{
                activity.unregisterReceiver(myReceiver);
            } catch (IllegalArgumentException e){
                YLog.e("onDestroy出现异常： " + e.getMessage());
            }

        }
        Yodo1Analytics.onDestroy();
        Yodo1HttpManage.getInstance().onDestroy();
    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {
        for (AdvertType type : AdvertType.values()) {
            for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters(type).entrySet()) {
                if (adapter.getValue() != null) {
                    adapter.getValue().onActivityResult(activity, requestCode, resultCode, data);
                }
            }
        }
    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {
        for (AdvertType type : AdvertType.values()) {
            for (Map.Entry<String, AdapterAdvertBase> adapter : Yodo1AdvertAdapterFactory.getInstance().getAdapters(type).entrySet()) {
                if (adapter.getValue() != null) {
                    adapter.getValue().onNewIntent(activity, intent);
                }
            }
        }
    }

    /**
     * 加载播放列表
     *
     * @param context
     */
    public void loadAdvertPlayList(Context context) {
        YLog.d("Yodo1AdvertHelper, loadAdvertPlayList call ...");
        if (initPlayList) {//确保广告列表只初始化一次
            YLog.d("Yodo1AdvertHelper, loadAdvertPlayList 确保广告列表只初始化一次");
            return;
        }
        initPlayList = true;


        initAdvertList(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd); //初始化插屏播放列表
        initAdvertList(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd);//初始化游戏视频播放列表
        initAdvertList(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd);//初始化游戏视频播放列表
        initAdvertList(Yodo1OnlineConfigAgent.AdvertType.Platform_NativeAd);

    }

    /**
     * 显示插屏广告
     *
     * @param activity
     * @return 是否允许显示插屏广告，当在线参数上的开关关闭，或没到时间间隔，会返回false
     */

    public boolean showInterstitialAd(final Activity activity, final InterstitialCallback callback) {
        YLog.d("Yodo1AdvertHelper, showInterstitialAd call ...");
        Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShow,"","");
        if (!Yodo1NetWorkUtils.isNetworkConnected(activity)) {
            YLog.v("Yodo1AdvertHelper, 当前网络不可用");
            Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShow,"",AnalyticsConst.ShowResulet_failed);
            callback.onInterstitialShowFailed(AdErrorCode.ADVERT_ERROR_NETWORK);
            return false;
        }
        //检查库引用列表
        if (Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Interstitial) == null || Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Interstitial).size() == 0) {
            YLog.v("Yodo1AdvertHelper, 播放中断， 请检查本地引用");
            Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShow,"",AnalyticsConst.ShowResulet_failed);
            callback.onInterstitialShowFailed(AdErrorCode.ADVERT_ERROR_NO_SUPPORT);
            return false;
        }
        //检查后台是否打开开关
        if (!YOnlineConfigUtils.isTrunOnAdvertInterstitial()) {
            YLog.v("Yodo1AdvertHelper, 播放中断， 在线参数开关关闭");
            Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShow,"",AnalyticsConst.ShowResulet_failed);
            callback.onInterstitialShowFailed(AdErrorCode.ADVERT_ERROR_SWITCHCLOSE);
            return false;
        }

        long interval = YOnlineConfigUtils.getIntervalAdvertInterstitial();
        if (System.currentTimeMillis() - showtimes_interstitial < interval) {
            YLog.v("Yodo1AdvertHelper, 播放中断, 未达到指定的时间间隔");
            Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShow,"",AnalyticsConst.ShowResulet_failed);
            callback.onInterstitialShowFailed(AdErrorCode.ADVERT_ERROR_MISS_INTERVAL);
            return false;
        }
        //统计调用
        if (playlist_intersital != null && playlist_intersital.size() > 0) {
            String firstCode = playlist_intersital.get(0);
            Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShowChannel,firstCode,"");
            YLog.i("Yodo1AdvertHelper, playlist_intersital  " + playlist_intersital.toString() + "   " + firstCode);
            showInterstitialAdByChannel(activity, firstCode, new Yodo1InterstitialCallback() {
                private int index = 0; //当前播放次序
                private boolean isFinish = false;

                @Override
                public void onEvent(int eventCode, String advertCode) {

                    YLog.d("Yodo1AdvertHelper, showInterstitialAd callback, event = " + eventCode + ", advertCode = " + advertCode);
                    switch (eventCode) {
                        case Yodo1InterstitialCallback.ADVERT_EVENT_CLICK:
                            sendMsg(activity,"Click",advertCode);
                            callback.onInterstitialClicked();
                            Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShowResultChannel,advertCode,AnalyticsConst.ShowResulet_click);
                            break;
                        case Yodo1InterstitialCallback.ADVERT_EVENT_CLOSE:
                            sendMsg(activity,"Close",advertCode);
                            callback.onInterstitialClosed();
                            Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShowResultChannel,advertCode,AnalyticsConst.ShowResulet_close);
                            Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShow,advertCode,AnalyticsConst.ShowResulet_close);
                            AppsflyerUtils.AF_Event(activity, AppsflyerUtils.AF_INTERSTITIAL_EVENT_NAME, advertCode, AnalyticsConst.ShowResulet_close);
                            break;
                        case Yodo1InterstitialCallback.ADVERT_EVENT_DISPLAY:
                            //保存当前时间用于进行显示间隔的判断
                            showtimes_interstitial = System.currentTimeMillis();
                            callback.onInterstitialShowSucceeded();
                            YLog.v("Yodo1AdvertHelper, showInterstitialAd " + advertCode + "   插屏广告展示成功");
                            sendMsg(activity,"DisPlay",advertCode);
                            break;
                        case Yodo1InterstitialCallback.ADVERT_EVENT_LOADED:
//                            callback.interstitialDidLoad();
                            break;
                    }

                }

                @Override
                public void onAdError(int errorCode, String errorMsg, String advertCode) {
                    sendMsg(activity,"ShowFailed",advertCode);
                    Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShowResultChannel,advertCode,AnalyticsConst.ShowResulet_failed);
                    if (index < playlist_intersital.size() - 1) { //播放列表还没到最后
                        //播放下一顺位的广告
                        index++;
                        String nextCode = playlist_intersital.get(index);

                        YLog.d("Yodo1AdvertHelper, nextCode == " + nextCode);
                        Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdShowChannel,nextCode,"");
                        showInterstitialAdByChannel(activity, nextCode, this);


                    } else { //全部播放完毕, 也就是全部失败
                        // 统计失败
                        YLog.d("Yodo1AdvertHelper, 插屏广告展示失败 ...");
                        if (callback != null) {
                            callback.onInterstitialShowFailed(AdErrorCode.ADVERT_ERROR_LOADED_FAILED);
                        }
                    }
                }


            });
            return true;
        } else {
            YLog.d("Yodo1AdvertHelper, 播放失败, 播放列表为空");
            callback.onInterstitialShowFailed(AdErrorCode.ADVERT_ERROR_NO_ADLIST);
        }
        return false;
    }





    /**
     * 展示某家渠道的插屏广告
     *
     * @param activity
     * @param advertCode 要展示的渠道
     * @param callback
     */
    private void showInterstitialAdByChannel(final Activity activity, final String advertCode, final Yodo1InterstitialCallback callback) {
        YLog.d("Yodo1AdvertHelper, showInterstitialAdByChannel call ...");

        final AdInterstitialAdapterBase adapter = (AdInterstitialAdapterBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Interstitial).get(advertCode);
        if (adapter != null) {
            //统计调用
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    adapter.showIntersititalAdvert(activity, new Yodo1InterstitialCallback() {
                        @Override
                        public void onEvent(int eventCode, String advertCode) {
                            YLog.d("Yodo1AdvertHelper, showInterstitialAdByChannel callback, event = " + eventCode + ", advertCode = " + advertCode);

                            callback.onEvent(eventCode, advertCode);
                            if (eventCode == Yodo1InterstitialCallback.ADVERT_EVENT_CLOSE ) {
                                //重载
                                YLog.d("Yodo1AdvertHelper,   播放完成，预加载下一次  当前展示广告为： " + advertCode);
                                showEnd(AdvertType.Interstitial, advertCode);
                                reloadInterstitialAdvert(adapter,activity,advertCode);
                            }
                        }

                        @Override
                        public void onAdError(int errorCode, String errorMsg, String advertCode) {
                            YLog.v("Yodo1AdvertHelper, " + advertCode + "的插屏广告展示失败, 错误原因可能为: " + errorMsg + ", errorCode = " + errorCode);
                            callback.onAdError(errorCode, errorMsg,advertCode);
                            //只有在加载失败的时候才进行预加载

                            reloadInterstitialAdvert(adapter,activity,advertCode);
                        }

                    });
                }
            });
        } else {
            YLog.v("Yodo1AdvertHelper, error, advertCode为" + advertCode + "的广告没有引入");
            callback.onAdError(AdEventCode.ADVERT_ERROR_UNKNOW, "advertPlugin is null",advertCode);
        }
    }


    /**
     * 预加载回调结果
     *
     * @param adapterBase
     * @param activity
     */
    public void reloadInterstitialAdvert(final AdInterstitialAdapterBase adapterBase, final Activity activity,String advertCode) {
        Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdReloadChannel,advertCode,"");
        YLog.d("Yodo1AdvertHelper, reloadInterstitialAdvert ： " + advertCode);
        if (!Yodo1NetWorkUtils.isNetworkConnected(activity)) {
            YLog.v("Yodo1AdvertHelper, 当前网络不可用");
            return;
        }
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                adapterBase.reloadInterstitialAdvert(activity, new Yodo1InterstitialReloadCallback() {//预加载结果的回调

                    @Override
                    public void onResult(int resultCode, String advertCode) {

                        switch (resultCode) {
                            case Yodo1InterstitialReloadCallback.ADVERT_INTERSTITIAL_RELOAD_FINISH:
                                Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdReloadResultChannel,advertCode,AnalyticsConst.ReloadResulet_finish);
                                YLog.d("Yodo1AdvertHelper, reloadInterstitialAdvert 预加载完毕, callback, resultCode = " + resultCode + ", advertCode = " + advertCode);
                                break;
                            case Yodo1InterstitialReloadCallback.ADVERT_INTERSTITIAL_RELOAD_FAILED:
                                Yodo1Analytics.onEvent(AnalyticsConst.InterstitialAdReloadResultChannel,advertCode,AnalyticsConst.ReloadResulet_failed);
                                YLog.i("Yodo1AdvertHelper, reloadInterstitialAdvert 预加载失败, callback, resultCo " + resultCode + ", advertCode = " + advertCode);
                                break;
                        }
                    }
                });
            }
        });


    }

    /**
     * 预加载插屏广告是否成功
     *
     * @param activity
     */
    public boolean interstitialAdIsLoaded(final Activity activity) {
        if (!YOnlineConfigUtils.isTrunOnAdvertInterstitial()) {
            return false;
        }
        if (playlist_intersital != null && playlist_intersital.size() > 0) {
            //如果有一个加载成功即为true
            boolean isLoaded = false;
            for (int i = 0; i < playlist_intersital.size(); i++) {
                String advertCode = playlist_intersital.get(i);
                YLog.d("Yodo1AdvertHelper, adverts_interstitial advertCode  ： " + advertCode);
                final AdInterstitialAdapterBase adapter = (AdInterstitialAdapterBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Interstitial).get(advertCode);

                if (adapter != null) {
                    if (adapter.interstitialAdvertIsLoaded(activity)) {
                        YLog.d("Yodo1AdvertHelper,interstitial 预加载完成 " + advertCode);

                        isLoaded = true;
                    } else //没有完成加载的要重新加载
                    {
                        YLog.d("Yodo1AdvertHelper,interstitial 预加载失败 " + advertCode);
                        reloadInterstitialAdvert(adapter,activity,advertCode);
                    }
                }
            }

            return isLoaded;
        } else {
            YLog.v("Yodo1AdvertHelper,插屏广告列表为空");
            return false;
        }
    }
    /**
     * 显示游戏视频广告
     *
     * @param activity
     * @return 是否允许显示插屏广告，当在线参数上的开关关闭，或没到时间间隔，会返回false
     */
    public boolean showVideoAd(final Activity activity, final VideoCallback callback) {
        Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShow,"","");
        YLog.d("Yodo1AdvertHelper, showVideoAd call ...");
        //检查库引用列表
        if (Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Video) == null || Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Video).size() == 0) {
            YLog.v("Yodo1AdvertHelper, 播放中断， 请检查本地引用");
            Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShow,"",AnalyticsConst.ShowResulet_failed);
            callback.onVideoShowFailed(AdErrorCode.ADVERT_ERROR_NO_SUPPORT);
            return false;
        }
        //检查后台是否打开开关
        if (!YOnlineConfigUtils.isTrunOnAdvertVideo()) {
            YLog.v("Yodo1AdvertHelper, 播放中断， 在线参数开关关闭");
            Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShow,"",AnalyticsConst.ShowResulet_failed);
            callback.onVideoShowFailed(AdErrorCode.ADVERT_ERROR_SWITCHCLOSE);
            return false;
        }

        //统计调用
        if (playlist_video != null && playlist_video.size() > 0) {
            String firstCode = playlist_video.get(0);
            Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShowChannel,firstCode,"");
            YLog.d("Yodo1AdvertHelper, playlist_video  " + playlist_video.toString() + "   " + firstCode);
            showVideoAdByChannel(activity, firstCode, new Yodo1VideoCallback() {
                private int index = 0; //当前播放次序
                private  boolean isFinish = false;


                @Override
                public void onEvent(int eventCode,final String advertCode) {
                    YLog.d("Yodo1AdvertHelper, showVideoAd callback, event = " + eventCode + ", advertCode = " + advertCode);
                    switch (eventCode) {
                        case Yodo1VideoCallback.ADVERT_EVENT_CLICK:
                            sendMsg(activity,"Click",advertCode);
                            Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShowResultChannel,advertCode,AnalyticsConst.ShowResulet_click);
                            callback.onVideoClicked();
                            break;
                        case Yodo1VideoCallback.ADVERT_EVENT_FINISH:
                            isFinish = true;
                            YLog.d("Video  ad  finish ");

//                            callback.videoDidComplete();
                            //重载
                            break;
                        case Yodo1VideoCallback.ADVERT_EVENT_CLOSE:
                            YLog.d("Video  ad  close ");
                            //当走close方法时，延时执行0.5s.等待finish回调。确保close方法一定在finish之后再调用
                            new Handler().postDelayed(new Runnable() {
                                public void run() {
                                    //execute the task

                                    if (isFinish) {
                                        callback.onVideoClosed(true);
                                        sendMsg(activity,"Finish",advertCode);
                                        YLog.d("Yodo1AdvertHelper video  统计  finish ");
                                        YLog.v("Yodo1AdvertHelper, " + advertCode +"   广告播放完成");
                                        Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShowResultChannel,advertCode,AnalyticsConst.ShowResulet_finish);
                                        Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShow,advertCode,AnalyticsConst.ShowResulet_finish);
                                        AppsflyerUtils.AF_Event(activity, AppsflyerUtils.AF_VIDEO_EVENT_NAME, advertCode, AnalyticsConst.ShowResulet_finish);
                                    } else {
                                        callback.onVideoClosed(false);
                                        sendMsg(activity,"Close",advertCode);
                                        YLog.d("Yodo1AdvertHelper video  统计  close ");
                                        YLog.v("Yodo1AdvertHelper, " + advertCode +"   广告关闭  播放未完成");
                                        Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShowResultChannel,advertCode,AnalyticsConst.ShowResulet_close);
                                        Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShow,advertCode,AnalyticsConst.ShowResulet_close);
                                        AppsflyerUtils.AF_Event(activity, AppsflyerUtils.AF_VIDEO_EVENT_NAME, advertCode, AnalyticsConst.ShowResulet_close);
                                    }
                                }

                            }, 500);

                            //重载
                            break;
                        case Yodo1VideoCallback.ADVERT_EVENT_DISPLAY:
                            sendMsg(activity,"DisPlay",advertCode);
                            callback.onVideoShow();
                            YLog.v("Yodo1AdvertHelper, showVideoAd " + advertCode + "   视频广告展示成功");
                            break;


                    }
                }

                @Override
                public void onAdError(int errorCode, String errorMsg, String advertCode) {
                    sendMsg(activity,"ShowFailed",advertCode);
                    Yodo1Analytics.onEvent(AnalyticsConst.VideoAdShowResultChannel,advertCode,AnalyticsConst.ShowResulet_failed);
                    if (index < playlist_video.size() - 1) { //播放列表还没到最后
                        //播放下一顺位的广告
                        index++;
                        String nextCode = playlist_video.get(index);
                        YLog.d("Yodo1AdvertHelper, nextCode : " + nextCode);
                        showVideoAdByChannel(activity, nextCode, this);
                    } else { //全部播放完毕, 也就是全部失败
                        // 统计失败
                        YLog.v("Yodo1AdvertHelper, 视频广告展示失败 ...");
                        if (callback != null) {
                            callback.onVideoShowFailed(AdErrorCode.ADVERT_ERROR_LOADED_FAILED);
                        }
                    }
                }


            });
            return true;
        } else {
            YLog.v("Yodo1AdvertHelper, 播放失败, 播放列表为空");
            callback.onVideoShowFailed(AdErrorCode.ADVERT_ERROR_NO_ADLIST);
        }
        return false;
    }

    /**
     * 展示某家渠道的视频广告
     *
     * @param activity
     * @param advertCode 要展示的渠道
     * @param callback
     */
    private void showVideoAdByChannel(final Activity activity, final String advertCode, final Yodo1VideoCallback callback) {
        YLog.d("Yodo1AdvertHelper, showVideoAdByChannel call ...");
        final AdVideoAdapterBase adapter = (AdVideoAdapterBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Video).get(advertCode);
        if (adapter != null) {
            //统计调用
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    YLog.d("Yodo1AdvertHelper, showVideoAdByChannel showVideoAdvert ： " + advertCode);
                    adapter.showVideoAdvert(activity, new Yodo1VideoCallback() {
                        @Override
                        public void onEvent(int eventCode, String advertCode) {
                            YLog.d("Yodo1AdvertHelper, showVideoAdByChannel callback, event = " + eventCode + ", advertCode = " + advertCode);
                            callback.onEvent(eventCode, advertCode);

                            if (eventCode == Yodo1VideoCallback.ADVERT_EVENT_FINISH){
                                showEnd(AdvertType.Video, advertCode);
                            } else if (eventCode == Yodo1VideoCallback.ADVERT_EVENT_CLOSE ) {
                                //重载
                                reloadVideoAdvert(adapter, activity,advertCode);
                            }
                        }

                        @Override
                        public void onAdError(int errorCode, String errorMsg, String advertCode) {
                            YLog.v("Yodo1AdvertHelper, " + advertCode + "的视频广告展示失败, 错误原因可能为: " + errorMsg + ", errorCode = " + errorCode);
                            callback.onAdError(errorCode, errorMsg,advertCode);
                            //重载
                            reloadVideoAdvert(adapter, activity,advertCode);
                        }

                    });
                }
            });
        } else {
            YLog.v("Yodo1AdvertHelper, error, advertCode为" + advertCode + "的广告没有引入");
            callback.onAdError(AdEventCode.ADVERT_ERROR_UNKNOW, "advertPlugin is null",advertCode);
        }
    }

    /**
     * 预加载回调结果
     *
     * @param adapterBase
     * @param activity
     */
    public void reloadVideoAdvert(final AdVideoAdapterBase adapterBase, final Activity activity,String advertCode) {
        Yodo1Analytics.onEvent(AnalyticsConst.VideoAdReloadChannel,advertCode,"");
        YLog.d("Yodo1AdvertHelper, reloadVideoAdvert ： " + advertCode);

        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                adapterBase.reloadVideoAdvert(activity, new Yodo1VideoReloadCallback() {//预加载结果的回调
                    @Override
                    public void onReload(int eventCode, String advertCode) {
                        YLog.d("Yodo1AdvertHelper, reloadVideoAdvert 开始预加载, callback, eventCode = " + eventCode + ", advertCode = " + advertCode);
                        //此处输出日志   方便查询是否调用预加载接口
                        //没有必要统计视频广告开始预加载事件   个别广告自动预加载，此时此接口统计数据不具有参考价值
                    }

                    @Override
                    public void onResult(int resultCode, String advertCode) {

                        switch (resultCode) {
                            case Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD_FINISH:
                                Yodo1Analytics.onEvent(AnalyticsConst.VideoAdReloadResultChannel,advertCode,AnalyticsConst.ReloadResulet_finish);
                                YLog.d("Yodo1AdvertHelper, reloadVideoAdvert 预加载完毕, callback, resultCode = " + resultCode + ", advertCode = " + advertCode);
                                break;
                            case Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD_FAILED:
                                Yodo1Analytics.onEvent(AnalyticsConst.VideoAdReloadResultChannel,advertCode,AnalyticsConst.ReloadResulet_failed);
                                YLog.d("Yodo1AdvertHelper, reloadVideoAdvert 预加载失败, callback, resultCode = " + resultCode + ", advertCode = " + advertCode);
                                break;
                        }
                    }
                });
            }
        });


    }

    /**
     * 预加载视频广告是否成功
     * <p>
     * 务必在视频广告展示前调用
     *
     * @param activity
     */
    public boolean videoAdIsLoaded(final Activity activity) {
        YLog.d("Yodo1AdvertHelper, videoAdIsLoaded call ...");
        if (!Yodo1NetWorkUtils.isNetworkConnected(activity)) {
            YLog.v("Yodo1AdvertHelper, 当前网络不可用");
            return false;
        }
        //检查后台是否打开开关
        if (!YOnlineConfigUtils.isTrunOnAdvertVideo()) {
            return false;
        }
        if (playlist_video != null && playlist_video.size() > 0) {
            //如果有一个加载成功即为true
            boolean isLoaded = false;
            for (int i = 0; i < playlist_video.size(); i++) {
                String advertCode = playlist_video.get(i);
                YLog.d("Yodo1AdvertHelper, adverts_video advertCode :  " + advertCode);
                final AdVideoAdapterBase adapter = (AdVideoAdapterBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Video).get(advertCode);

                if (adapter != null) {
                    if (adapter.videoAdvertIsLoaded(activity)) {
                        YLog.d("Yodo1AdvertHelper, Video 预加载完成 " + advertCode);
                        YLog.v("Yodo1AdvertHelper, " + advertCode +"   广告已缓存");
                        isLoaded = true;
                    } else //没有完成加载的要重新加载
                    {
                        YLog.v("Yodo1AdvertHelper, " + advertCode +"   尚未缓存完成");
                        YLog.d("Yodo1AdvertHelper, Video 预加载失败 " + advertCode);
                        reloadVideoAdvert(adapter, activity,advertCode);//预加载失败时，预加载
                    }
                }
            }

            return isLoaded;
        } else {
            YLog.v("Yodo1AdvertHelper,广告列表为空");
            return false;
        }
    }


    /**
     * 预加载某家渠道的视频广告
     *
     * @param activity
     * @param advertCode
     */
    private void preloadVideoAd(Activity activity, String advertCode) {
        YLog.d("Yodo1AdvertHelper, preloadVideoAd call ...");
        if (TextUtils.isEmpty(advertCode)) {
            YLog.v("Yodo1AdvertHelper, preload error, 传入的advertCode为空");
            return;
        }
        final AdVideoAdapterBase adapter = (AdVideoAdapterBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Video).get(advertCode);
        if (adapter != null) {
            reloadVideoAdvert(adapter, activity,advertCode);
        } else {
            YLog.v("Yodo1AdvertHelper, error, advertCode为" + advertCode + "的广告没有引入");
        }
    }

    /**
     * 预加载某家渠道的插屏广告
     * @param activity
     * @param advertCode
     */
    private void preloadInterstitialAd(Activity activity, String advertCode){
        YLog.d("Yodo1AdvertHelper, preloadInterstitialAd call ...");
        if (!Yodo1NetWorkUtils.isNetworkConnected(activity)){
            YLog.v("Yodo1AdvertHelper, 当前网络不可用");
            return ;
        }

        if (TextUtils.isEmpty(advertCode)){
            YLog.d("Yodo1AdvertHelper, preload error, 传入的advertCode为空");
            return;
        }
        final AdInterstitialAdapterBase adapter = (AdInterstitialAdapterBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Interstitial).get(advertCode);
        if(adapter != null){
            reloadInterstitialAdvert(adapter,activity,advertCode);
        } else {
            YLog.d("Yodo1AdvertHelper, error, advertCode为" + advertCode + "的广告没有引入");
        }
    }


    /**
     * 显示Banner广告
     * @param activity
     */
    public void SetBannerAlign(final Activity activity,  final int align){
        if(Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Banner) == null || Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Banner).size() == 0){
            YLog.v("Yodo1AdvertHelper, 播放中断， 请检查本地引用");
            return;
        }

        YLog.d("Yodo1AdvertHelper, SetBannerAlign call ...");
        for (int i = 0 ; i < playlist_banner.size() ; i ++ ){
            String  advertCode = playlist_banner.get(i);//根据播放列表循环拿到advertCode
            final AdBannerAdapterBase adapter = (AdBannerAdapterBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Banner).get(advertCode);
            if(adapter != null){
                //统计调用
                activity.runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        adapter.setBannerAlign(activity,align);
                    }
                });
            } else {
                YLog.d("Yodo1AdvertHelper, error, advertCode为" + advertCode + "的广告没有引入");
            }
        }

    }



    /**
     * 显示Banner广告
     * @param activity
     */

    public void ShowBanner(final Activity activity, final BannerCallback callback){
        YLog.d("Yodo1AdvertHelper, showBannerAd call ...");
        HideBanner(activity);//展示广告之前首先隐藏广告
        Yodo1Analytics.onEvent(AnalyticsConst.BannerAdShow,"","");
        isDismissBanner = false;
        //检查库引用列表
        if(Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Banner) == null || Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Banner).size() == 0){
            YLog.v("Yodo1AdvertHelper, 播放中断， 请检查本地引用");
            callback.onBannerShowFailed(AdErrorCode.ADVERT_ERROR_NO_SUPPORT);
            return ;
        }

        //获取在线参数开关 检查后台是否打开开关
        if (!YOnlineConfigUtils.isTrunOnAdvertBanner()) {
            YLog.d("Yodo1AdvertHelper, 播放中断， 在线参数开关关闭");
            callback.onBannerShowFailed(AdErrorCode.ADVERT_ERROR_SWITCHCLOSE);
            return ;
        }

        //获取banner时间间隔
        final long interval = YOnlineConfigUtils.getSwitchingCycle();
        //统计调用

        //展示banner广告
        if (playlist_banner != null && playlist_banner.size() > 0) {
            YLog.d("Yodo1AdvertHelper, playlist_banner = " + playlist_banner.toString());
            final String  advertCode = playlist_banner.get(0);//根据播放列表拿到第一家advertCode

            showBannerAdByChannel(activity, advertCode,interval, new Yodo1BannerCallback() {
                private int index = 0; //当前播放次序
                private long time = 0; //时间标记
                private boolean disPlaySuccessful = false;//标识是否播放成功过   如果曾经播放成功过  最后一家广告播放失败后重头开始播，如果没有播放成功过，播放至最后一家返回播放失败
                @Override
                public void onEvent(int eventCode, String advertCode) {
                    YLog.d("Yodo1AdvertHelper, ShowBanner , eventCode = " + eventCode + ", advertCode = " + advertCode);

                    switch (eventCode) {
                        case Yodo1BannerCallback.ADVERT_EVENT_CLICK:
                            Yodo1Analytics.onEvent(AnalyticsConst.BannerAdClickChannel,advertCode,"");
                            callback.onBannerClicked();
                            sendMsg(activity,"Click",advertCode);
                            break;
                        case Yodo1BannerCallback.ADVERT_EVENT_CLOSE:
                            callback.onBannerClosed();
                            HideBanner(activity);
                            sendMsg(activity,"Close",advertCode);
                            break;
                        case Yodo1BannerCallback.ADVERT_EVENT_DISPLAYSUCCESS://该字段用来给外部抛出回调
                            Yodo1Analytics.onEvent(AnalyticsConst.BannerAdShowChannel,advertCode,AnalyticsConst.ShowResulet_success);
                            Yodo1Analytics.onEvent(AnalyticsConst.BannerAdShow,advertCode,AnalyticsConst.ShowResulet_success);
                            time = System.currentTimeMillis();
                            YLog.d("Yodo1AdvertHelper，Time1 == " + time + "   " + advertCode);
                            callback.onBannerShow();
                            YLog.v("Yodo1AdvertHelper, showBannerAd " + advertCode + "   Banner广告展示成功");

                            sendMsg(activity,"DisPlay",advertCode);
                            break;
                        case Yodo1BannerCallback.ADVERT_EVENT_DISPLAY://该字段用来表示  banner展示成功之后的逻辑
                            if (isDismissBanner){
                                YLog.d("Yodo1AdvertHelper,Banner 广告隐藏或者关闭  中止循环");
                                return;
                            }
                            disPlaySuccessful = true;
                            YLog.d("Yodo1AdvertHelper，Time2 == " + System.currentTimeMillis()+ "   " + advertCode);
                            YLog.d("Yodo1AdvertHelper，Time3 == " + (System.currentTimeMillis() - time)+ "   " + advertCode);


                            YLog.d("Yodo1AdvertHelper，正常播放  advertCode == " + advertCode);
                            String nextCode = "";
                            if (index < playlist_banner.size() - 1) { //播放列表还没到最后
                                //播放下一顺位的广告
                                index++;
                                nextCode = playlist_banner.get(index);
                                YLog.d("Yodo1AdvertHelper,正常播放,播放下一顺位的广告  nextCode == " + nextCode);

                            } else { //全部播放完毕, 重新开始播
                                index = 0;
                                nextCode = playlist_banner.get(index);
                                YLog.d("Yodo1AdvertHelper,正常播放, 全部播放完毕, 重新开始播 nextCode == " + nextCode);

                            }

                            HideBanner(activity);
                            showBannerAdByChannel(activity, nextCode,interval, this);
                            break;

                    }
                }

                @Override
                public void onAdError(int errorCode, String errorMsg, String advertCode) {
                    sendMsg(activity,"ShowFailed",advertCode);
                    Yodo1Analytics.onEvent(AnalyticsConst.BannerAdShowChannel,advertCode,AnalyticsConst.ShowResulet_failed);
                    if (index < playlist_banner.size() - 1) { //播放列表还没到最后
                        //播放下一顺位的广告
                        index++;
                        String nextCode = playlist_banner.get(index);

                        YLog.d("Yodo1AdvertHelper, 播放异常  nextCode == " + nextCode);
                        showBannerAdByChannel(activity, nextCode,interval, this);
                    } else { //全部播放完毕, 也就是全部失败
                        // 统计失败
                        YLog.v("Yodo1AdvertHelper, 播放异常  banner展示失败 ...");
                        if (disPlaySuccessful){
                            disPlaySuccessful = false;
                            index = 0;
                            String nextCode = playlist_banner.get(index);
                            HideBanner(activity);
                            YLog.d("Yodo1AdvertHelper, 播放异常  重头开始播 " );
                            showBannerAdByChannel(activity, nextCode,interval, this);
                        }else {
                            callback.onBannerShowFailed(AdErrorCode.ADVERT_ERROR_LOADED_FAILED);
                        }


                    }
                }

            });

        }else {
            callback.onBannerShowFailed(AdErrorCode.ADVERT_ERROR_NO_ADLIST);
        }


    }


    /**
     * 展示某家渠道的banner广告
     * @param activity
     * @param advertCode 要展示的渠道
     * @param callback
     */
    private void showBannerAdByChannel(final Activity activity, final String advertCode,final long interval, final Yodo1BannerCallback callback){
        YLog.d("Yodo1AdvertHelper, showBannerAdByChannel call ..." + advertCode);
        if (TextUtils.isEmpty(advertCode)){
            YLog.v("Yodo1AdvertHelper, show error, 传入的advertCode为空");
            callback.onAdError(Yodo1BannerCallback.ADVERT_ERROR_COMMON, "advertCode为空","");
            return;
        }
        Yodo1Analytics.onEvent(AnalyticsConst.BannerAdShowChannel,advertCode,"");
        if (!bannerIsIsLoaded(advertCode)){
            YLog.v("Yodo1AdvertHelper, " + advertCode + "的Banner广告展示失败, 错误原因为预加载失败 ");
            callback.onAdError(Yodo1BannerCallback.ADVERT_ERROR_COMMON, "预加载失败",advertCode);
            return;
        }
        final AdBannerAdapterBase adapter = (AdBannerAdapterBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Banner).get(advertCode);
        if(adapter != null){
            //统计调用
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    adapter.showBanner(activity, new Yodo1BannerCallback() {
                        @Override
                        public void onEvent(int eventCode,final String advertCode) {
                            YLog.d("Yodo1AdvertHelper, showBannerAdByChannel callback, eventCode = " + eventCode + ", advertCode = " + advertCode);
                            switch (eventCode) {
                                case Yodo1BannerCallback.ADVERT_EVENT_CLICK:
                                    callback.onEvent(Yodo1BannerCallback.ADVERT_EVENT_CLICK, advertCode);
                                    break;

                                case Yodo1BannerCallback.ADVERT_EVENT_CLOSE:
                                    callback.onEvent(Yodo1BannerCallback.ADVERT_EVENT_CLOSE, advertCode);
                                    break;
                                case Yodo1BannerCallback.ADVERT_EVENT_DISPLAY:
                                    showEnd(AdvertType.Banner, advertCode);
                                    callback.onEvent(Yodo1BannerCallback.ADVERT_EVENT_DISPLAYSUCCESS, advertCode);

                                    YLog.d("Yodo1AdvertHelper, showBannerAdByChannel 切换时间 = " + interval);
                                    new Handler().postDelayed(new Runnable() {
                                        @Override
                                        public void run() {
                                            callback.onEvent(Yodo1BannerCallback.ADVERT_EVENT_DISPLAY, advertCode);
                                        }
                                    },interval);

                                    break;


                            }
                        }

                        @Override
                        public void onAdError(int errorCode, String errorMsg, String advertCode) {
                            YLog.v("Yodo1AdvertHelper, " + advertCode + "的Banner广告展示失败, 错误原因可能为: " + errorMsg + ", errorCode = " + errorCode);
                            callback.onAdError(Yodo1BannerCallback.ADVERT_ERROR_COMMON, errorMsg,advertCode);
                        }
                    });
                }
            });
        } else {
            YLog.v("Yodo1AdvertHelper, error, advertCode为" + advertCode + "的广告没有引入");
            callback.onAdError(Yodo1BannerCallback.ADVERT_ERROR_COMMON, "广告没有引入",advertCode);
        }
    }


    /**
     * 预加载Banner广告是否成功
     *
     * @param advertCode
     */
    public boolean bannerIsIsLoaded(String advertCode) {

        final AdBannerAdapterBase adapter = (AdBannerAdapterBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Banner).get(advertCode);
        if (adapter != null) {
            if (adapter.hasLoadBanner()) {
                return true;
            }
        }

        return false;
    }



    /**
     * 此处用来关闭延时30s发送播放成功的回调  isDismissBanner为true时ADVERT_EVENT_DISPLAY事件拦截不做处理
     */
    private boolean isDismissBanner = false;
    public void RemoveBanner1(Activity activity){
        isDismissBanner = true;
        RemoveBanner(activity);
    }

    public void HideBanner1(Activity activity){
        isDismissBanner = true;
        HideBanner(activity);
    }
    /**
     * 关闭Banner广告
     * @param activity
     */

    public void RemoveBanner(final Activity activity ) {
        YLog.d("Yodo1AdvertHelper, removeBannerAd call ...");
        //检查库引用列表
        if (Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Banner) == null || Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Banner).size() == 0) {
            YLog.v("Yodo1AdvertHelper, 播放异常, banner广告插件引入列表为空, 请检查项目引用");
            return ;
        }

        for (int i = 0 ; i < playlist_banner.size() ; i ++ ) {
            String advertCode = playlist_banner.get(i);//根据播放列表循环拿到advertCode
            final AdBannerAdapterBase adapter = (AdBannerAdapterBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Banner).get(advertCode);
            if (adapter != null) {
                //统计调用

                adapter.removeBanner(activity);
            }
        }

    }

    /**
     * 隐藏Banner广告
     * @param activity
     */

    public void HideBanner(final Activity activity ) {
        YLog.d("Yodo1AdvertHelper, HideBanner call ...");
        //检查库引用列表
        if (Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Banner) == null || Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Banner).size() == 0) {
            YLog.v("Yodo1AdvertHelper, 播放异常, banner广告插件引入列表为空, 请检查项目引用");
            return ;
        }

        for (int i = 0 ; i < playlist_banner.size() ; i ++ ) {
            String advertCode = playlist_banner.get(i);//根据播放列表循环拿到advertCode

            final AdBannerAdapterBase adapter = (AdBannerAdapterBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Banner).get(advertCode);
            if (adapter != null) {
                //统计调用
                adapter.hideBanner(activity);
            }
        }
    }


    /**
     * 扎实Native 广告
     * @param activity
     * @param px
     * @param py
     * @param pw
     * @param ph
     * @param callback
     * @return
     */
    public boolean showNativeAd(final Activity activity, final float px, final float py, final float pw, final float ph, final NativeCallback callback) {
        YLog.d("Yodo1AdvertHelper, showNative call ...");
        Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShow,"","");
        if (!Yodo1NetWorkUtils.isNetworkConnected(activity)) {
            YLog.v("Yodo1AdvertHelper, 当前网络不可用");
            Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShow,"",AnalyticsConst.ShowResulet_failed);
            callback.onNativeShowFailed(AdErrorCode.ADVERT_ERROR_NETWORK);
            return false;
        }
        //检查库引用列表
        if (Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Native) == null || Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Native).size() == 0) {
            YLog.v("Yodo1AdvertHelper, 播放中断， 请检查本地引用");
            Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShow,"",AnalyticsConst.ShowResulet_failed);
            callback.onNativeShowFailed(AdErrorCode.ADVERT_ERROR_NO_SUPPORT);
            return false;
        }
        //检查后台是否打开开关
        if (!YOnlineConfigUtils.isTrunOnAdvertNative()) {
            YLog.v("Yodo1AdvertHelper, 播放中断， 在线参数开关关闭");
            Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShow,"",AnalyticsConst.ShowResulet_failed);
            callback.onNativeShowFailed(AdErrorCode.ADVERT_ERROR_SWITCHCLOSE);
            return false;
        }

        long interval = YOnlineConfigUtils.getNativeAdvertInterstitial();
        if (System.currentTimeMillis() - showtimes_native < interval) {
            YLog.v("Yodo1AdvertHelper, 播放中断, 未达到指定的时间间隔");
            Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShow,"",AnalyticsConst.ShowResulet_failed);
            callback.onNativeShowFailed(AdErrorCode.ADVERT_ERROR_MISS_INTERVAL);
            return false;
        }
        //统计调用
        if (playlist_native != null && playlist_native.size() > 0) {
            String firstCode = playlist_native.get(0);
            Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShow,firstCode,"");
            YLog.i("Yodo1AdvertHelper, playlist_native  " + playlist_native.toString() + "   " + firstCode);

            showNativeByChannel(activity, firstCode, px, py, pw, ph, new Yodo1NativeCallback() {
                private int index = 0; //当前播放次序
                private boolean isFinish = false;

                @Override
                public void onEvent(int eventCode, String advertCode) {

                    YLog.d("Yodo1AdvertHelper, showNative callback, event = " + eventCode + ", advertCode = " + advertCode);
                    switch (eventCode) {
                        case Yodo1NativeCallback.ADVERT_EVENT_CLICK:
                            sendMsg(activity,"Click",advertCode);
                            callback.onNativeClicked();
                            Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShowResultChannel,advertCode,AnalyticsConst.ShowResulet_click);
                            break;
                        case Yodo1NativeCallback.ADVERT_EVENT_CLOSE:
                            sendMsg(activity,"Close",advertCode);
                            callback.onNativeClosed();
                            Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShowResultChannel,advertCode,AnalyticsConst.ShowResulet_close);
                            Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShow,advertCode,AnalyticsConst.ShowResulet_close);
//                            AppsflyerUtils.AF_Event(activity, AppsflyerUtils.AF_INTERSTITIAL_EVENT_NAME, advertCode, AnalyticsConst.ShowResulet_close);
                            break;
                        case Yodo1NativeCallback.ADVERT_EVENT_DISPLAY:
                            //保存当前时间用于进行显示间隔的判断
                            showtimes_native = System.currentTimeMillis();
                            callback.onNativeShow();
                            YLog.v("Yodo1AdvertHelper, showNativeAds show " + advertCode + "   原生广告展示成功");
                            sendMsg(activity,"DisPlay",advertCode);
                            break;
                        case Yodo1NativeCallback.ADVERT_EVENT_LOADED:
//                            callback.interstitialDidLoad();
                            break;
                    }

                }

                @Override
                public void onAdError(int errorCode, String errorMsg, String advertCode) {
                    sendMsg(activity,"ShowFailed",advertCode);
                    Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShowResultChannel,advertCode,AnalyticsConst.ShowResulet_failed);
                    if (index < playlist_native.size() - 1) { //播放列表还没到最后
                        //播放下一顺位的广告
                        index++;
                        String nextCode = playlist_native.get(index);

                        YLog.d("Yodo1AdvertHelper, nextCode == " + nextCode);
                        Yodo1Analytics.onEvent(AnalyticsConst.NativeAdShowChannel,nextCode,"");
                        showNativeByChannel(activity, nextCode, px, py, pw, ph, this);

                    } else { //全部播放完毕, 也就是全部失败
                        // 统计失败
                        YLog.d("Yodo1AdvertHelper, 原生广告展示失败 ...");
                        if (callback != null) {
                            callback.onNativeShowFailed(AdErrorCode.ADVERT_ERROR_LOADED_FAILED);
                        }
                    }
                }


            });
            return true;
        } else {
            YLog.d("Yodo1AdvertHelper, 播放失败, 原生播放列表为空");
            callback.onNativeShowFailed(AdErrorCode.ADVERT_ERROR_NO_ADLIST);
        }
        return false;
    }

    private void showNativeByChannel(final Activity activity, String advertCode, final float px, final float py, final float pw, final float ph, final Yodo1NativeCallback callback){
        if (TextUtils.isEmpty(advertCode)){
            YLog.v("Yodo1AdvertHelper, show error, 传入的advertCode为空");
            callback.onAdError(Yodo1NativeCallback.ADVERT_ERROR_COMMON, "advertCode为空","");
            return;
        }
        final AdNativeAdapterBase adapter = (AdNativeAdapterBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Native).get(advertCode);
        if(adapter != null){
            //统计调用
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {

                    adapter.showNativeAdvert(activity, px, py,pw, ph, new Yodo1NativeCallback() {
                        @Override
                        public void onEvent(int eventCode, String advertCode) {
                            YLog.i("Yodo1AdvertHelper, showNativeAd callback, event = " + eventCode );
                            //..统计成功，点击
                            switch (eventCode) {
                                case Yodo1NativeCallback.ADVERT_EVENT_CLICK:
                                    callback.onEvent(Yodo1NativeCallback.ADVERT_EVENT_CLICK, advertCode);
                                    break;
                                case Yodo1NativeCallback.ADVERT_EVENT_CLOSE:
                                    callback.onEvent(Yodo1NativeCallback.ADVERT_EVENT_CLOSE, advertCode);
                                    showEnd(AdvertType.Native, advertCode);
                                    reloadNativeAdvert(adapter,activity,advertCode);
                                    //重载
                                    break;
                                case Yodo1NativeCallback.ADVERT_EVENT_DISPLAY:
                                    callback.onEvent(Yodo1NativeCallback.ADVERT_EVENT_DISPLAY, advertCode);
                                    break;
                            }
                        }

                        @Override
                        public void onAdError(int errorCode, String errorMsg, String advertCode) {
                            YLog.w("Yodo1AdvertHelper, " + advertCode + "的原生广告展示失败, 错误原因可能为: " + errorMsg + ", errorCode = " + errorCode);
                            callback.onAdError(Yodo1NativeCallback.ADVERT_ERROR_LOADED_FAILED, errorMsg, advertCode);
                            reloadNativeAdvert(adapter,activity,advertCode);
                        }

                    });
                }
            });
        } else {
            YLog.e("Yodo1AdvertHelper, error, advertCode为" + advertCode + "的广告没有引入");
            callback.onAdError(Yodo1NativeCallback.ADVERT_ERROR_LOADED_FAILED, advertCode + "的广告没有引入", advertCode);
        }
    }

    /**
     * 预加载广告是否成功
     *
     * @param activity
     */
    public boolean nativeAdIsLoaded(final Activity activity) {
        if (!YOnlineConfigUtils.isTrunOnAdvertNative()) {
            return false;
        }
        if (playlist_native != null && playlist_native.size() > 0) {
            //如果有一个加载成功即为true
            boolean isLoaded = false;
            for (int i = 0; i < playlist_native.size(); i++) {
                String advertCode = playlist_native.get(i);
                YLog.d("Yodo1AdvertHelper, adverts_native advertCode  ： " + advertCode);
                final AdNativeAdapterBase adapter = (AdNativeAdapterBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Native).get(advertCode);

                if (adapter != null) {
                    if (adapter.nativeAdvertIsLoaded(activity)) {
                        YLog.d("Yodo1AdvertHelper,native 预加载完成 " + advertCode);

                        isLoaded = true;
                    } else //没有完成加载的要重新加载
                    {
                        YLog.d("Yodo1AdvertHelper,native 预加载失败 " + advertCode);
                        reloadNativeAdvert(adapter,activity,advertCode);
                    }
                }
            }

            return isLoaded;
        } else {
            YLog.v("Yodo1AdvertHelper,原生广告列表为空");
            return false;
        }
    }

    public void reloadNativeAdvert(final AdNativeAdapterBase adapterBase, final Activity activity,String advertCode) {
        Yodo1Analytics.onEvent(AnalyticsConst.NativeAdReloadResultChannel,advertCode,"");
        YLog.d("Yodo1AdvertHelper, reloadNativeAdvert ： " + advertCode);
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                adapterBase.reloadNativeAdvert(activity, new Yodo1NativeReloadCallback() {
                    @Override
                    public void onResult(int resultCode, String advertCode) {
                        switch (resultCode) {
                            case Yodo1NativeReloadCallback.ADVERT_NATIVE_RELOAD_FINISH:
                                Yodo1Analytics.onEvent(AnalyticsConst.NativeAdReloadResultChannel,advertCode,AnalyticsConst.ReloadResulet_finish);
                                YLog.d("Yodo1AdvertHelper, reloadNativeAdvert 预加载完毕, callback, resultCode = " + resultCode + ", advertCode = " + advertCode);
                                break;
                            case Yodo1NativeReloadCallback.ADVERT_NATIVE_RELOAD_FAILED:
                                Yodo1Analytics.onEvent(AnalyticsConst.NativeAdReloadResultChannel,advertCode,AnalyticsConst.ReloadResulet_failed);
                                YLog.i("Yodo1AdvertHelper, reloadNativeAdvert 预加载失败, callback, resultCo " + resultCode + ", advertCode = " + advertCode);
                                break;
                        }
                    }
                });
            }
        });
    }

    /**
     *
     * 移除原生广告
     * @param activity
     */
    public void removeNativeAd(final Activity activity ) {
        //检查库引用列表
        if (Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Native) == null || Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Native).size() == 0) {
            YLog.v("Yodo1AdvertHelper, 播放异常, Native广告插件引入列表为空, 请检查项目引用");
            return ;
        }

        for (int i = 0 ; i < playlist_native.size() ; i ++ ) {
            String advertCode = playlist_native.get(i);//根据播放列表循环拿到advertCode
            final AdNativeAdapterBase adapter = (AdNativeAdapterBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Native).get(advertCode);
            if (adapter != null) {
                adapter.removeNativeAdvert(activity);
            }
        }
    }



    /**
     * 初始化闪屏广告
     */
    private void initSplashAds(final Activity activity){
        Yodo1OnlineConfig.getInstance().init(activity, "");
        if (Yodo1OnlineConfig.getInstance().hasData()) {
            Yodo1AdvertAdapterFactory.getInstance().initSplashAdvertAdapters(activity);
        }

        int save_time = Yodo1SharedPreferences.getInt(activity,"Platform_SplashAdShowFirstTimes") + 1;//当前游戏启动次数
        String showFirstTime = Yodo1OnlineConfig.getInstance().getConfigParam("Platform_SplashAdShowFirstTimes","1");
        int time = Integer.valueOf(showFirstTime);
        Yodo1SharedPreferences.put(activity,"Platform_SplashAdShowFirstTimes",save_time);//将当前启动次数保存到本地
        if (time > save_time){
            YLog.v("Yodo1AdvertHelper, 第" + time + "次启动开始展示开屏广告");
            return;
        }

        List<AdsConfigEntity> adList =Yodo1OnlineConfigAgent.getAdsControl(Yodo1OnlineConfigAgent.AdvertType.Platform_SplashAd);//获取后台闪屏广告播放列表
        if (adList == null || adList.size() ==0){
            YLog.w("Yodo1AdvertHelper, 播放中断， 检查到Splash广告播放列表为空");
            return ;
        }

        List<String> priorityList = new ArrayList<>();//优先播放的广告列表
        List<String> behindList = new ArrayList<>();//播放级别较低的广告列表
        showAllTimes_splash = Yodo1SharedPreferences.getInt(activity,"Platform_SplashAdShowAllTimes");//开屏广告展示总次数
        int splash_total = 0;//需要计算的开屏广告展示总数（用来计算开屏广告展示比例）
        for (int i = 0; i < adList.size(); i++) {
            int showTimes = Integer.valueOf(adList.get(i).getRatio());
            splash_total = splash_total + showTimes;
        }
        //闪屏广告播放计算
        for (int i = 0; i < adList.size(); i++) {
            if (showAllTimes_splash == 0){//开屏从未展示过 直接读取到的数据添加进广告列表
                priorityList.add(adList.get(i).getAdvertCode());
            } else {
                String adCode = adList.get(i).getAdvertCode();
                int showTimes_local = Yodo1SharedPreferences.getInt(activity,adList.get(i).getAdvertCode().toLowerCase());//某一家广告的展示次数
                float ratio_local = (float)showTimes_local/showAllTimes_splash;//获取当前这个广告的播放比例

                int showTimes_online = Integer.valueOf(adList.get(i).getRatio());
                float ratio_online = (float)showTimes_online/splash_total;//获取理论上广告播放比例

                if (ratio_local < ratio_online){
                    priorityList.add(adCode);
                }else {
                    behindList.add(adCode);
                }
            }
        }
        playlist_splash.addAll(priorityList);
        playlist_splash.addAll(behindList);

        YLog.v("Yodo1AdvertHelper,Splash广告播放列表为: " + playlist_splash.toString());
    }

    /**
     * 显示splash广告
     * @param activity
     * @return 是否允许显示splash广告
     */

    public boolean showSplashAd(final Activity activity, final SplashCallback callback){
        initSplashAds(activity);

        YLog.d("Yodo1AdvertHelper, showSplashAd call ...");
        //检查后台是否打开开关
        if (!YOnlineConfigUtils.isTrunOnAdvertSplash()){
            YLog.w("Yodo1AdvertHelper, 播放中断， 检查到在线参数开关关闭或者没有获取到在线参数");
            callback.onSplashShowFailed(AdErrorCode.ADVERT_ERROR_NO_SUPPORT);
            return false;
        }

        if (playlist_splash != null && playlist_splash.size() > 0 ){
            String advertCode = playlist_splash.get(0);
            YLog.d("Yodo1AdvertHelper, showSplashAdByChannel : " + advertCode);
            showSplashAdByChannel(activity, advertCode, new Yodo1SplashCallback() {
                private int index = 0; //当前播放次序
                @Override
                public void onEvent(int eventCode, String advertCode) {
                    switch (eventCode) {
                        case Yodo1SplashCallback.ADVERT_EVENT_CLICK:
                            callback.onSplashClicked();
                            break;
                        case Yodo1InterstitialCallback.ADVERT_EVENT_CLOSE:
                            callback.onSplashClosed();
                            break;
                        case Yodo1InterstitialCallback.ADVERT_EVENT_DISPLAY:
                            //保存当前时间用于进行显示间隔的判断
                            callback.onSplashShow();
                            YLog.d("Yodo1AdvertHelper, showSplashAd " + advertCode + "   插屏广告展示成功");

                            int showTimes_local = Yodo1SharedPreferences.getInt(activity,advertCode.toLowerCase());//某一家广告的展示次数
                            Yodo1SharedPreferences.put(activity,advertCode.toLowerCase(),showTimes_local+1);//保存当前广告的展示次数
                            Yodo1SharedPreferences.put(activity,"Platform_SplashAdShowAllTimes",showAllTimes_splash+1);//保存当前展示次数
                            break;

                    }
                }

                @Override
                public void onAdError(int errorCode, String errorMsg, String advertCode) {
                    if (index < playlist_splash.size() - 1) { //播放列表还没到最后
                        //播放下一顺位的广告
                        index++;
                        String nextCode = playlist_splash.get(index);

                        YLog.d("Yodo1AdvertHelper, 播放异常  nextCode == " + nextCode);
                        showSplashAdByChannel(activity, nextCode, this);
                    } else { //全部播放完毕, 也就是全部失败
                        // 统计失败
                        YLog.v("Yodo1AdvertHelper, 播放异常  Splash展示失败 ...");
                        callback.onSplashShowFailed(AdErrorCode.ADVERT_ERROR_LOADED_FAILED);
                    }
                }
            });
        } else {
            callback.onSplashShowFailed(AdErrorCode.ADVERT_ERROR_NO_SUPPORT);
        }

        return false;
    }

    /**
     * 展示某家渠道的开屏广告
     *
     * @param activity
     * @param advertCode 要展示的渠道
     * @param callback
     */
    private void showSplashAdByChannel(final Activity activity, final String advertCode, final Yodo1SplashCallback callback) {
        YLog.d("Yodo1AdvertHelper, showInterstitialAdByChannel call ...");
        //统计调用
        final AdSplashAdapterBase adapter = (AdSplashAdapterBase) Yodo1AdvertAdapterFactory.getInstance().getAdapters(AdvertType.Splash).get(advertCode);
        if(adapter != null){

            //统计调用
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    adapter.showSplashAdvert(activity, new Yodo1SplashCallback() {
                        @Override
                        public void onEvent(int eventCode, String advertCode) {
                            YLog.d("Yodo1AdvertHelper, showSplashAd callback, event = " + eventCode + ", advertCode = " + advertCode);

                            callback.onEvent(eventCode, advertCode);
                        }

                        @Override
                        public void onAdError(int errorCode, String errorMsg, String advertCode) {
                            YLog.v("Yodo1AdvertHelper, " + advertCode + "的闪屏广告展示失败, 错误原因可能为: " + errorMsg + ", errorCode = " + errorCode);
                            callback.onAdError(errorCode, errorMsg,advertCode);
                        }
                    });
                }
            });

        }else {
            YLog.e("Yodo1AdvertHelper, error, advertCode为" + advertCode + "的广告没有引入");
            callback.onAdError(AdEventCode.ADVERT_ERROR_UNKNOW, "advertPlugin is null",advertCode);
        }

    }

    /**
     * 播放完毕
     *
     * @param advertType 广告类型(插屏、视频等)
     * @param adCode
     */
    private void showEnd(AdvertType advertType, String adCode) {
        YLog.d("Yodo1AdvertHelper, showEnd call ...");
        String advertCode = adCode.toLowerCase();
        if (advertType == AdvertType.Interstitial) {
            playtimes_interstitial++;
            YLog.d("Yodo1AdvertHelper, Interstitial总共播放了" + playtimes_interstitial + "次");
            for (int i = 0; i < adverts_intersital.size(); i++) {
                if (!TextUtils.isEmpty(adverts_intersital.get(i).advertCode)) {
                    if (adverts_intersital.get(i).advertCode.equals(advertCode)) {
                        adverts_intersital.get(i).played++;
                        YLog.d("Yodo1AdvertHelper, 当前" + advertCode + "播放了" + adverts_intersital.get(i).played + "次");
                    }
                }
            }
            sortAdvert(adverts_intersital, playlist_intersital,playtimes_interstitial); //重排序
        } else if (advertType == AdvertType.Video) {
            playtimes_video++;
            YLog.d("Yodo1AdvertHelper, Video总共播放了" + playtimes_video + "次");
            for (int i = 0; i < adverts_video.size(); i++) {
                if (!TextUtils.isEmpty(adverts_video.get(i).advertCode)) {
                    if (adverts_video.get(i).advertCode.equals(advertCode)) {
                        adverts_video.get(i).played++;
                        YLog.d("Yodo1AdvertHelper, 当前" + advertCode + "播放了" + adverts_video.get(i).played + "次");
                    }
                }
            }
            sortAdvert(adverts_video, playlist_video,playtimes_video); //重排序
        } else if (advertType == AdvertType.Banner) {
            playtimes_banner++;
            YLog.d("Yodo1AdvertHelper, Banner总共播放了" + playtimes_banner + "次");
            for (int i = 0; i < adverts_banner.size(); i++) {
                if (adverts_banner.get(i).advertCode.equals(advertCode)) {
                    adverts_banner.get(i).played++;
                    YLog.d("Yodo1AdvertHelper, 当前" + advertCode + "播放了" + adverts_banner.get(i).played + "次");
                }
            }
            sortAdvert(adverts_banner, playlist_banner,playtimes_banner); //重排序
        } else if (advertType == AdvertType.Native) {
            playtimes_native++;
            YLog.d("Yodo1AdvertHelper, Native总共播放了" + playtimes_native + "次");
            for (int i = 0; i < adverts_native.size(); i++) {
                if (adverts_native.get(i).advertCode.equals(advertCode)) {
                    adverts_native.get(i).played++;
                    YLog.d("Yodo1AdvertHelper, 当前" + advertCode + "播放了" + adverts_native.get(i).played + "次");
                }
            }
            sortAdvert(adverts_native, playlist_native,playtimes_native); //重排序
        }
    }

    /**
     * 根据权重与播放次数排序
     *
     * @param advertsLst 存放广告数据实体（权重和百分比等）的集合
     * @param playList   播放列表
     */
    private void sortAdvert(ArrayList<AdvertBean> advertsLst, ArrayList<String> playList,int playtimes) {
        YLog.d("Yodo1AdvertHelper, sortAdvert call ...");
        //清空播放列表
        if (playList != null) {
            playList.clear();
        } else {
            playList = new ArrayList<String>();
        }
        List<String> overAdvert = new ArrayList<String>(); //存储已经超过播放百分比或者的广告渠道
        List<String> overMaxAdvert = new ArrayList<String>(); //存储已经超过最大播放次数的广告渠道
        List<AdvertBean> fixAdvert = new ArrayList<AdvertBean>(); //存储播放比例不为-1的广告渠道  放置在广告列表最后 按照比例计算播放列表 （-1表示优先展示的广告渠道）

        for (int i = 0; i < advertsLst.size(); i++) {
            AdvertBean bean = advertsLst.get(i);
            YLog.d("Yodo1AdvertHelper, " + bean.advertCode + "   播放次数为 : " + bean.played);
            YLog.d("Yodo1AdvertHelper, " + bean.advertCode + "   最大播放次数为 : " + bean.maxPlayeTimes);

           if (bean.maxPlayeTimes != -1 && bean.played >= bean.maxPlayeTimes){//maxPlayeTimes = -1 表示展示次数无穷大
               overMaxAdvert.add(bean.advertCode); //筛选出播放次数超过最大播放次数的广告  放在队尾  不参与计算
               YLog.d("Yodo1AdvertHelper, " + bean.advertCode + " 已播放至最大播放次数  播放次数为 : " + bean.maxPlayeTimes);
           } else {
               if (bean.percentage == 0){ //区分广告播放比例为0的放在队首，按照在线参数获取到的顺序排列。播放顺序固定   不为-1的放在队尾，按照播放比例计算
                   playList.add(bean.advertCode);
                   YLog.d("Yodo1AdvertHelper, " + bean.advertCode + " 放入对首 ");
               } else {
                   YLog.d("Yodo1AdvertHelper, " + bean.advertCode + " 需进入排序队列 ");
                   fixAdvert.add(bean);
               }
           }
        }

        //广告播放比例计算
        for (int i = 0; i < fixAdvert.size(); i++) {
            AdvertBean bean = fixAdvert.get(i);
            float percentage_played = (float) bean.played / playtimes; //算出这个渠道的已播放量百分比
            YLog.d("Yodo1AdvertHelper, " + bean.advertCode + " percentage_played : " + percentage_played);
            YLog.d("Yodo1AdvertHelper, " + bean.advertCode + " bean.percentage : " + bean.percentage);
            if (percentage_played < bean.percentage) { //说明播放量还没有超标
                playList.add(bean.advertCode);
            } else { //播放量超标，先加入到超标集合中等待最后合并
                overAdvert.add(bean.advertCode);
            }
        }


        //将播放比例超标集合添加到播放列表队尾
        if (overAdvert.size() > 0) {
            playList.addAll(overAdvert);
        }
        //将播放播放次数超过最大播放次数的集合添加到播放列表队尾
        if (overMaxAdvert.size() > 0) {
//            playList.addAll(overMaxAdvert);
            YLog.d("Yodo1AdvertHelper,  超过最大播放次数的广告列表 : " + overMaxAdvert.toString());
        }

        YLog.d("Yodo1AdvertHelper,  排序后 playList : " + playList.toString());
    }



    /**
     * 初始化广告属性列表与播放列表，初始按权重排序    插屏
     *
     * @param advertType 广告类型
     */
    private void initAdvertList(Yodo1OnlineConfigAgent.AdvertType advertType) {
        YLog.d("Yodo1AdvertHelper, initAdvertList call ...");
        if (advertType == Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd && !YOnlineConfigUtils.isTrunOnAdvertInterstitial()){
            YLog.d("Yodo1AdvertHelper 插屏广告开关关闭  不再初始化");
            return;
        }

        if (advertType == Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd && !YOnlineConfigUtils.isTrunOnAdvertVideo()){
            YLog.d("Yodo1AdvertHelper 视屏广告开关关闭  不再初始化");
            return;
        }

        if (advertType == Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd && !YOnlineConfigUtils.isTrunOnAdvertBanner()){
            YLog.d("Yodo1AdvertHelper Banner开关关闭  不再初始化");
            return;
        }

        if (advertType == Yodo1OnlineConfigAgent.AdvertType.Platform_NativeAd && !YOnlineConfigUtils.isTrunOnAdvertNative()){
            YLog.d("Yodo1AdvertHelper Native开关关闭  不再初始化");
            return;
        }

        List<AdsConfigEntity> adList = Yodo1OnlineConfigAgent.getAdsControl(advertType);

        //根据广告类型决定使用哪个ArrayList
        ArrayList<AdvertBean> advertsLst = null;
        ArrayList<String> playList = null;
        switch (advertType) {
            case Platform_InterstitialAd:
                advertsLst = adverts_intersital;
                playList = playlist_intersital;
                break;
            case Platform_VideoAd:
                advertsLst = adverts_video;
                playList = playlist_video;
                break;
            case Platform_BannerAd:
                advertsLst = adverts_banner;
                playList = playlist_banner;
                break;
            case Platform_NativeAd:
                advertsLst = adverts_native;
                playList = playlist_native;
                break;
            default:
                YLog.v("Yodo1AdvertHelper, 初始化播放列表异常， 传入的AdvertType不正确, advertType=" + advertType);
                return;
        }
        //算出播放百分比总数
        float total = 0;
        for (int i = 0; i < adList.size(); i++) {
            String ratio = adList.get(i).getRatio();
            if (!TextUtils.isEmpty(ratio) && !ratio.equals("-1")){
                total += Float.valueOf(ratio);
            }

        }
        for (int i = 0; i < adList.size(); i++) {

            //实例化所有在权重列表中要播放的广告
            //并且根据总比例算出播放百分比
            AdvertBean bean = new AdvertBean();
            bean.advertCode = adList.get(i).getAdvertCode();
            bean.weight = i + 1;
            bean.maxPlayeTimes = Integer.valueOf(adList.get(i).getMaxShowTimes());;//获取最大播放数

            float ratio = Float.valueOf(adList.get(i).getRatio());
            if (ratio != -1 ){
                bean.percentage = ratio / total;
                YLog.d("Yodo1AdvertHelper,  ratio : "+ratio+ "   total :" + total);
            } else {
                bean.percentage = -1;
            }
            YLog.d("Yodo1AdvertHelper,  bean : "+bean.advertCode+ "   " + bean.percentage);

            advertsLst.add(bean);

            playList.add(advertsLst.get(i).advertCode); //初始化播放列表，默认就按权重播不考虑百分比
            YLog.d("Yodo1AdvertHelper, 初始化" + advertType + "的播放列表, 序列" + (i + 1) + ":" + playList.get(i));
        }

        YLog.i("Yodo1AdvertHelper, 初始化" + advertType + "播放列表：" + playList.toString());
    }



    public class AdvertBean {
        public String advertCode; //代表哪家广告平台
        public int weight; //权重,从1开始
        public float percentage; //所占的播放百分比
        public int played = 0; //已播放的次数
        public int maxPlayeTimes; //最大播放次数
    }


    /**
     * 事件发生时发送广播
     */
    private void sendMsg(Context context,String event,String advertCode) {
        Intent intent = new  Intent();
        intent.setAction("com.yodo1.advert.broadcast");
        intent.putExtra("event",event);
        intent.putExtra("advertCode",advertCode);
        context.sendBroadcast(intent);
    }
}
