package com.yodo1.advert.factory;

import android.content.Context;
import android.os.Build;
import android.util.Log;

import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.adnative.AdNativeAdapterBase;
import com.yodo1.advert.banner.AdBannerAdapterBase;
import com.yodo1.advert.entity.AdvertType;
import com.yodo1.advert.interstitial.AdInterstitialAdapterBase;
import com.yodo1.advert.onlineconfig.AdsConfigEntity;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.splash.AdSplashAdapterBase;
import com.yodo1.advert.utils.YOnlineConfigUtils;
import com.yodo1.advert.video.AdVideoAdapterBase;
import com.yodo1.sdk.kit.YLog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/**
 * Created by yodo1 on 2016/3/21.
 */
public class Yodo1AdvertAdapterFactory {
    private static final String PACKAGE_NAME_INTERSTITIAL = "com.yodo1.advert.interstitial.channel.AdvertAdapter"; //存放插屏插件的完整包名
    private static final String PACKAGE_NAME_VIDEO = "com.yodo1.advert.video.channel.AdvertAdapter"; //存放视频插件的完整包名
    private static final String PACKAGE_NAME_BANNER = "com.yodo1.advert.banner.channel.AdvertAdapter"; //存放Banner插件的完整包名
    private static final String PACKAGE_NAME_SPLASH = "com.yodo1.advert.splash.channel.AdvertAdapter"; //存放Splash插件的完整包名
    private static final String PACKAGE_NAME_NATIVE = "com.yodo1.advert.adnative.channel.AdvertAdapter"; //存放原生广告插件的完整包名

    private static Yodo1AdvertAdapterFactory instance;
    private Map<String, AdapterAdvertBase> _InterstitialAdapters = new HashMap<String, AdapterAdvertBase>(); //用于保存实例化好的插屏广告插件，避免重复实例化
    private Map<String, AdapterAdvertBase> _VideoAdapters = new HashMap<String, AdapterAdvertBase>(); //用于保存实例化好的视频广告插件，避免重复实例化
    private Map<String, AdapterAdvertBase> _BannerAdapters = new HashMap<String, AdapterAdvertBase>(); //用于保存实例化好的Banner广告插件，避免重复实例化
    private Map<String, AdapterAdvertBase> _SplashAdapters = new HashMap<String, AdapterAdvertBase>(); //用于保存实例化好的Splash广告插件，避免重复实例化
    private Map<String, AdapterAdvertBase> _NativeAdapters = new HashMap<String, AdapterAdvertBase>(); //用于保存实例化好的原生广告插件，避免重复实例化

    private Yodo1AdvertAdapterFactory() {
    }

    public static Yodo1AdvertAdapterFactory getInstance() {
        if (instance == null) {
            instance = new Yodo1AdvertAdapterFactory();
        }
        return instance;
    }

    /**
     * 获取所有已经实例化的广告Adapter
     *
     * @return
     */
    public Map<String, AdapterAdvertBase> getAdapters(AdvertType advertType) {
        if (advertType == AdvertType.Interstitial) {
            return _InterstitialAdapters;
        } else if (advertType == AdvertType.Video) {
            return _VideoAdapters;
        } else if (advertType == AdvertType.Banner) {
            return _BannerAdapters;
        } else if (advertType == AdvertType.Splash){
            return _SplashAdapters;
        }else if (advertType == AdvertType.Native){
            return _NativeAdapters;
        }
        return null;
    }

    private boolean hasInit = false;
    /**
     * 实例化所有广告
     */
    public void initAdvertAdapters(Context context) {
        if (hasInit){
            Log.i("yodo1-games-sdk","已经初始化广告列表");
            return;
        }
        hasInit = true;


        //读取该包名下所有的类，并通过是否继承与目标父类，来判断是否需要找的Adapter
        AdvertTypeBean[] advertBeans = {
                new AdvertTypeBean(AdvertType.Interstitial, PACKAGE_NAME_INTERSTITIAL, AdInterstitialAdapterBase.class, _InterstitialAdapters),
                new AdvertTypeBean(AdvertType.Video, PACKAGE_NAME_VIDEO, AdVideoAdapterBase.class, _VideoAdapters),
                new AdvertTypeBean(AdvertType.Banner, PACKAGE_NAME_BANNER, AdBannerAdapterBase.class, _BannerAdapters),
//                new AdvertTypeBean(AdvertType.Splash, PACKAGE_NAME_SPLASH, AdSplashAdapterBase.class, _SplashAdapters),
                new AdvertTypeBean(AdvertType.Native, PACKAGE_NAME_NATIVE, AdNativeAdapterBase.class, _NativeAdapters),
        };

        for (int i = 0; i < advertBeans.length; i++) {
            initAdvertAdapter(context, advertBeans[i]);
        }
    }

    /**
     * 实例化所有广告
     */
    public void initSplashAdvertAdapters(Context context) {

        AdvertTypeBean bean = new AdvertTypeBean(AdvertType.Splash, PACKAGE_NAME_SPLASH, AdSplashAdapterBase.class, _SplashAdapters);
        initAdvertAdapter(context, bean);
    }

    private void initAdvertAdapter(Context context, AdvertTypeBean bean) {
        List<String> advertCodes = getAdCodes(bean);
        for (int i = 0; i < advertCodes.size(); i++) {

            try {
                String className = bean.packageName + advertCodes.get(i);
                Class clz = Class.forName(className);
                if (clz != null) {
                    clz.asSubclass(bean.clz); //如果该类不是继承广告类，那么这里会catch出去
                    AdapterAdvertBase adapterBase = (AdapterAdvertBase) clz.newInstance();
                    bean.adapters.put(adapterBase.getAdvertCode().toLowerCase(Locale.getDefault()), adapterBase);
                    YLog.d("AdvertAdapterFactory --- 实例化广告" + className + ", 地址 = " + adapterBase);
                }
            } catch (Exception e) {
                YLog.i("未实例化广告" + advertCodes.get(i));
            } catch (Error e) {
            }
        }
    }

    /**
     * 获取广告列表
     *
     * @return
     */
    private List<String> getAdCodes(AdvertTypeBean bean) {
        List<AdsConfigEntity> adList =  new ArrayList<>();
        if (bean.advertType == AdvertType.Interstitial && YOnlineConfigUtils.isTrunOnAdvertInterstitial()){
            if (YOnlineConfigUtils.isTrunOnAdvertInterstitial()){
                adList = Yodo1OnlineConfigAgent.getAdsControl(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd);
            }

        } else if (bean.advertType == AdvertType.Video && YOnlineConfigUtils.isTrunOnAdvertVideo()){
            if (YOnlineConfigUtils.isTrunOnAdvertVideo()){
                adList = Yodo1OnlineConfigAgent.getAdsControl(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd);
            }
        } else if (bean.advertType == AdvertType.Banner && YOnlineConfigUtils.isTrunOnAdvertBanner()){
            if (YOnlineConfigUtils.isTrunOnAdvertBanner()){
                adList = Yodo1OnlineConfigAgent.getAdsControl(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd);
            }
        } else if (bean.advertType == AdvertType.Native && YOnlineConfigUtils.isTrunOnAdvertNative()){
            if (YOnlineConfigUtils.isTrunOnAdvertNative()){
                adList = Yodo1OnlineConfigAgent.getAdsControl(Yodo1OnlineConfigAgent.AdvertType.Platform_NativeAd);
            }
        } else if (bean.advertType == AdvertType.Splash && YOnlineConfigUtils.isTrunOnAdvertSplash()){
            if (YOnlineConfigUtils.isTrunOnAdvertSplash()){
                adList = Yodo1OnlineConfigAgent.getAdsControl(Yodo1OnlineConfigAgent.AdvertType.Platform_SplashAd);
            }

        }

        List<String>  weight = new ArrayList<>();
        for (int i = 0 ;i < adList.size() ;i ++) {
            weight.add(adList.get(i).getAdvertCode());
        }

        return weight;
    }


    private class AdvertTypeBean {
        public AdvertType advertType; //广告类型
        public String packageName; //存放插件的完整包名
        public Class<?> clz; //实现方法的广告插件基类
        public Map<String, AdapterAdvertBase> adapters; //存放实例化好的广告插件的集合

        public AdvertTypeBean(AdvertType type, String fullPackageName, Class<?> clz, Map<String, AdapterAdvertBase> adapters) {
            this.advertType = type;
            this.packageName = fullPackageName;
            this.clz = clz;
            this.adapters = adapters;
        }

    }
}
