package com.yodo1.advert.banner.channel;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;

import com.inmobi.ads.InMobiAdRequestStatus;
import com.inmobi.ads.InMobiBanner;
import com.yodo1.advert.banner.AdBannerAdapterBase;
import com.yodo1.advert.banner.Yodo1BannerAlign;
import com.yodo1.advert.banner.Yodo1BannerCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.plugin.inmobi.AdConfigInmobi;
import com.yodo1.advert.plugin.inmobi.AdvertCoreInmobi;
import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.sdk.kit.YLog;

import java.util.Map;


public class AdvertAdapterinmobi extends AdBannerAdapterBase {
    private int align = Yodo1BannerAlign.BannerAlignHorizontalCenter | Yodo1BannerAlign.BannerAlignBottom;
    private InMobiBanner mBannerAd = null;
    private Yodo1BannerCallback callback;
    private boolean showTag = false;
    private int refreshTime = 15;
    private boolean showBanner = false;
    private boolean isLoaded = false;
    InMobiBanner.BannerAdListener bannerAdListener = new InMobiBanner.BannerAdListener(){
        @Override
        public void onAdLoadSucceeded(InMobiBanner inMobiBanner) {
            YLog.d("Inmobi onAdLoadSucceeded");
            isLoaded = true;
            if (showTag && callback != null){
                showTag = false;
                callback.onEvent(Yodo1BannerCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onAdLoadFailed(InMobiBanner inMobiBanner,
                                   InMobiAdRequestStatus inMobiAdRequestStatus) {
            YLog.d("Inmobi  Banner ad failed to load with error: " +
                    inMobiAdRequestStatus.getMessage());

            if (showTag && callback != null){
                showTag = false;
                new Handler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        if (!showBanner){
                            showBanner = false;
                            YLog.d("inmobi  showBanner 已经请求广告  回调次数过多  过滤到最后一次");
                            callback.onAdError(Yodo1BannerCallback.ADVERT_ERROR_COMMON, "onAdLoadFailed",getAdvertCode());
                        }
                    }
                },20000);
            }
        }

        @Override
        public void onAdDisplayed(InMobiBanner inMobiBanner) {
            YLog.d("Inmobi onAdDisplayed");

        }

        @Override
        public void onAdDismissed(InMobiBanner inMobiBanner) {
            YLog.d("Inmobi onAdDismissed");
        }

        @Override
        public void onAdInteraction(InMobiBanner inMobiBanner, Map<Object, Object> map) {
            YLog.d("Inmobi onAdInteraction");
        }

        @Override
        public void onUserLeftApplication(InMobiBanner inMobiBanner) {
            YLog.d("Inmobi onUserLeftApplication");
            if (callback != null){
                callback.onEvent(Yodo1BannerCallback.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onAdRewardActionCompleted(InMobiBanner inMobiBanner, Map<Object, Object> map) {
            YLog.d("Inmobi onAdRewardActionCompleted");
        }
    };
    /* 显示banner广告
      * @param activity
      * @param callback
      */
    @Override
    public  void showBanner(Activity activity,final Yodo1BannerCallback callback){
        this.callback = callback;

        if(TextUtils.isEmpty(AdConfigInmobi.PLACEMENT_ID)) {
            YLog.e("AdvertAdapterInmobi banner PLACEMENT_ID is null");
            callback.onAdError(Yodo1BannerCallback.ADVERT_ERROR_COMMON, "onAdLoadFailed",getAdvertCode());
            return;
        }

        if (mBannerAd == null) {
            showTag = true;
            YLog.d("Inmobi showBanner  new view");
            mBannerAd = new InMobiBanner(activity, Long.parseLong(AdConfigInmobi.PLACEMENT_ID));
//        mBannerAd = new InMobiBanner(activity, 1473189489298L);
//        mBannerAd.setBannerSize(320, 50);
            mBannerAd.setRefreshInterval(refreshTime);
            mBannerAd.setAnimationType(InMobiBanner.AnimationType.ROTATE_HORIZONTAL_AXIS);
            mBannerAd.setListener(bannerAdListener);
            Yodo1BannerAlign.setYodo1BannerLayoutForSize(activity,mBannerAd,align);
            mBannerAd.load();

        } else {
            if (isLoaded ){
                YLog.d("Inmobi showBanner ");
                mBannerAd.setVisibility(View.VISIBLE);
                callback.onEvent(Yodo1BannerCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
            } else {
                callback.onAdError(Yodo1BannerCallback.ADVERT_ERROR_COMMON, "showBannerFailed",getAdvertCode());
            }

        }


    };

    /**
     * banner广告删除
     * @param activity
     */
    @Override
    public  void removeBanner(Activity activity){
        showTag = false;
        isLoaded = false;
        if (callback != null){
            callback.onEvent(Yodo1BannerCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
        }
        if (mBannerAd != null){
            mBannerAd.setVisibility(View.GONE);
            mBannerAd = null;
        }
    };

    /**
     * 隐藏
     * @param activity
     */
    @Override
    public  void hideBanner(Activity activity){
        showTag = false;
        YLog.d("inmobi hideBanner ");
        if (callback != null){
            callback.onEvent(Yodo1BannerCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
        }
        if (mBannerAd != null){
            mBannerAd.setVisibility(View.GONE);
        }
    }


    /**
     * 设置banner展示位置
     * @param activity
     * @param align  banner展示位置
     */
    @Override
    public void setBannerAlign(Activity activity, int align) {
        this.align = align;

    }

    @Override
    public boolean hasLoadBanner() {
        return mBannerAd == null ? true : isLoaded;
    }


    @Override
    public String getAdvertCode() {
        return AdConfigInmobi.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {
//        InMobiSdk.setLogLevel(InMobiSdk.LogLevel.DEBUG);
//        InMobiSdk.init(activity, "123456789abcdfghjiukljnm09874");

        AdvertCoreInmobi.getInstance().init(activity);
        String placementid = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd, AdConfigInmobi.CHANNEL_CODE
                , AdConfigInmobi.KEY_INMOBI_PLACEMENT_ID);

        if (!TextUtils.isEmpty(placementid) && placementid.endsWith("L")){
            AdConfigInmobi.PLACEMENT_ID = placementid.replace("L","");
        } else {
            AdConfigInmobi.PLACEMENT_ID = placementid;
        }

        refreshTime = Integer.valueOf(Yodo1OnlineConfig.getInstance().getConfigParam("Platform_AdsRefreshInterval","15"));

    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }



}
