/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.IBinder;
import android.text.TextUtils;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.uniplay.adsdk.AdActivity;
import com.uniplay.adsdk.AdEntity;
import com.uniplay.adsdk.ClickParser;
import com.uniplay.adsdk.Constants;
import com.uniplay.adsdk.DownloadService;
import com.uniplay.adsdk.WZAdWebViewCallback;
import com.uniplay.adsdk.net.HttpUtil;
import com.uniplay.adsdk.utils.DatabaseUtils;
import com.uniplay.adsdk.utils.PreferencesHelper;
import com.uniplay.adsdk.utils.Record;
import com.uniplay.adsdk.utils.SDKLog;
import com.uniplay.adsdk.utils.Utils;
import java.util.ArrayList;

public class AdWebClient
extends WebViewClient {
    public WZAdWebViewCallback callback;
    private Context context;
    private AdEntity adEntity;
    private DownloadService.DownloadBinder mDownloadBinder;
    private ServiceConnection mConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            AdWebClient.this.mDownloadBinder = (DownloadService.DownloadBinder)iBinder;
        }

        public void onServiceDisconnected(ComponentName componentName) {
            AdWebClient.this.mDownloadBinder = null;
        }
    };

    public void setContext(Context context) {
        this.context = context;
    }

    public void setAdEntity(AdEntity adEntity) {
        this.adEntity = adEntity;
    }

    public AdWebClient(Context context) {
        this.context = context;
    }

    public void onPageFinished(WebView webView, String string) {
        super.onPageFinished(webView, string);
        if (this.callback != null) {
            this.callback.onWebViewLoadFinish(webView);
        }
    }

    public void onPageStarted(WebView webView, String string, Bitmap bitmap) {
        super.onPageStarted(webView, string, bitmap);
        SDKLog.e("AdWebClient onPageStarted", " " + string);
        if (string.equals("about:blank")) {
            return;
        }
        if (this.callback != null) {
            this.callback.onPageStarted();
        }
        try {
            this.sendTrack(this.adEntity.click);
            Constants.click_send = this.adEntity.click;
            Uri uri = Uri.parse((String)string);
            SDKLog.e("AdWebClient onPageStarted " + uri.getPath(), uri.getScheme() + " " + string);
            String string2 = uri.getScheme().toLowerCase();
            if (string2.equals("http") || string2.equals("https")) {
                String string3 = uri.getPath().toLowerCase();
                if (string3.endsWith(".apk") || Utils.isAPK(string)) {
                    long l2 = this.insertDownloadRecord(this.context, this.adEntity);
                    Intent intent = new Intent(this.context.getApplicationContext(), DownloadService.class);
                    intent.putExtra("action", "b");
                    intent.putExtra("id", l2);
                    intent.putExtra("dtimes", this.adEntity.dtimes);
                    this.context.getApplicationContext().startService(intent);
                    this.context.getApplicationContext().bindService(intent, this.mConnection, 1);
                    Utils.showToast(this.context, "\u6b63\u5728\u4e0b\u8f7d\u4e2d...\u8bf7\u7a0d\u5019!");
                } else {
                    Intent intent = new Intent(this.context, AdActivity.class);
                    intent.putExtra("st", this.adEntity.st);
                    intent.putExtra("url", string);
                    if (!TextUtils.isEmpty((CharSequence)this.adEntity.dplink)) {
                        intent.putExtra("dplink", this.adEntity.dplink);
                    }
                    if (!this.adEntity.downsucc.isEmpty()) {
                        intent.putExtra("downsucc ", this.adEntity.downsucc);
                    }
                    if (!this.adEntity.installsucc.isEmpty()) {
                        intent.putExtra("installsucc", this.adEntity.installsucc);
                    }
                    if (!this.adEntity.appactive.isEmpty()) {
                        intent.putExtra("appactive", this.adEntity.appactive);
                    }
                    if (this.adEntity.kt.size() > 0) {
                        intent.putExtra("kt", this.adEntity.kt);
                    }
                    intent.putExtra("dtimes", this.adEntity.dtimes);
                    this.context.startActivity(intent);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        super.onPageStarted(webView, string, bitmap);
    }

    public long insertDownloadRecord(Context context, AdEntity adEntity) {
        Record record = new Record();
        record.setUrl(adEntity.lpg);
        record.setPkgName(adEntity.pkg);
        record.setCname(Utils.list2String(adEntity.cname));
        record.setIaction(adEntity.iaction);
        record.setDownsucc(Utils.list2String(adEntity.downsucc));
        try {
            if (!Utils.stringIsEmpty(Utils.list2String(adEntity.installsucc))) {
                PreferencesHelper.getInstance(context).savaInstallsucc(record.getUrl(), Utils.list2String(adEntity.installsucc));
                record.setInstallsucc(Utils.list2String(adEntity.installsucc));
            }
            if (!Utils.stringIsEmpty(Utils.list2String(adEntity.appactive))) {
                PreferencesHelper.getInstance(context).savaAppactive(record.getUrl(), Utils.list2String(adEntity.appactive));
                record.setAppactive(Utils.list2String(adEntity.appactive));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        record.setApkmd5(adEntity.md5);
        record.setSin(adEntity.sin);
        record.setRpt(adEntity.rpt);
        record.setAppname(adEntity.appname);
        record.setAppicon(adEntity.appicon);
        return DatabaseUtils.insertRecord(context, record);
    }

    public boolean shouldOverrideUrlLoading(WebView webView, String string) {
        return false;
    }

    public void sendTrack(ArrayList<String> arrayList) {
        SDKLog.e("INFO", ((Object)((Object)this)).getClass().getName() + "onpagestart-click: \u4e0a\u62a5");
        try {
            for (String string : arrayList) {
                HttpUtil.AddTaskToQueueHead(string, 257, new ClickParser(), null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onLoadResource(WebView webView, String string) {
        super.onLoadResource(webView, string);
    }
}

