/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk.video;

import android.content.Context;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import android.widget.VideoView;
import com.uniplay.adsdk.utils.SDKLog;
import com.uniplay.adsdk.video.Player;
import com.uniplay.adsdk.video.TrackingVideoView;
import com.uniplay.adsdk.video.VideoPlayerListener;

public class VideoPlayerView
extends FrameLayout
implements Player,
VideoPlayerListener {
    private static final String COUNTDOWN_PREFIX = "\u5e7f\u544a ";
    private TrackingVideoView videoView = null;
    private TextView countdownTextView = null;
    private TextView loadingTextView = null;
    private static int currentTime = -1;

    public VideoPlayerView(Context context) {
        super(context);
        this.setup();
    }

    public VideoPlayerView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setup();
    }

    public VideoPlayerView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.setup();
    }

    private void setup() {
        currentTime = -1;
        this.videoView = new TrackingVideoView(this.getContext(), this);
        this.videoView.addCallback(this);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1, 17);
        this.addView((View)this.videoView, (ViewGroup.LayoutParams)layoutParams);
        this.countdownTextView = new TextView(this.getContext());
        layoutParams = new FrameLayout.LayoutParams(-2, -2, 83);
        this.countdownTextView.setTextColor(-1);
        this.addView((View)this.countdownTextView, (ViewGroup.LayoutParams)layoutParams);
        this.loadingTextView = new TextView(this.getContext());
        layoutParams = new FrameLayout.LayoutParams(-2, -2, 17);
        this.loadingTextView.setText((CharSequence)"\u52a0\u8f7d\u4e2d... \u8bf7\u7a0d\u5019!");
        this.loadingTextView.setTextColor(-1);
        this.loadingTextView.setTextSize(14.0f);
        this.addView((View)this.loadingTextView, (ViewGroup.LayoutParams)layoutParams);
    }

    public void setMute() {
        this.videoView.setMute();
    }

    public void setSysMute() {
        this.videoView.setSysMute();
    }

    @Override
    public void addCallback(VideoPlayerListener videoPlayerListener) {
        this.videoView.addCallback(videoPlayerListener);
    }

    @Override
    public void playAd(String string) {
        if (string.startsWith("http")) {
            Uri uri = Uri.parse((String)string);
            this.videoView.setVideoURI(uri);
        } else {
            this.videoView.setVideoPath(string);
        }
        this.videoView.requestFocus();
        this.videoView.start();
    }

    @Override
    public void removeCallback(VideoPlayerListener videoPlayerListener) {
        this.videoView.removeCallback(videoPlayerListener);
    }

    @Override
    public void stopAd() {
        this.videoView.stopPlayback();
    }

    public void pause() {
        currentTime = this.videoView.getCurrentPosition();
        this.videoView.pause();
    }

    public void resume() {
        SDKLog.e("doll", " currentTime " + currentTime);
        if (currentTime != -1) {
            this.videoView.seekTo(currentTime);
            currentTime = -1;
        }
        this.videoView.resume();
        this.videoView.start();
    }

    @Override
    public VideoView getVideoView() {
        return this.videoView;
    }

    @Override
    public void onVideoClick(Player player) {
    }

    @Override
    public void onVideoComplete(Player player) {
        this.countdownTextView.setText((CharSequence)"\u5e7f\u544a 0:00");
    }

    @Override
    public void onVideoError(Player player) {
        this.loadingTextView.setVisibility(0);
        this.loadingTextView.setText((CharSequence)"\u52a0\u8f7d\u5931\u8d25...");
    }

    @Override
    public void onVideoPause(Player player) {
    }

    @Override
    public void onVideoPlay(Player player) {
        this.loadingTextView.setVisibility(8);
    }

    @Override
    public void onVideoProgress(Player player, int n2, int n3) {
        int n4 = (n3 - n2) / 60;
        String string = String.format("%02d", (n3 - n2) % 60);
        StringBuilder stringBuilder = new StringBuilder(COUNTDOWN_PREFIX.length() + 4);
        stringBuilder.append(COUNTDOWN_PREFIX).append(n4).append(':').append(string);
        this.countdownTextView.setText((CharSequence)stringBuilder.toString());
    }

    @Override
    public void onVideoResume(Player player) {
    }

    @Override
    public void onVideoVolumeChanged(Player player, int n2) {
        SDKLog.e(this.getClass().getName(), "volume:" + n2);
    }

    public void setOnTouchListener(View.OnTouchListener onTouchListener) {
        this.videoView.setOnTouchListener(onTouchListener);
    }

    public void start() {
        if (!this.videoView.isPlaying()) {
            this.videoView.start();
        }
    }
}

