package com.yodo1ads.adapter.video;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;

import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.reward.RewardItem;
import com.google.android.gms.ads.reward.RewardedVideoAd;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.video.AdVideoAdapterBase;
import com.yodo1.advert.video.Yodo1VideoCallback;
import com.yodo1.advert.video.Yodo1VideoReloadCallback;
import com.yodo1.sdk.kit.YLog;
import com.yodo1ads.plugin.admob.AdConfigAdMob;
import com.yodo1ads.plugin.admob.AdvertCoreAdMob;

public class AdvertAdapteradmob extends AdVideoAdapterBase {
    private  String UnitId = "";
    private boolean isLoded = false;
    private Yodo1VideoCallback videoCallback; //视频回调
    private Yodo1VideoReloadCallback reloadCallback; //视频预加载回调
    private RewardedVideoAd mRewardedVideoAd;
    private RewardedVideoAdListener listener = new RewardedVideoAdListener() {
        @Override
        public void onRewardedVideoAdLoaded() {
            isLoded = true;
            if (reloadCallback!=null){
                reloadCallback.onResult(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD_FINISH, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAdOpened() {
            if (videoCallback!=null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoStarted() {

        }

        @Override
        public void onRewardedVideoAdClosed() {
            if (videoCallback!=null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onRewarded(RewardItem rewardItem) {

        }

        @Override
        public void onRewardedVideoAdLeftApplication() {
            if (videoCallback!=null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoAdFailedToLoad(int i) {
            YLog.i("AdMob   onRewardedVideoAdFailedToLoad: " + i);
            if (reloadCallback!=null){
                reloadCallback.onResult(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD_FAILED, getAdvertCode());
            }
        }

        @Override
        public void onRewardedVideoCompleted() {
            if (videoCallback!=null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }
    };
    @Override
    public String getAdvertCode() {
        return AdConfigAdMob.CHANNEL_CODE;
    }

    @Override
    public void validateAdsAdapter(Activity activity) {
        AdvertCoreAdMob.getInstance().validateAds(activity);
    }
    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {
        UnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, AdConfigAdMob.CHANNEL_CODE
                , AdConfigAdMob.KEY_AdMob_VIDEO_ID);
        if (TextUtils.isEmpty(UnitId)){
            YLog.e("AdMob Video Appid  is null");
            return;
        }

        //此处读取key
        AdvertCoreAdMob.getInstance().initAdMob(activity);
//        MobileAds.initialize(activity,
//                "ca-app-pub-3940256099942544~3347511713");

        // Use an activity context to get the rewarded video instance.
        mRewardedVideoAd = MobileAds.getRewardedVideoAdInstance(activity);
        mRewardedVideoAd.setRewardedVideoAdListener(listener);



    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {
        if (mRewardedVideoAd != null){
            mRewardedVideoAd.resume(activity);
        }
    }

    @Override
    public void onPause(Activity activity) {
        if (mRewardedVideoAd != null){
            mRewardedVideoAd.pause(activity);
        }
    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {
        if (mRewardedVideoAd != null){
            mRewardedVideoAd.destroy(activity);
        }
    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }

    @Override
    public void showVideoAdvert(Activity activity, Yodo1VideoCallback callback) {
        this.videoCallback = callback;
        if (mRewardedVideoAd != null && mRewardedVideoAd.isLoaded()) {
            mRewardedVideoAd.show();
        } else {
            callback.onAdError(Yodo1VideoCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }

        isLoded = false;
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1VideoReloadCallback reloadCallback) {
        if (TextUtils.isEmpty(UnitId)){
            YLog.e("AdMob Video UnitId  is null");
            return;
        }

        YLog.d("Admob reloadVideoAdvert : " + UnitId);
        if (mRewardedVideoAd != null){
            mRewardedVideoAd.loadAd(UnitId,
                    new AdRequest.Builder().addTestDevice("C8F01879446BEC2C7519C0B7191B3782").build());
        }

    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return isLoded;
    }
}
