/*
 * Decompiled with CFR 0.152.
 */
package com.mintegral.msdk.videocommon.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.ImageView;
import com.mintegral.msdk.base.utils.l;

public class RoundImageView
extends ImageView {
    private int a;
    private int b;
    private Paint c;
    private int d;
    private Matrix e;
    private BitmapShader f;
    private int g;
    private RectF h;

    public RoundImageView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.e = new Matrix();
        this.c = new Paint();
        this.c.setAntiAlias(true);
        this.b = (int)TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.a = 1;
    }

    public RoundImageView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public RoundImageView(Context context) {
        super(context);
    }

    protected void onMeasure(int n2, int n3) {
        super.onMeasure(n2, n3);
        if (this.a == 0) {
            this.g = Math.min(this.getMeasuredWidth(), this.getMeasuredHeight());
            this.d = this.g / 2;
            this.setMeasuredDimension(this.g, this.g);
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.getDrawable() == null) {
            return;
        }
        RoundImageView roundImageView = this;
        Drawable drawable2 = roundImageView.getDrawable();
        if (drawable2 != null) {
            Bitmap bitmap;
            if (drawable2 instanceof BitmapDrawable) {
                bitmap = ((BitmapDrawable)drawable2).getBitmap();
            } else {
                int n2 = drawable2.getIntrinsicWidth();
                int n3 = drawable2.getIntrinsicHeight();
                Bitmap bitmap2 = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas2 = new Canvas(bitmap2);
                drawable2.setBounds(0, 0, n2, n3);
                drawable2.draw(canvas2);
                bitmap = bitmap2;
            }
            drawable2 = bitmap;
            roundImageView.f = new BitmapShader((Bitmap)drawable2, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            float f2 = 1.0f;
            if (roundImageView.a == 0) {
                int n4 = Math.min(drawable2.getWidth(), drawable2.getHeight());
                f2 = (float)roundImageView.g * 1.0f / (float)n4;
            } else if (roundImageView.a == 1) {
                f2 = Math.max((float)roundImageView.getWidth() * 1.0f / (float)drawable2.getWidth(), (float)roundImageView.getHeight() * 1.0f / (float)drawable2.getHeight());
            }
            roundImageView.e.setScale(f2, f2);
            roundImageView.f.setLocalMatrix(roundImageView.e);
            roundImageView.c.setShader((Shader)roundImageView.f);
        }
        if (this.a == 1) {
            canvas.drawRoundRect(this.h, (float)this.b, (float)this.b, this.c);
            return;
        }
        canvas.drawCircle((float)this.d, (float)this.d, (float)this.d, this.c);
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        super.onSizeChanged(n2, n3, n4, n5);
        if (this.a == 1) {
            this.h = new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
        }
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("state_instance", super.onSaveInstanceState());
        bundle.putInt("state_type", this.a);
        bundle.putInt("state_border_radius", this.b);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable instanceof Bundle) {
            Bundle bundle = (Bundle)parcelable;
            super.onRestoreInstanceState(((Bundle)parcelable).getParcelable("state_instance"));
            this.a = bundle.getInt("state_type");
            this.b = bundle.getInt("state_border_radius");
            return;
        }
        super.onRestoreInstanceState(parcelable);
    }

    public void setBorderRadius(int n2) {
        n2 = l.a(this.getContext(), n2);
        if (this.b != n2) {
            this.b = n2;
            this.invalidate();
        }
    }

    public void setType(int n2) {
        if (this.a != n2) {
            this.a = n2;
            if (this.a != 1 && this.a != 0) {
                this.a = 0;
            }
            this.requestLayout();
        }
    }
}

