/*
 * Decompiled with CFR 0.152.
 */
package com.yixsoft.support.mybatis.spring.annotation;

import com.yixsoft.support.mybatis.YixMapperFactoryBean;
import com.yixsoft.support.mybatis.spring.annotation.MapperScanner;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.mybatis.spring.mapper.ClassPathMapperScanner;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MyBatisMapperScannerConfigurer
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware {
    private ResourceLoader resourceLoader;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Class markerInterface;
        AnnotationAttributes annoAttrs = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(MapperScanner.class.getName()));
        Assert.notNull((Object)annoAttrs, (String)"MapperScanner should not be null here");
        ClassPathMapperScanner scanner = new ClassPathMapperScanner(registry);
        if (this.resourceLoader != null) {
            scanner.setResourceLoader(this.resourceLoader);
        }
        scanner.setAddToConfig(true);
        Class annotationClass = annoAttrs.getClass("annotationClass");
        if (!Annotation.class.equals((Object)annotationClass)) {
            scanner.setAnnotationClass(annotationClass);
        }
        if (!Class.class.equals((Object)(markerInterface = annoAttrs.getClass("markerInterface")))) {
            scanner.setMarkerInterface(markerInterface);
        }
        scanner.setSqlSessionTemplateBeanName(annoAttrs.getString("sqlSessionTemplateRef"));
        scanner.setSqlSessionFactoryBeanName(annoAttrs.getString("sqlSessionFactoryRef"));
        scanner.setResourceLoader(this.resourceLoader);
        scanner.setMapperFactoryBeanClass(YixMapperFactoryBean.class);
        scanner.registerFilters();
        String classPackage = ClassUtils.getPackageName((String)importingClassMetadata.getClassName());
        ArrayList<String> basePackages = new ArrayList<String>();
        for (String pkg : annoAttrs.getStringArray("value")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(this.filterPackage(pkg, classPackage));
        }
        for (String pkg : annoAttrs.getStringArray("basePackages")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(this.filterPackage(pkg, classPackage));
        }
        if (basePackages.isEmpty()) {
            basePackages.add(classPackage);
        }
        String[] basePackagesStr = basePackages.toArray(new String[basePackages.size()]);
        scanner.scan(basePackagesStr);
    }

    private String filterPackage(String pkg, String classPackage) {
        if (pkg.startsWith(".")) {
            return classPackage + pkg;
        }
        return pkg;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

