/*
 * Decompiled with CFR 0.152.
 */
package com.yixsoft.support.mybatis.spring;

import com.github.miemiedev.mybatis.paginator.OffsetLimitInterceptor;
import com.yixsoft.support.mybatis.autosql.dialects.ISqlDialect;
import com.yixsoft.support.mybatis.autosql.dialects.SqlDialectManager;
import com.yixsoft.support.mybatis.autosql.dialects.SupportsDatabase;
import com.yixsoft.support.mybatis.autosql.pk.UUIDPkProvider;
import java.util.Properties;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.session.Configuration;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class YixMyBatisConfig
implements InitializingBean,
ResourceLoaderAware {
    private String configLocation;
    private Properties configurationProperties;
    @NestedConfigurationProperty
    private Configuration configuration;
    private PaginatorConfig paginator;
    private Class<? extends ISqlDialect>[] dialects;
    private Class<? extends KeyGenerator> defaultKeyGenerator = UUIDPkProvider.class;
    private ResourceLoader resourceLoader;

    public String getConfigLocation() {
        return this.configLocation;
    }

    public YixMyBatisConfig setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
        return this;
    }

    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    public YixMyBatisConfig setConfigurationProperties(Properties configurationProperties) {
        this.configurationProperties = configurationProperties;
        return this;
    }

    public YixMyBatisConfig setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public YixMyBatisConfig setDialects(Class<? extends ISqlDialect>[] dialects) {
        this.dialects = dialects;
        return this;
    }

    public Class<? extends ISqlDialect>[] getDialects() {
        return this.dialects;
    }

    public Class<? extends KeyGenerator> getDefaultKeyGenerator() {
        return this.defaultKeyGenerator;
    }

    public YixMyBatisConfig setDefaultKeyGenerator(Class<? extends KeyGenerator> defaultKeyGenerator) {
        this.defaultKeyGenerator = defaultKeyGenerator;
        return this;
    }

    public void afterPropertiesSet() {
        if (this.paginator != null && this.paginator.isEnable()) {
            Assert.notNull((Object)this.paginator.getDialect(), (String)"Paginator dialect not determined");
        }
        if (this.dialects != null) {
            for (Class<? extends ISqlDialect> dialectClazz : this.dialects) {
                if (!AnnotatedElementUtils.isAnnotated(dialectClazz, SupportsDatabase.class)) continue;
                SupportsDatabase supports = (SupportsDatabase)AnnotatedElementUtils.getMergedAnnotation(dialectClazz, SupportsDatabase.class);
                Assert.notNull((Object)supports, (String)"Annotation should not be null as checked before");
                for (String db : supports.value()) {
                    SqlDialectManager.register((String)db, dialectClazz);
                }
            }
        }
        if (StringUtils.hasText((String)this.getConfigLocation())) {
            Resource resource = this.resourceLoader.getResource(this.getConfigLocation());
            Assert.state((boolean)resource.exists(), (String)("Cannot find config location: " + resource + " (please add config file or check your Mybatis configuration)"));
        }
    }

    public void configOffsetLimitInterceptor(OffsetLimitInterceptor interceptor) {
        interceptor.setDialectClass(this.paginator.getDialect());
        if (this.paginator.getPoolMaxSize() > 0) {
            interceptor.setPoolMaxSize(this.paginator.getPoolMaxSize());
        }
        interceptor.setAsyncTotalCount(this.paginator.isAsyncTotalCount());
    }

    public PaginatorConfig getPaginator() {
        return this.paginator;
    }

    public YixMyBatisConfig setPaginator(PaginatorConfig paginator) {
        this.paginator = paginator;
        return this;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public static class PaginatorConfig {
        private boolean enable;
        private String dialect;
        private int poolMaxSize = 0;
        private boolean asyncTotalCount;
        private boolean advancedCount;

        public boolean isEnable() {
            return this.enable;
        }

        public PaginatorConfig setEnable(boolean enable) {
            this.enable = enable;
            return this;
        }

        public String getDialect() {
            return this.dialect;
        }

        public PaginatorConfig setDialect(String dialect) {
            this.dialect = dialect;
            return this;
        }

        public int getPoolMaxSize() {
            return this.poolMaxSize;
        }

        public PaginatorConfig setPoolMaxSize(int poolMaxSize) {
            this.poolMaxSize = poolMaxSize;
            return this;
        }

        public boolean isAsyncTotalCount() {
            return this.asyncTotalCount;
        }

        public PaginatorConfig setAsyncTotalCount(boolean asyncTotalCount) {
            this.asyncTotalCount = asyncTotalCount;
            return this;
        }

        public boolean isAdvancedCount() {
            return this.advancedCount;
        }

        public PaginatorConfig setAdvancedCount(boolean advancedCount) {
            this.advancedCount = advancedCount;
            return this;
        }
    }
}

