/*
 * Decompiled with CFR 0.152.
 */
package com.yixsoft.support.mybatis.spring;

import com.github.miemiedev.mybatis.paginator.OffsetLimitInterceptor;
import com.yixsoft.support.mybatis.YixMapperFactoryBean;
import com.yixsoft.support.mybatis.plugins.AdvancedPaginationInterceptor;
import com.yixsoft.support.mybatis.spring.YixMyBatisConfig;
import javax.sql.DataSource;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class})
@ConditionalOnSingleCandidate(value=DataSource.class)
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
@AutoConfigureBefore(name={"org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration"})
public class MapperConfiguration {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ResourceLoader resourceLoader;
    private final DatabaseIdProvider databaseIdProvider;

    public MapperConfiguration(ResourceLoader resourceLoader, ObjectProvider<DatabaseIdProvider> databaseIdProviders) {
        this.resourceLoader = resourceLoader;
        this.databaseIdProvider = (DatabaseIdProvider)databaseIdProviders.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean(value={YixMyBatisConfig.class})
    @ConfigurationProperties(prefix="mybatis")
    public YixMyBatisConfig yixMyBatisConfig() {
        return new YixMyBatisConfig();
    }

    @Bean
    public SqlSessionFactory sqlSessionFactory(DataSource dataSource, YixMyBatisConfig config, ObjectProvider<Interceptor[]> interceptorProvider) throws Exception {
        SqlSessionFactoryBean factory = new SqlSessionFactoryBean();
        factory.setDataSource(dataSource);
        if (StringUtils.hasText((String)config.getConfigLocation())) {
            factory.setConfigLocation(this.resourceLoader.getResource(config.getConfigLocation()));
        }
        this.applyConfiguration(factory, config);
        Interceptor[] interceptors = (Interceptor[])interceptorProvider.getIfAvailable();
        if (interceptors != null) {
            factory.setPlugins(interceptors);
        }
        if (this.databaseIdProvider != null) {
            factory.setDatabaseIdProvider(this.databaseIdProvider);
        }
        return factory.getObject();
    }

    private void applyConfiguration(SqlSessionFactoryBean factory, YixMyBatisConfig config) {
        org.apache.ibatis.session.Configuration configuration = config.getConfiguration();
        if (configuration == null && !StringUtils.hasText((String)config.getConfigLocation())) {
            configuration = new org.apache.ibatis.session.Configuration();
        }
        YixMapperFactoryBean.setDefaultKeyGen(config.getDefaultKeyGenerator());
        factory.setConfiguration(configuration);
    }

    @Bean
    @ConditionalOnMissingBean
    public SqlSessionTemplate sqlSessionTemplate(SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }

    @Bean
    @ConditionalOnProperty(value={"mybatis.paginator.enable"}, havingValue="true")
    public OffsetLimitInterceptor offsetLimitInterceptor(YixMyBatisConfig config) {
        OffsetLimitInterceptor interceptor = new OffsetLimitInterceptor();
        config.configOffsetLimitInterceptor(interceptor);
        return interceptor;
    }

    @Bean
    @ConditionalOnBean(value={OffsetLimitInterceptor.class})
    public AdvancedPaginationInterceptor advancedPaginationInterceptor(YixMyBatisConfig config) {
        return new AdvancedPaginationInterceptor(config.getPaginator().isEnable());
    }
}

