/*
 * Decompiled with CFR 0.152.
 */
package com.yinli.ylscrollview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.widget.TextView;
import com.yinli.ylscrollview.R;

public class YLVerticalTextLabelView
extends TextView {
    private boolean isTopDown;

    public YLVerticalTextLabelView(Context context) {
        this(context, null);
    }

    public YLVerticalTextLabelView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YLVerticalTextLabelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.YLVerticalTextLabelView, defStyleAttr, 0);
        try {
            this.isTopDown = typedArray.getBoolean(R.styleable.YLVerticalTextLabelView_ylsv_topDown, false);
        }
        finally {
            typedArray.recycle();
        }
        this.init();
    }

    private void init() {
    }

    protected void onDraw(Canvas canvas) {
        TextPaint textPaint = this.getPaint();
        textPaint.setColor(this.getCurrentTextColor());
        textPaint.drawableState = this.getDrawableState();
        canvas.save();
        if (this.isTopDown) {
            canvas.rotate(-90.0f);
            canvas.translate((float)(-this.getMeasuredHeight()), 0.0f);
        } else {
            canvas.rotate(90.0f);
            canvas.translate(0.0f, (float)(-this.getMeasuredWidth()));
        }
        canvas.translate((float)this.getCompoundPaddingLeft(), (float)this.getExtendedPaddingTop());
        this.getLayout().draw(canvas);
        canvas.restore();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.getMeasuredHeight(), this.getMeasuredWidth());
    }
}

