/*
 * Decompiled with CFR 0.152.
 */
package com.yinli.ylscrollview;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.view.View;
import com.yinli.ylscrollview.R;

public class YLVerticalGraphicLabelView
extends View {
    private float MID_POINT_RADIUS = 10.0f;
    private float ARROW_X_LEN = 20.0f;
    private float ARROW_Y_LEN = 20.0f;
    private float STROKE_WIDTH = 5.0f;
    private float LENGTH_RATIO = 0.5f;
    private int fillColor;

    public YLVerticalGraphicLabelView(Context context) {
        this(context, null);
    }

    public YLVerticalGraphicLabelView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public YLVerticalGraphicLabelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        Resources res = this.getResources();
        this.MID_POINT_RADIUS = res.getDimension(R.dimen.graphic_mid_point_radius);
        this.ARROW_X_LEN = res.getDimension(R.dimen.graphic_arrow_width);
        this.ARROW_Y_LEN = res.getDimension(R.dimen.graphic_arrow_height);
        this.STROKE_WIDTH = res.getDimension(R.dimen.graphic_stroke_width);
    }

    public int getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(int fillColor) {
        this.fillColor = fillColor;
        this.invalidate();
    }

    public float getMidPointRadius() {
        return this.MID_POINT_RADIUS;
    }

    public float getArrowXLen() {
        return this.ARROW_X_LEN;
    }

    public float getArrowYLen() {
        return this.ARROW_Y_LEN;
    }

    public float getStrokeWidth() {
        return this.STROKE_WIDTH;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Paint paint = new Paint(1);
        paint.setColor(this.fillColor);
        this.drawTopLine(canvas, paint);
        this.drawMidCircle(canvas, paint);
        this.drawBotLine(canvas, paint);
    }

    private void drawTopLine(Canvas canvas, Paint paint) {
        paint.setStrokeWidth(this.STROKE_WIDTH);
        paint.setStyle(Paint.Style.STROKE);
        float point_y_s = (float)this.getMeasuredHeight() * (1.0f - this.LENGTH_RATIO) / 2.0f;
        float point_y_e = (float)(this.getMeasuredHeight() / 2) - 2.0f * this.MID_POINT_RADIUS;
        Path path = new Path();
        path.setFillType(Path.FillType.EVEN_ODD);
        path.moveTo((float)(this.getMeasuredWidth() / 2), point_y_s);
        path.lineTo((float)(this.getMeasuredWidth() / 2), point_y_e);
        canvas.drawPath(path, paint);
        this.drawArrow(canvas, paint, true, this.getMeasuredWidth() / 2, point_y_s);
    }

    private void drawBotLine(Canvas canvas, Paint paint) {
        paint.setStrokeWidth(this.STROKE_WIDTH);
        paint.setStyle(Paint.Style.STROKE);
        float point_y_s = (float)(this.getMeasuredHeight() / 2) + 2.0f * this.MID_POINT_RADIUS;
        float point_y_e = (float)this.getMeasuredHeight() * (1.0f + this.LENGTH_RATIO) / 2.0f;
        Path path = new Path();
        path.setFillType(Path.FillType.EVEN_ODD);
        path.moveTo((float)(this.getMeasuredWidth() / 2), point_y_s);
        path.lineTo((float)(this.getMeasuredWidth() / 2), point_y_e);
        canvas.drawPath(path, paint);
        this.drawArrow(canvas, paint, false, this.getMeasuredWidth() / 2, point_y_e);
    }

    private void drawMidCircle(Canvas canvas, Paint paint) {
        paint.setStyle(Paint.Style.FILL);
        canvas.drawCircle((float)(this.getMeasuredWidth() / 2), (float)(this.getMeasuredHeight() / 2), this.MID_POINT_RADIUS, paint);
    }

    private void drawArrow(Canvas canvas, Paint paint, boolean up, float x, float y) {
        paint.setStyle(Paint.Style.FILL);
        float startX = x;
        float startY = up ? y + this.ARROW_Y_LEN : y - this.ARROW_Y_LEN;
        PointF point_0 = new PointF(startX, startY);
        PointF point_1 = new PointF(startX - this.ARROW_X_LEN / 2.0f, startY);
        PointF point_2 = new PointF(startX, y);
        PointF point_3 = new PointF(startX + this.ARROW_X_LEN / 2.0f, startY);
        Path path = new Path();
        path.setFillType(Path.FillType.EVEN_ODD);
        path.moveTo(point_0.x, point_0.y);
        path.lineTo(point_1.x, point_1.y);
        path.lineTo(point_2.x, point_2.y);
        path.lineTo(point_3.x, point_3.y);
        path.close();
        canvas.drawPath(path, paint);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }
}

