/*
 * Decompiled with CFR 0.152.
 */
package com.yinli.ylscrollview;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import com.yinli.ylscrollview.R;
import com.yinli.ylscrollview.YLVerticalGraphicLabelView;
import com.yinli.ylscrollview.YLVerticalTextLabelView;

public class YLScrollView
extends FrameLayout {
    private ScrollView mScrollView;
    private YLVerticalTextLabelView mVerticalTextView;
    private YLVerticalGraphicLabelView mVerticalGraphicView;
    private LinearLayout mContainer;
    private int indicatorVisibility = -1;
    private int mTextViewMeasuredWidth;
    private int mAnimType;
    private String mText;
    private float mTextSize;
    private int mColor;
    private IndicatorType mType;

    public YLScrollView(Context context) {
        this(context, null);
    }

    public YLScrollView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YLScrollView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        Resources res = this.getResources();
        int defaultAnimType = res.getInteger(R.integer.default_indicator_animation_type);
        String defaultText = res.getString(R.string.default_indicator_text);
        float defaultTextSize = res.getDimension(R.dimen.default_indicator_text_size);
        int defaultTextColor = res.getColor(R.color.default_indicator_color);
        int defaultIndicatorType = res.getInteger(R.integer.default_indicator_type);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.YLScrollView, defStyle, 0);
        try {
            this.mAnimType = typedArray.getInt(R.styleable.YLScrollView_ylsv_animationType, defaultAnimType);
            this.mText = typedArray.getString(R.styleable.YLScrollView_ylsv_text);
            this.mTextSize = typedArray.getDimension(R.styleable.YLScrollView_ylsv_textSize, defaultTextSize);
            this.mColor = typedArray.getColor(R.styleable.YLScrollView_ylsv_indicatorColor, defaultTextColor);
            this.mType = IndicatorType.fromValue(typedArray.getInteger(R.styleable.YLScrollView_ylsv_type, defaultIndicatorType));
            if (this.mText == null) {
                this.mText = defaultText;
            }
        }
        finally {
            typedArray.recycle();
        }
        this.init(context);
    }

    private void init(Context mContext) {
        this.mContainer = new LinearLayout(mContext);
        FrameLayout.LayoutParams params0 = new FrameLayout.LayoutParams(-1, -1);
        this.mContainer.setLayoutParams((ViewGroup.LayoutParams)params0);
        this.mVerticalTextView = new YLVerticalTextLabelView(mContext);
        LinearLayout.LayoutParams params2 = new LinearLayout.LayoutParams(-2, -2);
        params2.gravity = 16;
        this.mVerticalTextView.setText(this.mText);
        this.mVerticalTextView.setTextSize(0, this.mTextSize);
        this.mVerticalTextView.setTextColor(this.mColor);
        this.mVerticalTextView.setLayoutParams((ViewGroup.LayoutParams)params2);
        this.mVerticalGraphicView = new YLVerticalGraphicLabelView(mContext);
        float minWidth = Math.max(this.mVerticalGraphicView.getMidPointRadius() + this.mVerticalGraphicView.getStrokeWidth(), this.mVerticalGraphicView.getArrowXLen() + this.mVerticalGraphicView.getStrokeWidth());
        LinearLayout.LayoutParams params3 = new LinearLayout.LayoutParams((int)(minWidth + 30.0f), -1);
        this.mVerticalGraphicView.setFillColor(this.mColor);
        this.mVerticalGraphicView.setLayoutParams((ViewGroup.LayoutParams)params3);
        this.mScrollView = new ScrollView(mContext);
        LinearLayout.LayoutParams params1 = new LinearLayout.LayoutParams(-1, -1);
        params1.weight = 1.0f;
        this.mScrollView.setScrollBarStyle(0x2000000);
        this.mScrollView.setLayoutParams((ViewGroup.LayoutParams)params1);
    }

    public int getAnimType() {
        return this.mAnimType;
    }

    public void setAnimType(int animType) {
        this.mAnimType = animType;
        this.invalidate();
    }

    public String getText() {
        return this.mText;
    }

    public void setText(String text) {
        this.mVerticalTextView.setText(text);
        this.invalidate();
    }

    public float getTextSize() {
        return this.mVerticalTextView.getTextSize();
    }

    public void setTextSize(float textSize) {
        this.mVerticalTextView.setTextSize(textSize);
        this.invalidate();
    }

    public int getIndicatorColor() {
        int color2 = 0;
        switch (this.getIndicatorType()) {
            case Text: {
                color2 = this.mVerticalTextView.getCurrentTextColor();
                break;
            }
            case Graphic: {
                color2 = this.mVerticalGraphicView.getFillColor();
            }
        }
        return color2;
    }

    public void setIndicatorColor(int color2) {
        switch (this.getIndicatorType()) {
            case Text: {
                this.mVerticalTextView.setTextColor(color2);
                break;
            }
            case Graphic: {
                this.mVerticalGraphicView.setFillColor(color2);
            }
        }
        this.invalidate();
    }

    public IndicatorType getIndicatorType() {
        return this.mType;
    }

    public void setIndicatorType(IndicatorType mType) {
        this.mType = mType;
        this.invalidate();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        View subView = this.getChildAt(0);
        this.removeView(subView);
        this.mScrollView.addView(subView);
        this.mContainer.addView((View)this.mScrollView, 0);
        switch (this.mType) {
            case Text: {
                this.mContainer.addView((View)this.mVerticalTextView);
                break;
            }
            case Graphic: {
                this.mContainer.addView((View)this.mVerticalGraphicView);
            }
        }
        this.addView((View)this.mContainer);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (changed) {
            int containerHeight = this.getMeasuredHeight();
            View view = this.mScrollView.getChildAt(0);
            if (view != null) {
                int contentHeight = view.getMeasuredHeight();
                this.indicatorVisibility = contentHeight > containerHeight ? 0 : 8;
                switch (this.mType) {
                    case Text: {
                        this.mVerticalTextView.setVisibility(this.indicatorVisibility);
                        break;
                    }
                    case Graphic: {
                        this.mVerticalGraphicView.setVisibility(this.indicatorVisibility);
                    }
                }
            }
        }
    }

    public static enum IndicatorType {
        Text(0),
        Graphic(1);

        public final int value;

        private IndicatorType(int value) {
            this.value = value;
        }

        public static IndicatorType fromValue(int value) {
            for (IndicatorType type : IndicatorType.values()) {
                if (type.value != value) continue;
                return type;
            }
            return null;
        }
    }
}

