/*
 * Decompiled with CFR 0.152.
 */
package com.yinglan.keyboard;

import android.app.Activity;
import android.app.Dialog;
import android.graphics.Rect;
import android.os.IBinder;
import android.support.v7.widget.RecyclerView;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.AbsListView;
import android.widget.EditText;
import android.widget.ScrollView;
import android.widget.TextView;

public class HideUtil {
    public static void init(Activity activity) {
        new HideUtil(activity, null);
    }

    public static void init(Activity activity, ViewGroup content) {
        new HideUtil(activity, content);
    }

    public static void hideSoftKeyboard(Activity activity) {
        if (null == activity) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
        }
        View view = activity.getCurrentFocus();
        if (null != view) {
            InputMethodManager inputMethodManager = (InputMethodManager)activity.getSystemService("input_method");
            inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 2);
        }
    }

    public static void hideSoftKeyboard(View view) {
        if (null == view) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
        }
        InputMethodManager inputMethodManager = (InputMethodManager)view.getContext().getSystemService("input_method");
        inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 2);
    }

    public static void hideDialogSoftKeyboard(Dialog dialog) {
        if (null == dialog) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
        }
        View view = dialog.getCurrentFocus();
        if (null != view) {
            InputMethodManager inputMethodManager = (InputMethodManager)dialog.getContext().getSystemService("input_method");
            inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 2);
        }
    }

    private HideUtil(final Activity activity, ViewGroup content) {
        if (content == null) {
            content = (ViewGroup)activity.findViewById(0x1020002);
        }
        this.getScrollView(content, activity);
        content.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                HideUtil.this.dispatchTouchEvent(activity, motionEvent);
                return false;
            }
        });
    }

    private void getScrollView(ViewGroup viewGroup, final Activity activity) {
        if (null == viewGroup) {
            return;
        }
        int count = viewGroup.getChildCount();
        for (int i = 0; i < count; ++i) {
            ScrollView newDtv;
            View view = viewGroup.getChildAt(i);
            if (view instanceof ScrollView) {
                newDtv = (ScrollView)view;
                newDtv.setOnTouchListener(new View.OnTouchListener(){

                    public boolean onTouch(View view, MotionEvent motionEvent) {
                        HideUtil.this.dispatchTouchEvent(activity, motionEvent);
                        return false;
                    }
                });
            } else if (view instanceof AbsListView) {
                newDtv = (AbsListView)view;
                newDtv.setOnTouchListener(new View.OnTouchListener(){

                    public boolean onTouch(View view, MotionEvent motionEvent) {
                        HideUtil.this.dispatchTouchEvent(activity, motionEvent);
                        return false;
                    }
                });
            } else if (view instanceof RecyclerView) {
                newDtv = (RecyclerView)view;
                newDtv.setOnTouchListener(new View.OnTouchListener(){

                    public boolean onTouch(View view, MotionEvent motionEvent) {
                        HideUtil.this.dispatchTouchEvent(activity, motionEvent);
                        return false;
                    }
                });
            } else if (view instanceof ViewGroup) {
                this.getScrollView((ViewGroup)view, activity);
            }
            if (!view.isClickable() || !(view instanceof TextView) || view instanceof EditText) continue;
            view.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View view, MotionEvent motionEvent) {
                    HideUtil.this.dispatchTouchEvent(activity, motionEvent);
                    return false;
                }
            });
        }
    }

    public boolean dispatchTouchEvent(Activity mActivity, MotionEvent ev) {
        View v;
        if (ev.getAction() == 0 && null != (v = mActivity.getCurrentFocus()) && this.isShouldHideInput(v, ev)) {
            this.hideSoftInput(mActivity, v.getWindowToken());
        }
        return false;
    }

    private boolean isShouldHideInput(View v, MotionEvent event) {
        if (v instanceof EditText) {
            Rect rect = new Rect();
            v.getHitRect(rect);
            if (rect.contains((int)event.getX(), (int)event.getY())) {
                return false;
            }
        }
        return true;
    }

    private void hideSoftInput(Activity mActivity, IBinder token) {
        if (token != null) {
            InputMethodManager im = (InputMethodManager)mActivity.getSystemService("input_method");
            im.hideSoftInputFromWindow(token, 2);
        }
    }
}

