/*
 * Decompiled with CFR 0.152.
 */
package com.yinglan.keyboard;

import android.app.Activity;
import android.graphics.Rect;
import android.os.IBinder;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;

public class HideUtil {
    public static void init(Activity activity) {
        new HideUtil(activity);
    }

    private HideUtil(final Activity activity) {
        ViewGroup contentParent = (ViewGroup)activity.findViewById(0x1020002);
        contentParent.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                HideUtil.this.dispatchTouchEvent(activity, motionEvent);
                return false;
            }
        });
    }

    public boolean dispatchTouchEvent(Activity mActivity, MotionEvent ev) {
        View v;
        if (ev.getAction() == 0 && null != (v = mActivity.getCurrentFocus()) && this.isShouldHideInput(v, ev)) {
            this.hideSoftInput(mActivity, v.getWindowToken());
        }
        return false;
    }

    private boolean isShouldHideInput(View v, MotionEvent event) {
        if (v instanceof EditText) {
            Rect rect = new Rect();
            v.getHitRect(rect);
            if (rect.contains((int)event.getX(), (int)event.getY())) {
                return false;
            }
        }
        return true;
    }

    private void hideSoftInput(Activity mActivity, IBinder token) {
        if (token != null) {
            InputMethodManager im = (InputMethodManager)mActivity.getSystemService("input_method");
            im.hideSoftInputFromWindow(token, 2);
        }
    }
}

