/*
 * Decompiled with CFR 0.152.
 */
package com.yinglan.imageloadingview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

public class ImageLoadingView
extends View {
    private final String TAG = ImageLoadingView.class.getSimpleName();
    private Paint mPaint1;
    private Paint mPaint2;
    private Context mContext;
    private double percent = 0.083;
    private float interval;
    private float radius;
    private int type = 1;

    public ImageLoadingView(Context context) {
        this(context, null);
    }

    public ImageLoadingView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ImageLoadingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs);
    }

    private void initView(Context context, AttributeSet attrs) {
        this.mContext = context;
        if (null == attrs && !(this.getLayoutParams() instanceof FrameLayout.LayoutParams)) {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(this.dip2Px(50.0f), this.dip2Px(50.0f), 17);
            this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        this.mPaint1 = new Paint();
        this.mPaint1.setAntiAlias(true);
        this.mPaint1.setColor(-1);
        this.mPaint2 = new Paint();
        this.mPaint2.setAntiAlias(true);
        this.mPaint2.setStyle(Paint.Style.STROKE);
        this.mPaint2.setColor(-1);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.radius = this.getWidth() >= this.getHeight() ? (float)this.getHeight() : (float)this.getWidth();
        this.interval = (float)((double)this.radius * 0.06);
        this.mPaint2.setStrokeWidth(this.interval / 3.0f);
        RectF localRect = new RectF((float)(this.getWidth() / 2) - this.radius / 2.0f + this.interval, (float)(this.getHeight() / 2) - this.radius / 2.0f + this.interval, (float)(this.getWidth() / 2) + this.radius / 2.0f - this.interval, (float)(this.getHeight() / 2) + this.radius / 2.0f - this.interval);
        float f1 = (float)(this.percent * 360.0);
        if (this.type == 0 && this.percent == 1.0) {
            Path path = new Path();
            path.moveTo((float)(this.getWidth() / 2) - this.radius * 0.7f / 6.0f, (float)((double)(this.getHeight() / 2) + 1.732 * (double)this.radius / 6.0));
            path.lineTo((float)(this.getWidth() / 2) + this.radius / 3.0f, (float)(this.getHeight() / 2));
            path.lineTo((float)(this.getWidth() / 2) - this.radius * 0.7f / 6.0f, (float)((double)(this.getHeight() / 2) - 1.732 * (double)this.radius / 6.0));
            path.close();
            canvas.drawPath(path, this.mPaint1);
        } else {
            canvas.drawArc(localRect, -90.0f, f1, true, this.mPaint1);
        }
        canvas.save();
        canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), this.radius / 2.0f - this.interval / 3.0f, this.mPaint2);
        canvas.restore();
    }

    public void setProgress(double progress) {
        if (progress == 0.0) {
            progress = 0.083;
        } else if ((progress < 0.0 || progress >= 1.0) && 1 == this.type) {
            this.setVisibility(8);
            return;
        }
        this.setVisibility(0);
        this.percent = progress;
        this.invalidate();
    }

    public void loadCompleted() {
        this.setVisibility(8);
    }

    public void loadCompleted(int type) {
        this.type = type;
        this.setProgress(1.0);
    }

    public void loadFaild() {
        this.setProgress(1.0);
        this.setVisibility(8);
    }

    public void setOutsideCircleColor(int color) {
        this.mPaint2.setColor(color);
    }

    public void setInsideCircleColor(int color) {
        this.mPaint1.setColor(color);
    }

    public void setTargetView(View target) {
        if (this.getParent() != null) {
            ((ViewGroup)this.getParent()).removeView((View)this);
        }
        if (target == null) {
            return;
        }
        if (target.getParent() instanceof FrameLayout) {
            ((FrameLayout)target.getParent()).addView((View)this);
        } else if (target.getParent() instanceof ViewGroup) {
            ViewGroup parentContainer = (ViewGroup)target.getParent();
            int groupIndex = parentContainer.indexOfChild(target);
            parentContainer.removeView(target);
            FrameLayout badgeContainer = new FrameLayout(this.getContext());
            ViewGroup.LayoutParams parentLayoutParams = target.getLayoutParams();
            badgeContainer.setLayoutParams(parentLayoutParams);
            target.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            parentContainer.addView((View)badgeContainer, groupIndex, parentLayoutParams);
            badgeContainer.addView(target);
            badgeContainer.addView((View)this);
        } else if (target.getParent() == null) {
            // empty if block
        }
    }

    private int dip2Px(float dip) {
        return (int)(dip * this.getContext().getResources().getDisplayMetrics().density + 0.5f);
    }

    public static class ViewType {
        public static final int VIDEO = 0;
        public static final int IMAGE = 1;
    }
}

