/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.inter.security.encrypt;

import com.yeepay.yop.sdk.auth.credentials.PKICredentialsItem;
import com.yeepay.yop.sdk.auth.credentials.YopPKICredentials;
import com.yeepay.yop.sdk.auth.credentials.YopPlatformCredentials;
import com.yeepay.yop.sdk.base.security.encrypt.YopEncryptorAdaptor;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.inter.utils.RSA;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptions;
import com.yeepay.yop.sdk.utils.Encodes;
import com.yeepay.yop.sdk.utils.RandomUtils;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;

public class YopRsaEncryptor
extends YopEncryptorAdaptor {
    private static final String ENCRYPT_ALG = "RSA";

    public List<String> supportedAlgs() {
        return Collections.singletonList(ENCRYPT_ALG);
    }

    public EncryptOptions doInitEncryptOptions(String encryptAlg) throws Exception {
        KeyPair keyPair = this.generateRandomKey();
        return new EncryptOptions((Object)keyPair.getPublic(), ENCRYPT_ALG, encryptAlg, Encodes.encodeUrlSafeBase64((byte[])RandomUtils.secureRandom().generateSeed(16)), Encodes.encodeUrlSafeBase64((byte[])"yop".getBytes("UTF-8")));
    }

    private KeyPair generateRandomKey() throws NoSuchAlgorithmException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(ENCRYPT_ALG);
        kpg.initialize(2048);
        return kpg.genKeyPair();
    }

    public byte[] encrypt(byte[] plain, EncryptOptions options) {
        try {
            return RSA.encrypt(plain, ((PKICredentialsItem)((YopPlatformCredentials)options.getCredentials()).getCredential()).getPublicKey());
        }
        catch (Throwable e) {
            throw new YopClientException("error happened when encrypt with RSA alg", e);
        }
    }

    public InputStream encrypt(InputStream plain, EncryptOptions options) {
        return null;
    }

    public byte[] decrypt(byte[] cipher, EncryptOptions options) {
        try {
            return RSA.decrypt(cipher, ((YopPKICredentials)options.getCredentials()).getCredential().getPrivateKey());
        }
        catch (Throwable e) {
            throw new YopClientException("error happened when decrypt with RSA alg", e);
        }
    }

    public InputStream decrypt(InputStream cipher, EncryptOptions options) {
        return null;
    }
}

