/*
 * Decompiled with CFR 0.152.
 */
package com.ycl.tabview.library;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.ycl.tabview.library.R;
import com.ycl.tabview.library.TabViewChild;
import com.ycl.tabview.library.TabViewUtil;
import java.util.ArrayList;
import java.util.List;

public class TabView
extends RelativeLayout {
    private static final int RMP = -1;
    private static final int RWC = -2;
    private static final int LWC = -2;
    private static final int LMP = -1;
    private int mTextViewSelColor;
    private int mTextViewUnSelColor;
    private int mTabViewBackgroundColor;
    private int mTabViewHeight;
    private int mImageViewTextViewMargin;
    private int mTextViewSize;
    private int mImageViewWidth;
    private int mImageViewHeight;
    private List<TabViewChild> mTabViewChildList;
    private int mTabViewGravity = 80;
    private int mTabViewDefaultPosition = 0;
    private LinearLayout tabview;
    private List<Integer> unselectedIconList;
    private FrameLayout mFragmentContainer;
    private FragmentManager mSupportFragmentManager;
    private Fragment[] mFragments;
    private int index = 0;
    private int currentTabIndex;
    private OnTabChildClickListener listener = null;

    public TabView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TabView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initDefaultAttrs(context);
        this.initCustomAttrs(context, attrs);
        this.initView(context);
    }

    private void initDefaultAttrs(Context context) {
        this.mTextViewSelColor = Color.rgb((int)252, (int)88, (int)17);
        this.mTextViewUnSelColor = Color.rgb((int)129, (int)130, (int)149);
        this.mTabViewBackgroundColor = Color.rgb((int)255, (int)255, (int)255);
        this.mTabViewHeight = TabViewUtil.dp2px(context, 52.0f);
        this.mImageViewTextViewMargin = TabViewUtil.dp2px(context, 2.0f);
        this.mTextViewSize = TabViewUtil.sp2px(context, 14.0f);
        this.mImageViewWidth = TabViewUtil.dp2px(context, 30.0f);
        this.mImageViewHeight = TabViewUtil.dp2px(context, 30.0f);
    }

    private void initCustomAttrs(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.TabView);
        int N = typedArray.getIndexCount();
        for (int i = 0; i < N; ++i) {
            this.initCustomAttr(typedArray.getIndex(i), typedArray);
        }
        typedArray.recycle();
    }

    private void initCustomAttr(int attr, TypedArray typedArray) {
        if (attr == R.styleable.TabView_tab_textViewSelColor) {
            this.mTextViewSelColor = typedArray.getColor(attr, this.mTextViewSelColor);
        } else if (attr == R.styleable.TabView_tab_textViewUnSelColor) {
            this.mTextViewUnSelColor = typedArray.getColor(attr, this.mTextViewUnSelColor);
        } else if (attr == R.styleable.TabView_tab_tabViewBackgroundColor) {
            this.mTabViewBackgroundColor = typedArray.getColor(attr, this.mTabViewBackgroundColor);
        } else if (attr == R.styleable.TabView_tab_tabViewHeight) {
            this.mTabViewHeight = typedArray.getDimensionPixelSize(attr, this.mTabViewHeight);
        } else if (attr == R.styleable.TabView_imageViewTextViewMargin) {
            this.mImageViewTextViewMargin = typedArray.getDimensionPixelSize(attr, this.mImageViewTextViewMargin);
        } else if (attr == R.styleable.TabView_tab_textViewSize) {
            this.mTextViewSize = typedArray.getDimensionPixelSize(attr, this.mTextViewSize);
        } else if (attr == R.styleable.TabView_tab_imageViewWidth) {
            this.mImageViewWidth = typedArray.getDimensionPixelSize(attr, this.mImageViewWidth);
        } else if (attr == R.styleable.TabView_tab_imageViewHeight) {
            this.mImageViewHeight = typedArray.getDimensionPixelSize(attr, this.mImageViewHeight);
        } else if (attr == R.styleable.TabView_tab_tabViewGravity) {
            this.mTabViewGravity = typedArray.getInt(attr, this.mTabViewGravity);
        } else if (attr == R.styleable.TabView_tab_tabViewDefaultPosition) {
            this.mTabViewDefaultPosition = typedArray.getInteger(attr, this.mTabViewDefaultPosition);
        }
    }

    private void initView(Context context) {
        this.tabview = new LinearLayout(context);
        this.tabview.setId(R.id.tabview_id);
        this.mFragmentContainer = new FrameLayout(context);
        this.mFragmentContainer.setId(R.id.tabview_fragment_container);
        RelativeLayout.LayoutParams fragmentContainerParams = new RelativeLayout.LayoutParams(-1, -1);
        RelativeLayout.LayoutParams tabviewParams = null;
        if (this.mTabViewGravity == 80) {
            tabviewParams = new RelativeLayout.LayoutParams(-1, this.mTabViewHeight);
            this.tabview.setOrientation(0);
            tabviewParams.addRule(12);
            fragmentContainerParams.addRule(2, R.id.tabview_id);
        } else if (this.mTabViewGravity == 3) {
            tabviewParams = new RelativeLayout.LayoutParams(this.mTabViewHeight, -1);
            this.tabview.setOrientation(1);
            tabviewParams.addRule(9);
            fragmentContainerParams.addRule(1, R.id.tabview_id);
        } else if (this.mTabViewGravity == 48) {
            tabviewParams = new RelativeLayout.LayoutParams(-1, this.mTabViewHeight);
            this.tabview.setOrientation(0);
            tabviewParams.addRule(10);
            fragmentContainerParams.addRule(3, R.id.tabview_id);
        } else if (this.mTabViewGravity == 5) {
            tabviewParams = new RelativeLayout.LayoutParams(this.mTabViewHeight, -1);
            this.tabview.setOrientation(1);
            tabviewParams.addRule(11);
            fragmentContainerParams.addRule(0, R.id.tabview_id);
        }
        this.tabview.setLayoutParams((ViewGroup.LayoutParams)tabviewParams);
        this.tabview.setBackgroundColor(this.mTabViewBackgroundColor);
        this.mFragmentContainer.setLayoutParams((ViewGroup.LayoutParams)fragmentContainerParams);
        this.addView((View)this.tabview);
        this.addView((View)this.mFragmentContainer);
    }

    private void initTabChildView() {
        TabViewChild t;
        int i;
        this.tabview.removeAllViews();
        this.unselectedIconList = new ArrayList<Integer>();
        this.mFragments = new Fragment[this.mTabViewChildList.size()];
        for (i = 0; i < this.mFragments.length; ++i) {
            t = this.mTabViewChildList.get(i);
            this.mFragments[i] = t.getmFragment();
        }
        if (this.mTabViewDefaultPosition >= this.mTabViewChildList.size()) {
            this.mSupportFragmentManager.beginTransaction().add(R.id.tabview_fragment_container, this.mFragments[0]).show(this.mFragments[0]).commit();
        } else {
            this.mSupportFragmentManager.beginTransaction().add(R.id.tabview_fragment_container, this.mFragments[this.mTabViewDefaultPosition]).show(this.mFragments[this.mTabViewDefaultPosition]).commit();
        }
        for (i = 0; i < this.mTabViewChildList.size(); ++i) {
            t = this.mTabViewChildList.get(i);
            LinearLayout tabChild = new LinearLayout(this.getContext());
            tabChild.setGravity(17);
            tabChild.setOrientation(1);
            LinearLayout.LayoutParams tabChildParams = null;
            if (this.mTabViewGravity == 80) {
                tabChildParams = new LinearLayout.LayoutParams(0, -1, 1.0f);
                tabChildParams.gravity = 1;
            } else if (this.mTabViewGravity == 3) {
                tabChildParams = new LinearLayout.LayoutParams(-1, 0, 1.0f);
                tabChildParams.gravity = 16;
            } else if (this.mTabViewGravity == 48) {
                tabChildParams = new LinearLayout.LayoutParams(0, -1, 1.0f);
                tabChildParams.gravity = 1;
            } else if (this.mTabViewGravity == 5) {
                tabChildParams = new LinearLayout.LayoutParams(-1, 0, 1.0f);
                tabChildParams.gravity = 16;
            }
            tabChild.setLayoutParams((ViewGroup.LayoutParams)tabChildParams);
            final ImageView imageview = new ImageView(this.getContext());
            LinearLayout.LayoutParams ivParams = new LinearLayout.LayoutParams(this.mImageViewWidth, this.mImageViewHeight);
            ivParams.gravity = 17;
            imageview.setLayoutParams((ViewGroup.LayoutParams)ivParams);
            imageview.setImageResource(t.getImageViewUnSelIcon());
            this.unselectedIconList.add(t.getImageViewUnSelIcon());
            tabChild.addView((View)imageview);
            final TextView textview = new TextView(this.getContext());
            textview.setText((CharSequence)t.getTextViewText());
            textview.setTextColor(this.mTextViewUnSelColor);
            textview.setTextSize(0, (float)this.mTextViewSize);
            LinearLayout.LayoutParams textviewParams = new LinearLayout.LayoutParams(-2, -2);
            textviewParams.gravity = 17;
            textviewParams.topMargin = this.mImageViewTextViewMargin;
            textview.setLayoutParams((ViewGroup.LayoutParams)textviewParams);
            tabChild.addView((View)textview);
            this.tabview.addView((View)tabChild);
            final int currentPosition = i;
            if (this.mTabViewDefaultPosition >= this.mTabViewChildList.size()) {
                if (i == 0) {
                    imageview.setImageResource(t.getImageViewSelIcon());
                    textview.setText((CharSequence)t.getTextViewText());
                    textview.setTextColor(this.mTextViewSelColor);
                }
            } else if (this.mTabViewDefaultPosition == i) {
                imageview.setImageResource(t.getImageViewSelIcon());
                textview.setText((CharSequence)t.getTextViewText());
                textview.setTextColor(this.mTextViewSelColor);
            }
            tabChild.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    TabView.this.reSetAll();
                    imageview.setImageResource(t.getImageViewSelIcon());
                    textview.setText((CharSequence)t.getTextViewText());
                    textview.setTextColor(TabView.this.mTextViewSelColor);
                    TabView.this.index = currentPosition;
                    TabView.this.showOrHide();
                    if (TabView.this.listener != null) {
                        TabView.this.listener.onTabChildClick(currentPosition, imageview, textview);
                    }
                }
            });
        }
    }

    public void setTabViewChild(List<TabViewChild> tabViewChildList, FragmentManager supportFragmentManager) {
        this.mTabViewChildList = tabViewChildList;
        this.mSupportFragmentManager = supportFragmentManager;
        if (this.mTabViewDefaultPosition >= tabViewChildList.size()) {
            this.index = 0;
            this.currentTabIndex = 0;
            this.mTabViewDefaultPosition = 0;
        }
        this.initTabChildView();
    }

    public void setTabViewDefaultPosition(int position) {
        this.mTabViewDefaultPosition = position;
        this.index = position;
        this.currentTabIndex = position;
    }

    private void reSetAll() {
        for (int i = 0; i < this.tabview.getChildCount(); ++i) {
            LinearLayout tabChild = (LinearLayout)this.tabview.getChildAt(i);
            for (int j = 0; j < tabChild.getChildCount(); ++j) {
                ImageView iv = (ImageView)tabChild.getChildAt(0);
                TextView tv = (TextView)tabChild.getChildAt(1);
                iv.setImageResource(this.unselectedIconList.get(i).intValue());
                tv.setTextColor(this.mTextViewUnSelColor);
            }
        }
    }

    public void setOnTabChildClickListener(OnTabChildClickListener l) {
        this.listener = l;
    }

    private void showOrHide() {
        if (this.currentTabIndex != this.index) {
            FragmentTransaction trx = this.mSupportFragmentManager.beginTransaction();
            trx.hide(this.mFragments[this.currentTabIndex]);
            if (!this.mFragments[this.index].isAdded()) {
                trx.add(R.id.tabview_fragment_container, this.mFragments[this.index]);
            }
            trx.show(this.mFragments[this.index]).commitAllowingStateLoss();
        }
        this.currentTabIndex = this.index;
    }

    public void setTextViewSelectedColor(int color) {
        this.mTextViewSelColor = color;
    }

    public void setTextViewUnSelectedColor(int color) {
        this.mTextViewUnSelColor = color;
    }

    public void setTabViewBackgroundColor(int color) {
        this.mTabViewBackgroundColor = color;
        this.tabview.setBackgroundColor(color);
    }

    public void setTabViewHeight(int height) {
        this.mTabViewHeight = height;
    }

    public void setImageViewTextViewMargin(int margin) {
        this.mImageViewTextViewMargin = margin;
    }

    public void setTextViewSize(int size) {
        this.mTextViewSize = TabViewUtil.sp2px(this.getContext(), size);
    }

    public void setImageViewWidth(int width) {
        this.mImageViewWidth = width;
    }

    public void setImageViewHeight(int height) {
        this.mImageViewHeight = height;
    }

    public void setTabViewGravity(int gravity) {
        this.mTabViewGravity = gravity;
    }

    public static interface OnTabChildClickListener {
        public void onTabChildClick(int var1, ImageView var2, TextView var3);
    }
}

