/*
 * Decompiled with CFR 0.152.
 */
package com.yarolegovich.slidingrootnav;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.LayoutRes;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.app.ActionBarDrawerToggle;
import android.support.v7.widget.Toolbar;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.yarolegovich.slidingrootnav.R;
import com.yarolegovich.slidingrootnav.SlideGravity;
import com.yarolegovich.slidingrootnav.SlidingRootNav;
import com.yarolegovich.slidingrootnav.SlidingRootNavLayout;
import com.yarolegovich.slidingrootnav.callback.DragListener;
import com.yarolegovich.slidingrootnav.callback.DragStateListener;
import com.yarolegovich.slidingrootnav.transform.CompositeTransformation;
import com.yarolegovich.slidingrootnav.transform.ElevationTransformation;
import com.yarolegovich.slidingrootnav.transform.RootTransformation;
import com.yarolegovich.slidingrootnav.transform.ScaleTransformation;
import com.yarolegovich.slidingrootnav.transform.YTranslationTransformation;
import com.yarolegovich.slidingrootnav.util.ActionBarToggleAdapter;
import com.yarolegovich.slidingrootnav.util.DrawerListenerAdapter;
import com.yarolegovich.slidingrootnav.util.HiddenMenuClickConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SlidingRootNavBuilder {
    private static final float DEFAULT_END_SCALE = 0.65f;
    private static final int DEFAULT_END_ELEVATION_DP = 8;
    private static final int DEFAULT_DRAG_DIST_DP = 180;
    private Activity activity;
    private ViewGroup contentView;
    private View menuView;
    private int menuLayoutRes;
    private List<RootTransformation> transformations;
    private List<DragListener> dragListeners;
    private List<DragStateListener> dragStateListeners;
    private int dragDistance;
    private Toolbar toolbar;
    private SlideGravity gravity;
    private boolean isMenuOpened;
    private boolean isMenuLocked;
    private boolean isContentClickableWhenMenuOpened;
    private Bundle savedState;

    public SlidingRootNavBuilder(Activity activity) {
        this.activity = activity;
        this.transformations = new ArrayList<RootTransformation>();
        this.dragListeners = new ArrayList<DragListener>();
        this.dragStateListeners = new ArrayList<DragStateListener>();
        this.gravity = SlideGravity.LEFT;
        this.dragDistance = this.dpToPx(180);
        this.isContentClickableWhenMenuOpened = true;
    }

    public SlidingRootNavBuilder withMenuView(View view) {
        this.menuView = view;
        return this;
    }

    public SlidingRootNavBuilder withMenuLayout(@LayoutRes int layout) {
        this.menuLayoutRes = layout;
        return this;
    }

    public SlidingRootNavBuilder withToolbarMenuToggle(Toolbar tb) {
        this.toolbar = tb;
        return this;
    }

    public SlidingRootNavBuilder withGravity(SlideGravity g) {
        this.gravity = g;
        return this;
    }

    public SlidingRootNavBuilder withContentView(ViewGroup cv) {
        this.contentView = cv;
        return this;
    }

    public SlidingRootNavBuilder withMenuLocked(boolean locked) {
        this.isMenuLocked = locked;
        return this;
    }

    public SlidingRootNavBuilder withSavedState(Bundle state) {
        this.savedState = state;
        return this;
    }

    public SlidingRootNavBuilder withMenuOpened(boolean opened) {
        this.isMenuOpened = opened;
        return this;
    }

    public SlidingRootNavBuilder withContentClickableWhenMenuOpened(boolean clickable) {
        this.isContentClickableWhenMenuOpened = clickable;
        return this;
    }

    public SlidingRootNavBuilder withDragDistance(int dp) {
        return this.withDragDistancePx(this.dpToPx(dp));
    }

    public SlidingRootNavBuilder withDragDistancePx(int px) {
        this.dragDistance = px;
        return this;
    }

    public SlidingRootNavBuilder withRootViewScale(@FloatRange(from=0.009999999776482582) float scale) {
        this.transformations.add(new ScaleTransformation(scale));
        return this;
    }

    public SlidingRootNavBuilder withRootViewElevation(@IntRange(from=0L) int elevation) {
        return this.withRootViewElevationPx(this.dpToPx(elevation));
    }

    public SlidingRootNavBuilder withRootViewElevationPx(@IntRange(from=0L) int elevation) {
        this.transformations.add(new ElevationTransformation(elevation));
        return this;
    }

    public SlidingRootNavBuilder withRootViewYTranslation(int translation) {
        return this.withRootViewYTranslationPx(this.dpToPx(translation));
    }

    public SlidingRootNavBuilder withRootViewYTranslationPx(int translation) {
        this.transformations.add(new YTranslationTransformation(translation));
        return this;
    }

    public SlidingRootNavBuilder addRootTransformation(RootTransformation transformation) {
        this.transformations.add(transformation);
        return this;
    }

    public SlidingRootNavBuilder addDragListener(DragListener dragListener) {
        this.dragListeners.add(dragListener);
        return this;
    }

    public SlidingRootNavBuilder addDragStateListener(DragStateListener dragStateListener) {
        this.dragStateListeners.add(dragStateListener);
        return this;
    }

    public SlidingRootNav inject() {
        ViewGroup contentView = this.getContentView();
        View oldRoot = contentView.getChildAt(0);
        contentView.removeAllViews();
        SlidingRootNavLayout newRoot = this.createAndInitNewRoot(oldRoot);
        View menu = this.getMenuViewFor(newRoot);
        this.initToolbarMenuVisibilityToggle(newRoot, menu);
        HiddenMenuClickConsumer clickConsumer = new HiddenMenuClickConsumer((Context)this.activity);
        clickConsumer.setMenuHost(newRoot);
        newRoot.addView(menu);
        newRoot.addView(clickConsumer);
        newRoot.addView(oldRoot);
        contentView.addView((View)newRoot);
        if (this.savedState == null && this.isMenuOpened) {
            newRoot.openMenu(false);
        }
        newRoot.setMenuLocked(this.isMenuLocked);
        return newRoot;
    }

    private SlidingRootNavLayout createAndInitNewRoot(View oldRoot) {
        SlidingRootNavLayout newRoot = new SlidingRootNavLayout((Context)this.activity);
        newRoot.setId(R.id.srn_root_layout);
        newRoot.setRootTransformation(this.createCompositeTransformation());
        newRoot.setMaxDragDistance(this.dragDistance);
        newRoot.setGravity(this.gravity);
        newRoot.setRootView(oldRoot);
        newRoot.setContentClickableWhenMenuOpened(this.isContentClickableWhenMenuOpened);
        for (DragListener dragListener : this.dragListeners) {
            newRoot.addDragListener(dragListener);
        }
        for (DragStateListener dragStateListener : this.dragStateListeners) {
            newRoot.addDragStateListener(dragStateListener);
        }
        return newRoot;
    }

    private ViewGroup getContentView() {
        if (this.contentView == null) {
            this.contentView = (ViewGroup)this.activity.findViewById(0x1020002);
        }
        if (this.contentView.getChildCount() != 1) {
            throw new IllegalStateException(this.activity.getString(R.string.srn_ex_bad_content_view));
        }
        return this.contentView;
    }

    private View getMenuViewFor(SlidingRootNavLayout parent) {
        if (this.menuView == null) {
            if (this.menuLayoutRes == 0) {
                throw new IllegalStateException(this.activity.getString(R.string.srn_ex_no_menu_view));
            }
            this.menuView = LayoutInflater.from((Context)this.activity).inflate(this.menuLayoutRes, (ViewGroup)parent, false);
        }
        return this.menuView;
    }

    private RootTransformation createCompositeTransformation() {
        if (this.transformations.isEmpty()) {
            return new CompositeTransformation(Arrays.asList(new ScaleTransformation(0.65f), new ElevationTransformation(this.dpToPx(8))));
        }
        return new CompositeTransformation(this.transformations);
    }

    protected void initToolbarMenuVisibilityToggle(SlidingRootNavLayout sideNav, View drawer) {
        if (this.toolbar != null) {
            ActionBarToggleAdapter dlAdapter = new ActionBarToggleAdapter((Context)this.activity);
            dlAdapter.setAdaptee(sideNav);
            ActionBarDrawerToggle toggle = new ActionBarDrawerToggle(this.activity, (DrawerLayout)dlAdapter, this.toolbar, R.string.srn_drawer_open, R.string.srn_drawer_close);
            toggle.syncState();
            DrawerListenerAdapter listenerAdapter = new DrawerListenerAdapter((DrawerLayout.DrawerListener)toggle, drawer);
            sideNav.addDragListener(listenerAdapter);
            sideNav.addDragStateListener(listenerAdapter);
        }
    }

    private int dpToPx(int dp) {
        return Math.round(this.activity.getResources().getDisplayMetrics().density * (float)dp);
    }
}

